/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
import { PluginSettings, SpotFleetRequestConfiguration, SpotFleetTagSpecification, LaunchTemplateConfig, LaunchTemplateSpecification, LaunchTemplateOverrides } from './types';
/**
 * Convert the configuration we received from ConfigureSpotEventPlugin construct to the fromat expected by the Spot Event Plugin.
 * boolean and number properties get converted into strings when passed to the Lambda,
 * so we need to restore the original types.
 */
export declare function convertSpotFleetRequestConfiguration(spotFleetRequestConfigs: SpotFleetRequestConfiguration): SpotFleetRequestConfiguration;
/**
 * Convert the configuration we received from ConfigureSpotEventPlugin construct to the fromat expected by the Spot Event Plugin.
 * boolean and number properties get converted into strings when passed to the Lambda,
 * so we need to restore the original types.
 */
export declare function convertSpotEventPluginSettings(pluginOptions: PluginSettings): PluginSettings;
export declare function validateArray(input: any, propertyName: string): void;
export declare function validateProperty(isValid: (input: any) => boolean, property: any, propertyName: string): void;
export declare function isValidTagSpecification(tagSpecification: SpotFleetTagSpecification): boolean;
export declare function convertTagSpecifications(tagSpecifications: SpotFleetTagSpecification[], propertyName: string): SpotFleetTagSpecification[];
export declare function validateLaunchTemplateSpecification(launchTemplateSpecification: LaunchTemplateSpecification, propertyName: string): void;
export declare function validateLaunchTemplateOverrides(launchTemplateOverrides: LaunchTemplateOverrides, propertyName: string): void;
export declare function validateLaunchTemplateConfigs(launchTemplateConfigs: LaunchTemplateConfig[], propertyName: string): LaunchTemplateConfig[];
export declare function convertToInt(value: any, propertyName: string): number;
export declare function convertToBoolean(value: any, propertyName: string): boolean;
export declare function validateString(value: any, propertyName: string): string;
export declare function validateStringOptional(value: any, propertyName: string): string | undefined;
