"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.tagConstruct = exports.RFDK_VERSION = exports.tagFields = void 0;
const path = require("path");
const core_1 = require("@aws-cdk/core");
/**
 * The name of the tag used to associate the RFDK version and construct that deploys a given resources.
 */
const TAG_NAME = 'aws-rfdk';
/**
 * Returns the fields to be used for tagging AWS resources for a given construct
 *
 * @param scope The construct instance whose underlying resources should be tagged
 */
function tagFields(scope) {
    const className = scope.constructor.name;
    return {
        name: TAG_NAME,
        value: `${exports.RFDK_VERSION}:${className}`,
    };
}
exports.tagFields = tagFields;
/**
 * Function that reads in the version of RFDK from the `package.json` file.
 */
function getVersion() {
    return require(path.join(__dirname, '..', '..', '..', 'package.json')).version; // eslint-disable-line @typescript-eslint/no-require-imports
}
/**
 * The RFDK version string as listed in `package.json`
 */
exports.RFDK_VERSION = getVersion();
/**
 * Tags all resources deployed by a construct with the RFDK version and the construct name separated by a colon (":")
 * delimiter.
 *
 * @param scope A construct instance to tag
 */
function tagConstruct(scope) {
    const fields = tagFields(scope);
    core_1.Tags.of(scope).add(fields.name, fields.value);
}
exports.tagConstruct = tagConstruct;
//# sourceMappingURL=data:application/json;base64,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