"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
module.exports = {
    'Origin Access Identity with automatic comment'(test) {
        const stack = new cdk.Stack();
        new lib_1.OriginAccessIdentity(stack, "OAI");
        assert_1.expect(stack).toMatch({
            "Resources": {
                "OAIE1EFC67F": {
                    "Type": "AWS::CloudFront::CloudFrontOriginAccessIdentity",
                    "Properties": {
                        "CloudFrontOriginAccessIdentityConfig": {
                            "Comment": "Allows CloudFront to reach the bucket"
                        }
                    }
                }
            }
        });
        test.done();
    },
    'Origin Access Identity with comment'(test) {
        const stack = new cdk.Stack();
        new lib_1.OriginAccessIdentity(stack, "OAI", {
            comment: "test comment"
        });
        assert_1.expect(stack).toMatch({
            "Resources": {
                "OAIE1EFC67F": {
                    "Type": "AWS::CloudFront::CloudFrontOriginAccessIdentity",
                    "Properties": {
                        "CloudFrontOriginAccessIdentityConfig": {
                            "Comment": "test comment"
                        }
                    }
                }
            }
        });
        test.done();
    },
    'Builds ARN of CloudFront user'(test) {
        const stack = new cdk.Stack();
        const oai = lib_1.OriginAccessIdentity.fromOriginAccessIdentityName(stack, "OAI", "OAITest");
        test.ok(oai.grantPrincipal.policyFragment.principalJson.AWS[0].endsWith(":iam::cloudfront:user/CloudFront Origin Access Identity OAITest"));
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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