"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.RQ_CONNECTION_ASSET = exports.REPO_DC_ASSET = exports.TEST_ASSET = exports.INSTALL_REPOSITORY_ASSET_LINUX = exports.CONFIG_WORKER_ASSET_WINDOWS = exports.CONFIG_WORKER_ASSET_LINUX = exports.CWA_ASSET_LINUX = void 0;
// TODO: Properly import from aws-rfdk. Not ideal
// to use a relative path here.
const assert_1 = require("@aws-cdk/assert");
const asset_constants_1 = require("../../core/test/asset-constants");
Object.defineProperty(exports, "CWA_ASSET_LINUX", { enumerable: true, get: function () { return asset_constants_1.CWA_ASSET_LINUX; } });
// configureWorker.sh
exports.CONFIG_WORKER_ASSET_LINUX = {
    Bucket: 'AssetParameters2435996be08703cd3819e249890abb41cc0860324e5cfe1b5945704934db7101S3BucketB40BB072',
    Key: 'AssetParameters2435996be08703cd3819e249890abb41cc0860324e5cfe1b5945704934db7101S3VersionKey4F3F9A7F',
};
// configureWorker.ps1
exports.CONFIG_WORKER_ASSET_WINDOWS = {
// NOT USED IN ANY TESTS CURRENTLY
};
// installDeadlineRepository.sh
exports.INSTALL_REPOSITORY_ASSET_LINUX = {
    Bucket: assert_1.stringLike('AssetParameters*S3Bucket8EB24E17'),
};
// test.file
exports.TEST_ASSET = {
    Bucket: assert_1.stringLike('AssetParameters*S3Bucket5D5509D9'),
    Key: assert_1.stringLike('AssetParameters*S3VersionKeyF19FF080'),
};
// installRepostitoryDirectConnection
exports.REPO_DC_ASSET = {
    Bucket: assert_1.stringLike('AssetParameters*S3Bucket87338EBD'),
    Key: assert_1.stringLike('AssetParameters*S3VersionKeyB7FF7B3C'),
};
exports.RQ_CONNECTION_ASSET = {
    Bucket: 'AssetParameters63694479464606109bdbd3525fb2bef7b2abfbf196d8a132832c8e5d8a3c4796S3BucketF3231D14',
    Key: 'AssetParameters63694479464606109bdbd3525fb2bef7b2abfbf196d8a132832c8e5d8a3c4796S3VersionKeyE501DFB8',
};
//# sourceMappingURL=data:application/json;base64,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