"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.tagConstruct = exports.RFDK_VERSION = void 0;
const path = require("path");
const core_1 = require("@aws-cdk/core");
/**
 * The name of the tag used to associate the RFDK version and construct that deploys a given resources.
 */
const TAG_NAME = 'aws-rfdk';
/**
 * Function that reads in the version of RFDK from the `package.json` file.
 */
function getVersion() {
    return require(path.join(__dirname, '..', '..', '..', 'package.json')).version; // eslint-disable-line @typescript-eslint/no-require-imports
}
/**
 * The RFDK version string as listed in `package.json`
 */
exports.RFDK_VERSION = getVersion();
/**
 * Tags all resources deployed by a construct with the RFDK version and the construct name separated by a colon (":")
 * delimiter.
 *
 * @param scope A construct instance to tag
 */
function tagConstruct(scope) {
    // The constructor property is a reference to the "function" used to create
    const className = scope.constructor.name;
    const value = `${exports.RFDK_VERSION}:${className}`;
    core_1.Tag.add(scope, TAG_NAME, value);
}
exports.tagConstruct = tagConstruct;
//# sourceMappingURL=data:application/json;base64,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