/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
import { Duration } from '@aws-cdk/core';
/**
 * Enum to describe the time zone property
 */
export declare enum TimeZone {
    /**
     * The Local time zone
     */
    LOCAL = "Local",
    /**
     * The UTC time zone
     */
    UTC = "UTC"
}
/**
 * Class that can build a CloudWatch Agent configuration.
 */
export declare class CloudWatchConfigBuilder {
    private static DEFAULT_STREAM_NAME;
    private static DEFAULT_FLUSH_INTERVAL;
    private static DEFAULT_LOG_TIMEZONE;
    private static CLOUDWATCH_CONFIG_INSTANCE_ID_VARIABLE;
    /**
     * Flush interval of the Cloud Watch Agent (in Seconds)
     */
    readonly logFlushInterval: Duration;
    private cloudWatchFileList;
    /**
     * Constructs
     */
    constructor(logFlushInterval?: Duration);
    /**
     * This method adds the log file path and its associated log group and log stream properties to the list
     * of files which needs to be streamed to cloud watch logs.
     *
     * @param logGroupName - string for the log group name
     * @param logStreamPrefix - string for the log stream prefix. The actual stream name will be appended by instance id
     * @param logFilePath - local file path which needs to be streamed
     * @param timeZone -  the time zone to use when putting timestamps on log events
     */
    addLogsCollectList(logGroupName: string, logStreamPrefix: string, logFilePath: string, timeZone?: TimeZone): void;
    /**
     * The method generates the configuration for log file streaming to be added
     * to CloudWatch Agent Configuration File.
     */
    generateCloudWatchConfiguration(): string;
}
