"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.calculateSha256Hash = void 0;
const crypto_1 = require("crypto");
function calculateSha256Hash(value) {
    // eslint-disable-next-line no-shadow
    function _updateHashWithValue(hash, value) {
        if (Array.isArray(value)) {
            for (const item of value) {
                _updateHashWithValue(hash, item);
            }
        }
        else if (typeof value === 'object') {
            for (const [key, item] of Object.entries(value).sort()) {
                hash.update(key);
                _updateHashWithValue(hash, item);
            }
        }
        else if (typeof value === 'number') {
            hash.update(value.toString());
        }
        else if (typeof value === 'string') {
            hash.update(value);
        }
        else {
            throw new Error(`Unexpected value type: ${typeof (value)}`);
        }
    }
    const hash = crypto_1.createHash('sha256');
    _updateHashWithValue(hash, value);
    return hash.digest().toString('hex');
}
exports.calculateSha256Hash = calculateSha256Hash;
//# sourceMappingURL=data:application/json;base64,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