# -------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
# --------------------------------------------------------------------------

NEW_SASTOKEN_REQUIRED = "NEW_SASTOKEN_REQUIRED"
CONNECTION_STATE_CHANGE = "CONNECTION_STATE_CHANGE"
BACKGROUND_EXCEPTION = "BACKGROUND_EXCEPTION"


class ClientEvent(object):
    """Represents an event that has occurred within the client.

    Contains a name for the event, as well as any associated values that should be provided to the
    user when the event occurs.

    Note that a "Client Event" represents an event generated by the client itself, rather than an
    unsolicited data receive event (those have a different process)
    """

    def __init__(self, name, *args_for_user):
        self.name = name
        self.args_for_user = args_for_user
