/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer;

import java.util.Iterator;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

public final class CFPointWriterUtils {
    private CFPointWriterUtils() {
    }

    public static Array getArrayFromMember(Variable var, StructureMembers.Member m3) {
        DataType v_dt = var.getDataType();
        int[] shape = var.getShape();
        for (int i = 0; i < shape.length; ++i) {
            shape[i] = 1;
        }
        Array arr = Array.factory(v_dt, shape);
        CFPointWriterUtils.setDataArray(v_dt, arr, m3);
        return arr;
    }

    private static void setDataArray(DataType dt, Array arr, StructureMembers.Member m3) {
        if (dt == DataType.SHORT) {
            arr.setShort(0, m3.getDataArray().getShort(0));
        }
        if (dt == DataType.INT) {
            arr.setInt(0, m3.getDataArray().getInt(0));
        }
        if (dt == DataType.DOUBLE) {
            arr.setDouble(0, m3.getDataArray().getDouble(0));
        }
        if (dt == DataType.FLOAT) {
            arr.setFloat(0, m3.getDataArray().getFloat(0));
        }
    }

    public static LatLonRect getBoundingBox(List<? extends Station> stnList) {
        Station s2 = stnList.get(0);
        LatLonPointImpl llpt = new LatLonPointImpl();
        llpt.set(s2.getLatitude(), s2.getLongitude());
        LatLonRect rect = new LatLonRect(llpt, 0.0, 0.0);
        for (int i = 1; i < stnList.size(); ++i) {
            s2 = stnList.get(i);
            llpt.set(s2.getLatitude(), s2.getLongitude());
            rect.extend(llpt);
        }
        double newLowerLeftLat = rect.getLowerLeftPoint().getLatitude() - 5.0E-4;
        double newLowerLeftLon = rect.getLowerLeftPoint().getLongitude() - 5.0E-4;
        LatLonPointImpl newLowerLeftPoint = new LatLonPointImpl(newLowerLeftLat, newLowerLeftLon);
        double newUpperRightLat = rect.getUpperRightPoint().getLatitude() + 5.0E-4;
        double newUpperRightLon = rect.getUpperRightPoint().getLongitude() + 5.0E-4;
        LatLonPointImpl newUpperRightPoint = new LatLonPointImpl(newUpperRightLat, newUpperRightLon);
        rect.extend(newLowerLeftPoint);
        rect.extend(newUpperRightPoint);
        return rect;
    }

    public static Attribute findCDMAtt(List<Attribute> atts, String attName) {
        Iterator<Attribute> it = atts.iterator();
        Attribute target = null;
        while (it.hasNext() && target == null) {
            Attribute att = it.next();
            if (!att.getFullName().equals(attName) && !att.getShortName().equals(attName)) continue;
            target = att;
        }
        return target;
    }
}

