/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import java.io.IOException;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayDouble;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dataset.transform.WRFEtaTransformBuilder;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.FlatEarth;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.Mercator;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.util.StringUtil2;

public class WRFConvention
extends CoordSysBuilder {
    private double centerX;
    private double centerY;
    private ProjectionCT projCT;
    private boolean gridE;

    public static boolean isMine(NetcdfFile ncfile) {
        if (null == ncfile.findDimension("south_north")) {
            return false;
        }
        Attribute att = ncfile.findGlobalAttribute("DYN_OPT");
        if (att != null ? att.getNumericValue().intValue() != 2 : (att = ncfile.findGlobalAttribute("GRIDTYPE")) != null && !att.getStringValue().equalsIgnoreCase("C") && !att.getStringValue().equalsIgnoreCase("E")) {
            return false;
        }
        att = ncfile.findGlobalAttribute("MAP_PROJ");
        return att != null;
    }

    public WRFConvention() {
        this.conventionName = "WRF";
    }

    @Override
    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) {
        if (null != ds.findVariable("x")) {
            return;
        }
        Attribute att = ds.findGlobalAttribute("GRIDTYPE");
        this.gridE = att != null && att.getStringValue().equalsIgnoreCase("E");
        List<Variable> vlist = ds.getVariables();
        for (Variable v : vlist) {
            String units;
            att = v.attributes().findAttributeIgnoreCase("units");
            if (att == null || (units = att.getStringValue()) == null) continue;
            v.addAttribute(new Attribute("units", this.normalize(units)));
        }
        att = ds.findGlobalAttribute("MAP_PROJ");
        int projType = att.getNumericValue().intValue();
        boolean isLatLon = false;
        if (projType == 203) {
            Variable glat = ds.findVariable("GLAT");
            if (glat == null) {
                this.parseInfo.format("Projection type 203 - expected GLAT variable not found%n", new Object[0]);
            } else {
                glat.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
                if (this.gridE) {
                    glat.addAttribute(new Attribute("_CoordinateStagger", "Arakawa-E"));
                }
                glat.setDimensions("south_north west_east");
                glat.setCachedData(this.convertToDegrees(glat), false);
                glat.addAttribute(new Attribute("units", "degrees_north"));
            }
            Variable glon = ds.findVariable("GLON");
            if (glon == null) {
                this.parseInfo.format("Projection type 203 - expected GLON variable not found%n", new Object[0]);
            } else {
                glon.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
                if (this.gridE) {
                    glon.addAttribute(new Attribute("_CoordinateStagger", "Arakawa-E"));
                }
                glon.setDimensions("south_north west_east");
                glon.setCachedData(this.convertToDegrees(glon), false);
                glon.addAttribute(new Attribute("units", "degrees_east"));
            }
            VariableDS v = new VariableDS(ds, null, null, "LatLonCoordSys", DataType.CHAR, "", null, null);
            v.addAttribute(new Attribute("_CoordinateAxes", "GLAT GLON Time"));
            Array data = Array.factory(DataType.CHAR, new int[0], (Object)new char[]{' '});
            v.setCachedData(data, true);
            ds.addVariable(null, v);
            Variable dataVar = ds.findVariable("LANDMASK");
            dataVar.addAttribute(new Attribute("_CoordinateSystems", "LatLonCoordSys"));
        } else {
            double lat1 = this.findAttributeDouble(ds, "TRUELAT1");
            double lat2 = this.findAttributeDouble(ds, "TRUELAT2");
            double centralLat = this.findAttributeDouble(ds, "CEN_LAT");
            double centralLon = this.findAttributeDouble(ds, "CEN_LON");
            double standardLon = this.findAttributeDouble(ds, "STAND_LON");
            double standardLat = this.findAttributeDouble(ds, "MOAD_CEN_LAT");
            ProjectionImpl proj = null;
            switch (projType) {
                case 0: {
                    proj = new FlatEarth();
                    this.projCT = new ProjectionCT("flat_earth", "FGDC", proj);
                    break;
                }
                case 1: {
                    proj = new LambertConformal(standardLat, standardLon, lat1, lat2, 0.0, 0.0, 6370.0);
                    this.projCT = new ProjectionCT("Lambert", "FGDC", proj);
                    break;
                }
                case 2: {
                    double lon0 = Double.isNaN(standardLon) ? centralLon : standardLon;
                    double lat0 = Double.isNaN(centralLat) ? lat2 : centralLat;
                    double scaleFactor = (1.0 + Math.abs(Math.sin(Math.toRadians(lat1)))) / 2.0;
                    proj = new Stereographic(lat0, lon0, scaleFactor, 0.0, 0.0, 6370.0);
                    this.projCT = new ProjectionCT("Stereographic", "FGDC", proj);
                    break;
                }
                case 3: {
                    proj = new Mercator(standardLon, lat1, 0.0, 0.0, 6370.0);
                    this.projCT = new ProjectionCT("Mercator", "FGDC", proj);
                    break;
                }
                case 6: {
                    isLatLon = true;
                    for (Variable v : vlist) {
                        if (v.getShortName().startsWith("XLAT")) {
                            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
                            this.removeConstantTimeDim(ds, v);
                            continue;
                        }
                        if (v.getShortName().startsWith("XLONG")) {
                            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
                            this.removeConstantTimeDim(ds, v);
                            continue;
                        }
                        if (v.getShortName().equals("T")) {
                            v.addAttribute(new Attribute("_CoordinateAxes", "Time XLAT XLONG z"));
                            continue;
                        }
                        if (v.getShortName().equals("U")) {
                            v.addAttribute(new Attribute("_CoordinateAxes", "Time XLAT_U XLONG_U z"));
                            continue;
                        }
                        if (v.getShortName().equals("V")) {
                            v.addAttribute(new Attribute("_CoordinateAxes", "Time XLAT_V XLONG_V z"));
                            continue;
                        }
                        if (!v.getShortName().equals("W")) continue;
                        v.addAttribute(new Attribute("_CoordinateAxes", "Time XLAT XLONG z_stag"));
                    }
                    break;
                }
                default: {
                    this.parseInfo.format("ERROR: unknown projection type = %s%n", projType);
                }
            }
            if (proj != null) {
                LatLonPointImpl lpt1 = new LatLonPointImpl(centralLat, centralLon);
                ProjectionPoint ppt1 = proj.latLonToProj(lpt1, new ProjectionPointImpl());
                this.centerX = ppt1.getX();
                this.centerY = ppt1.getY();
                if (this.debug) {
                    System.out.println("centerX=" + this.centerX);
                    System.out.println("centerY=" + this.centerY);
                }
            }
            if (!isLatLon) {
                ds.addCoordinateAxis(this.makeXCoordAxis(ds, "x", ds.findDimension("west_east")));
                ds.addCoordinateAxis(this.makeXCoordAxis(ds, "x_stag", ds.findDimension("west_east_stag")));
                ds.addCoordinateAxis(this.makeYCoordAxis(ds, "y", ds.findDimension("south_north")));
                ds.addCoordinateAxis(this.makeYCoordAxis(ds, "y_stag", ds.findDimension("south_north_stag")));
            }
            ds.addCoordinateAxis(this.makeZCoordAxis(ds, "z", ds.findDimension("bottom_top")));
            ds.addCoordinateAxis(this.makeZCoordAxis(ds, "z_stag", ds.findDimension("bottom_top_stag")));
            if (this.projCT != null) {
                VariableDS v = this.makeCoordinateTransformVariable(ds, this.projCT);
                v.addAttribute(new Attribute("_CoordinateAxisTypes", "GeoX GeoY"));
                if (this.gridE) {
                    v.addAttribute(new Attribute("_CoordinateStagger", "Arakawa-E"));
                }
                ds.addVariable(null, v);
            }
        }
        if (ds.findVariable("Time") == null) {
            CoordinateAxis taxis = this.makeTimeCoordAxis(ds, "Time", ds.findDimension("Time"));
            if (taxis == null) {
                taxis = this.makeTimeCoordAxis(ds, "Time", ds.findDimension("Times"));
            }
            if (taxis != null) {
                ds.addCoordinateAxis(taxis);
            }
        }
        ds.addCoordinateAxis(this.makeSoilDepthCoordAxis(ds, "ZS"));
        ds.finish();
    }

    private void removeConstantTimeDim(NetcdfDataset ds, Variable v) {
        int[] shape = v.getShape();
        if (v.getRank() == 3 && shape[0] == 1) {
            Variable view;
            try {
                view = v.slice(0, 0);
            }
            catch (InvalidRangeException e) {
                log.error("Cant remove first dimension in variable {}", (Object)v);
                return;
            }
            ds.removeVariable(null, v.getShortName());
            ds.addVariable(null, view);
        }
    }

    private Array convertToDegrees(Variable v) {
        Array data;
        try {
            data = v.read();
            data = data.reduce();
        }
        catch (IOException ioe) {
            throw new RuntimeException("data read failed on " + v.getFullName() + "=" + ioe.getMessage());
        }
        IndexIterator ii = data.getIndexIterator();
        while (ii.hasNext()) {
            ii.setDoubleCurrent(Math.toDegrees(ii.getDoubleNext()));
        }
        return data;
    }

    private String normalize(String units) {
        switch (units) {
            case "fraction": 
            case "dimensionless": 
            case "-": 
            case "NA": {
                units = "";
                break;
            }
            default: {
                units = StringUtil2.substitute(units, "**", "^");
                units = StringUtil2.remove(units, 125);
                units = StringUtil2.remove(units, 123);
            }
        }
        return units;
    }

    @Override
    protected void makeCoordinateTransforms(NetcdfDataset ds) {
        if (this.projCT != null) {
            CoordSysBuilder.VarProcess vp = this.findVarProcess(this.projCT.getName(), null);
            vp.isCoordinateTransform = true;
            vp.ct = this.projCT;
        }
        super.makeCoordinateTransforms(ds);
    }

    @Override
    protected AxisType getAxisType(NetcdfDataset ds, VariableEnhanced ve) {
        Variable v = (Variable)((Object)ve);
        String vname = v.getShortName();
        if (vname.equalsIgnoreCase("x") || vname.equalsIgnoreCase("x_stag")) {
            return AxisType.GeoX;
        }
        if (vname.equalsIgnoreCase("lon")) {
            return AxisType.Lon;
        }
        if (vname.equalsIgnoreCase("y") || vname.equalsIgnoreCase("y_stag")) {
            return AxisType.GeoY;
        }
        if (vname.equalsIgnoreCase("lat")) {
            return AxisType.Lat;
        }
        if (vname.equalsIgnoreCase("z") || vname.equalsIgnoreCase("z_stag")) {
            return AxisType.GeoZ;
        }
        if (vname.equalsIgnoreCase("Z")) {
            return AxisType.Height;
        }
        if (vname.equalsIgnoreCase("time") || vname.equalsIgnoreCase("times")) {
            return AxisType.Time;
        }
        String unit = ve.getUnitsString();
        if (unit != null) {
            if (SimpleUnit.isCompatible("millibar", unit)) {
                return AxisType.Pressure;
            }
            if (SimpleUnit.isCompatible("m", unit)) {
                return AxisType.Height;
            }
        }
        return null;
    }

    public String getZisPositive(CoordinateAxis v) {
        return "down";
    }

    private CoordinateAxis makeLonCoordAxis(NetcdfDataset ds, String axisName, Dimension dim) {
        if (dim == null) {
            return null;
        }
        double dx = 4.0 * this.findAttributeDouble(ds, "DX");
        int nx = dim.getLength();
        double startx = this.centerX - dx * (double)(nx - 1) / 2.0;
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, axisName, DataType.DOUBLE, dim.getShortName(), "degrees_east", "synthesized longitude coordinate");
        v.setValues(nx, startx, dx);
        v.addAttribute(new Attribute("_CoordinateAxisType", "Lon"));
        if (!axisName.equals(dim.getShortName())) {
            v.addAttribute(new Attribute("_CoordinateAliasForDimension", dim.getShortName()));
        }
        return v;
    }

    private CoordinateAxis makeLatCoordAxis(NetcdfDataset ds, String axisName, Dimension dim) {
        if (dim == null) {
            return null;
        }
        double dy = this.findAttributeDouble(ds, "DY");
        int ny = dim.getLength();
        double starty = this.centerY - dy * (double)(ny - 1) / 2.0;
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, axisName, DataType.DOUBLE, dim.getShortName(), "degrees_north", "synthesized latitude coordinate");
        v.setValues(ny, starty, dy);
        v.addAttribute(new Attribute("_CoordinateAxisType", "Lat"));
        if (!axisName.equals(dim.getShortName())) {
            v.addAttribute(new Attribute("_CoordinateAliasForDimension", dim.getShortName()));
        }
        return v;
    }

    private CoordinateAxis makeXCoordAxis(NetcdfDataset ds, String axisName, Dimension dim) {
        if (dim == null) {
            return null;
        }
        double dx = this.findAttributeDouble(ds, "DX") / 1000.0;
        int nx = dim.getLength();
        double startx = this.centerX - dx * (double)(nx - 1) / 2.0;
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, axisName, DataType.DOUBLE, dim.getShortName(), "km", "synthesized GeoX coordinate from DX attribute");
        v.setValues(nx, startx, dx);
        v.addAttribute(new Attribute("_CoordinateAxisType", "GeoX"));
        if (!axisName.equals(dim.getShortName())) {
            v.addAttribute(new Attribute("_CoordinateAliasForDimension", dim.getShortName()));
        }
        if (this.gridE) {
            v.addAttribute(new Attribute("_CoordinateStagger", "Arakawa-E"));
        }
        return v;
    }

    private CoordinateAxis makeYCoordAxis(NetcdfDataset ds, String axisName, Dimension dim) {
        if (dim == null) {
            return null;
        }
        double dy = this.findAttributeDouble(ds, "DY") / 1000.0;
        int ny = dim.getLength();
        double starty = this.centerY - dy * (double)(ny - 1) / 2.0;
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, axisName, DataType.DOUBLE, dim.getShortName(), "km", "synthesized GeoY coordinate from DY attribute");
        v.setValues(ny, starty, dy);
        v.addAttribute(new Attribute("_CoordinateAxisType", "GeoY"));
        if (!axisName.equals(dim.getShortName())) {
            v.addAttribute(new Attribute("_CoordinateAliasForDimension", dim.getShortName()));
        }
        if (this.gridE) {
            v.addAttribute(new Attribute("_CoordinateStagger", "Arakawa-E"));
        }
        return v;
    }

    private CoordinateAxis makeZCoordAxis(NetcdfDataset ds, String axisName, Dimension dim) {
        Variable etaVar;
        if (dim == null) {
            return null;
        }
        String fromWhere = axisName.endsWith("stag") ? "ZNW" : "ZNU";
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, axisName, DataType.DOUBLE, dim.getShortName(), "", "eta values from variable " + fromWhere);
        v.addAttribute(new Attribute("positive", "down"));
        v.addAttribute(new Attribute("_CoordinateAxisType", "GeoZ"));
        if (!axisName.equals(dim.getShortName())) {
            v.addAttribute(new Attribute("_CoordinateAliasForDimension", dim.getShortName()));
        }
        if ((etaVar = ds.findVariable(fromWhere)) == null) {
            return this.makeFakeCoordAxis(ds, axisName, dim);
        }
        int n = etaVar.getShape(1);
        int[] origin = new int[]{0, 0};
        int[] shape = new int[]{1, n};
        try {
            Array array = etaVar.read(origin, shape);
            ArrayDouble.D1 newArray = new ArrayDouble.D1(n);
            IndexIterator it = array.getIndexIterator();
            int count = 0;
            while (it.hasNext()) {
                double d = it.getDoubleNext();
                newArray.set(count++, d);
            }
            v.setCachedData(newArray, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return v;
    }

    private CoordinateAxis makeFakeCoordAxis(NetcdfDataset ds, String axisName, Dimension dim) {
        if (dim == null) {
            return null;
        }
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, axisName, DataType.SHORT, dim.getShortName(), "", "synthesized coordinate: only an index");
        v.addAttribute(new Attribute("_CoordinateAxisType", "GeoZ"));
        if (!axisName.equals(dim.getShortName())) {
            v.addAttribute(new Attribute("_CoordinateAliasForDimension", dim.getShortName()));
        }
        v.setValues(dim.getLength(), 0.0, 1.0);
        return v;
    }

    private CoordinateAxis makeTimeCoordAxis(NetcdfDataset ds, String axisName, Dimension dim) {
        Object iter;
        Array timeData;
        if (dim == null) {
            return null;
        }
        int nt = dim.getLength();
        Variable timeV = ds.findVariable("Times");
        if (timeV == null) {
            return null;
        }
        try {
            timeData = timeV.read();
        }
        catch (IOException ioe) {
            return null;
        }
        ArrayDouble.D1 values = new ArrayDouble.D1(nt);
        int count = 0;
        if (timeData instanceof ArrayChar) {
            iter = ((ArrayChar)timeData).getStringIterator();
            String testTimeStr = ((ArrayChar)timeData).getString(0);
            boolean isCanonicalIsoStr = true;
            String wrfDateWithUnderscore = "([\\-\\d]{10})_";
            Pattern wrfDateWithUnderscorePattern = Pattern.compile(wrfDateWithUnderscore);
            Matcher m3 = wrfDateWithUnderscorePattern.matcher(testTimeStr);
            isCanonicalIsoStr = m3.matches();
            while (((ArrayChar.StringIterator)iter).hasNext()) {
                String dateS = ((ArrayChar.StringIterator)iter).next();
                try {
                    CalendarDate cd2 = isCanonicalIsoStr ? CalendarDateFormatter.isoStringToCalendarDate(null, dateS) : CalendarDateFormatter.isoStringToCalendarDate(null, dateS.replaceFirst("_", "T"));
                    values.set(count++, (double)cd2.getMillis() / 1000.0);
                }
                catch (IllegalArgumentException e) {
                    this.parseInfo.format("ERROR: cant parse Time string = <%s> err= %s%n", dateS, e.getMessage());
                    String startAtt = ds.findAttValueIgnoreCase(null, "START_DATE", null);
                    if (nt != 1 || null == startAtt) continue;
                    try {
                        CalendarDate cd3 = CalendarDateFormatter.isoStringToCalendarDate(null, startAtt);
                        values.set(0, (double)cd3.getMillis() / 1000.0);
                    }
                    catch (IllegalArgumentException e2) {
                        this.parseInfo.format("ERROR: cant parse global attribute START_DATE = <%s> err=%s%n", startAtt, e2.getMessage());
                    }
                }
            }
        } else {
            iter = timeData.getIndexIterator();
            while (iter.hasNext()) {
                String dateS = (String)iter.next();
                try {
                    CalendarDate cd4 = CalendarDateFormatter.isoStringToCalendarDate(null, dateS);
                    values.set(count++, (double)cd4.getMillis() / 1000.0);
                }
                catch (IllegalArgumentException e) {
                    this.parseInfo.format("ERROR: cant parse Time string = %s%n", dateS);
                }
            }
        }
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, axisName, DataType.DOUBLE, dim.getShortName(), "secs since 1970-01-01 00:00:00", "synthesized time coordinate from Times(time)");
        v.addAttribute(new Attribute("_CoordinateAxisType", "Time"));
        if (!axisName.equals(dim.getShortName())) {
            v.addAttribute(new Attribute("_CoordinateAliasForDimension", dim.getShortName()));
        }
        v.setCachedData(values, true);
        return v;
    }

    private VariableDS makeSoilDepthCoordAxis(NetcdfDataset ds, String coordVarName) {
        Variable coordVar = ds.findVariable(coordVarName);
        if (null == coordVar) {
            return null;
        }
        Dimension soilDim = null;
        List<Dimension> dims = coordVar.getDimensions();
        for (Dimension d : dims) {
            if (!d.getShortName().startsWith("soil_layers")) continue;
            soilDim = d;
        }
        if (null == soilDim) {
            return null;
        }
        if (coordVar.getRank() == 1) {
            coordVar.addAttribute(new Attribute("positive", "down"));
            coordVar.addAttribute(new Attribute("_CoordinateAxisType", "GeoZ"));
            if (!coordVarName.equals(soilDim.getShortName())) {
                coordVar.addAttribute(new Attribute("_CoordinateAliasForDimension", soilDim.getShortName()));
            }
            return (VariableDS)coordVar;
        }
        String units = ds.findAttValueIgnoreCase(coordVar, "units", "");
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, "soilDepth", DataType.DOUBLE, soilDim.getShortName(), units, "soil depth");
        v.addAttribute(new Attribute("positive", "down"));
        v.addAttribute(new Attribute("_CoordinateAxisType", "GeoZ"));
        v.addAttribute(new Attribute("units", "units"));
        if (!v.getShortName().equals(soilDim.getShortName())) {
            v.addAttribute(new Attribute("_CoordinateAliasForDimension", soilDim.getShortName()));
        }
        int n = coordVar.getShape(1);
        int[] origin = new int[]{0, 0};
        int[] shape = new int[]{1, n};
        try {
            Array array = coordVar.read(origin, shape);
            ArrayDouble.D1 newArray = new ArrayDouble.D1(n);
            IndexIterator it = array.getIndexIterator();
            int count = 0;
            while (it.hasNext()) {
                double d = it.getDoubleNext();
                newArray.set(count++, d);
            }
            v.setCachedData(newArray, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return v;
    }

    private double findAttributeDouble(NetcdfDataset ds, String attname) {
        Attribute att = ds.findGlobalAttributeIgnoreCase(attname);
        if (att == null) {
            return Double.NaN;
        }
        return att.getNumericValue().doubleValue();
    }

    @Override
    protected void assignCoordinateTransforms(NetcdfDataset ncDataset) {
        super.assignCoordinateTransforms(ncDataset);
        List<CoordinateSystem> csys = ncDataset.getCoordinateSystems();
        for (CoordinateSystem cs : csys) {
            String units;
            if (cs.getZaxis() == null || (units = cs.getZaxis().getUnitsString()) != null && !units.trim().isEmpty()) continue;
            VerticalCT vct = this.makeWRFEtaVerticalCoordinateTransform(ncDataset, cs);
            if (vct != null) {
                cs.addCoordinateTransform(vct);
            }
            this.parseInfo.format("***Added WRFEta verticalCoordinateTransform to %s%n", cs.getName());
        }
    }

    private VerticalCT makeWRFEtaVerticalCoordinateTransform(NetcdfDataset ds, CoordinateSystem cs) {
        if (null == ds.findVariable("PH") || null == ds.findVariable("PHB") || null == ds.findVariable("P") || null == ds.findVariable("PB")) {
            return null;
        }
        WRFEtaTransformBuilder builder = new WRFEtaTransformBuilder(cs);
        return builder.makeCoordinateTransform(ds, null);
    }
}

