/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.util.Formatter;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.StructureDataScalar;
import ucar.ma2.StructureMembers;
import ucar.nc2.util.Indent;

public abstract class StructureData {
    public static final StructureData EMPTY = new StructureDataScalar("empty");
    protected StructureMembers members;

    protected StructureData(StructureMembers members) {
        this.members = members;
    }

    public String getName() {
        return this.members.getName();
    }

    public StructureMembers getStructureMembers() {
        return this.members;
    }

    public List<StructureMembers.Member> getMembers() {
        return this.members.getMembers();
    }

    public StructureMembers.Member findMember(String memberName) {
        return this.members.findMember(memberName);
    }

    public abstract Array getArray(StructureMembers.Member var1);

    public Array getArray(String memberName) {
        StructureMembers.Member m3 = this.members.findMember(memberName);
        if (m3 == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getArray(m3);
    }

    public Object getScalarObject(String memberName) {
        StructureMembers.Member m3 = this.members.findMember(memberName);
        if (m3 == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getScalarObject(m3);
    }

    public Object getScalarObject(StructureMembers.Member m3) {
        DataType dataType = m3.getDataType();
        if (dataType == DataType.DOUBLE) {
            return this.getScalarDouble(m3);
        }
        if (dataType == DataType.FLOAT) {
            return Float.valueOf(this.getScalarFloat(m3));
        }
        if (dataType.getPrimitiveClassType() == Byte.TYPE) {
            return this.getScalarByte(m3);
        }
        if (dataType.getPrimitiveClassType() == Short.TYPE) {
            return this.getScalarShort(m3);
        }
        if (dataType.getPrimitiveClassType() == Integer.TYPE) {
            return this.getScalarInt(m3);
        }
        if (dataType.getPrimitiveClassType() == Long.TYPE) {
            return this.getScalarLong(m3);
        }
        if (dataType == DataType.CHAR) {
            return this.getScalarString(m3);
        }
        if (dataType == DataType.STRING) {
            return this.getScalarString(m3);
        }
        if (dataType == DataType.STRUCTURE) {
            return this.getScalarStructure(m3);
        }
        if (dataType == DataType.SEQUENCE) {
            return this.getArraySequence(m3);
        }
        throw new RuntimeException("Dont have implemenation for " + (Object)((Object)dataType));
    }

    public float convertScalarFloat(String memberName) {
        StructureMembers.Member m3 = this.members.findMember(memberName);
        if (m3 == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.convertScalarFloat(m3);
    }

    public abstract float convertScalarFloat(StructureMembers.Member var1);

    public double convertScalarDouble(String memberName) {
        StructureMembers.Member m3 = this.members.findMember(memberName);
        if (m3 == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.convertScalarDouble(m3);
    }

    public abstract double convertScalarDouble(StructureMembers.Member var1);

    public int convertScalarInt(String memberName) {
        StructureMembers.Member m3 = this.members.findMember(memberName);
        if (m3 == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.convertScalarInt(m3);
    }

    public abstract int convertScalarInt(StructureMembers.Member var1);

    public long convertScalarLong(String memberName) {
        StructureMembers.Member m3 = this.members.findMember(memberName);
        if (m3 == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.convertScalarLong(m3);
    }

    public abstract long convertScalarLong(StructureMembers.Member var1);

    public double getScalarDouble(String memberName) {
        StructureMembers.Member m3 = this.members.findMember(memberName);
        if (m3 == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getScalarDouble(m3);
    }

    public abstract double getScalarDouble(StructureMembers.Member var1);

    public double[] getJavaArrayDouble(String memberName) {
        StructureMembers.Member m3 = this.members.findMember(memberName);
        if (m3 == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getJavaArrayDouble(m3);
    }

    public abstract double[] getJavaArrayDouble(StructureMembers.Member var1);

    public float getScalarFloat(String memberName) {
        StructureMembers.Member m3 = this.members.findMember(memberName);
        if (m3 == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getScalarFloat(m3);
    }

    public abstract float getScalarFloat(StructureMembers.Member var1);

    public float[] getJavaArrayFloat(String memberName) {
        StructureMembers.Member m3 = this.members.findMember(memberName);
        if (m3 == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getJavaArrayFloat(m3);
    }

    public abstract float[] getJavaArrayFloat(StructureMembers.Member var1);

    public byte getScalarByte(String memberName) {
        StructureMembers.Member m3 = this.members.findMember(memberName);
        if (m3 == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getScalarByte(m3);
    }

    public abstract byte getScalarByte(StructureMembers.Member var1);

    public byte[] getJavaArrayByte(String memberName) {
        StructureMembers.Member m3 = this.members.findMember(memberName);
        if (m3 == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getJavaArrayByte(m3);
    }

    public abstract byte[] getJavaArrayByte(StructureMembers.Member var1);

    public int getScalarInt(String memberName) {
        StructureMembers.Member m3 = this.members.findMember(memberName);
        if (m3 == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getScalarInt(m3);
    }

    public abstract int getScalarInt(StructureMembers.Member var1);

    public int[] getJavaArrayInt(String memberName) {
        StructureMembers.Member m3 = this.members.findMember(memberName);
        if (m3 == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getJavaArrayInt(m3);
    }

    public abstract int[] getJavaArrayInt(StructureMembers.Member var1);

    public short getScalarShort(String memberName) {
        StructureMembers.Member m3 = this.members.findMember(memberName);
        if (m3 == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getScalarShort(m3);
    }

    public abstract short getScalarShort(StructureMembers.Member var1);

    public short[] getJavaArrayShort(String memberName) {
        StructureMembers.Member m3 = this.members.findMember(memberName);
        if (m3 == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getJavaArrayShort(m3);
    }

    public abstract short[] getJavaArrayShort(StructureMembers.Member var1);

    public long getScalarLong(String memberName) {
        StructureMembers.Member m3 = this.members.findMember(memberName);
        if (m3 == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getScalarLong(m3);
    }

    public abstract long getScalarLong(StructureMembers.Member var1);

    public long[] getJavaArrayLong(String memberName) {
        StructureMembers.Member m3 = this.members.findMember(memberName);
        if (m3 == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getJavaArrayLong(m3);
    }

    public abstract long[] getJavaArrayLong(StructureMembers.Member var1);

    public char getScalarChar(String memberName) {
        StructureMembers.Member m3 = this.members.findMember(memberName);
        if (m3 == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getScalarChar(m3);
    }

    public abstract char getScalarChar(StructureMembers.Member var1);

    public char[] getJavaArrayChar(String memberName) {
        StructureMembers.Member m3 = this.members.findMember(memberName);
        if (m3 == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getJavaArrayChar(m3);
    }

    public abstract char[] getJavaArrayChar(StructureMembers.Member var1);

    public String getScalarString(String memberName) {
        StructureMembers.Member m3 = this.findMember(memberName);
        if (null == m3) {
            throw new IllegalArgumentException("Member not found= " + memberName);
        }
        return this.getScalarString(m3);
    }

    public abstract String getScalarString(StructureMembers.Member var1);

    public String[] getJavaArrayString(String memberName) {
        StructureMembers.Member m3 = this.members.findMember(memberName);
        if (m3 == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getJavaArrayString(m3);
    }

    public abstract String[] getJavaArrayString(StructureMembers.Member var1);

    public StructureData getScalarStructure(String memberName) {
        StructureMembers.Member m3 = this.findMember(memberName);
        if (null == m3) {
            throw new IllegalArgumentException("Member not found= " + memberName);
        }
        return this.getScalarStructure(m3);
    }

    public abstract StructureData getScalarStructure(StructureMembers.Member var1);

    public ArrayStructure getArrayStructure(String memberName) {
        StructureMembers.Member m3 = this.findMember(memberName);
        if (null == m3) {
            throw new IllegalArgumentException("Member not found= " + memberName);
        }
        return this.getArrayStructure(m3);
    }

    public abstract ArrayStructure getArrayStructure(StructureMembers.Member var1);

    public ArraySequence getArraySequence(String memberName) {
        StructureMembers.Member m3 = this.members.findMember(memberName);
        if (m3 == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        return this.getArraySequence(m3);
    }

    public abstract ArraySequence getArraySequence(StructureMembers.Member var1);

    public void showInternal(Formatter f, Indent indent) {
        f.format("%sStructureData %s class=%s hash=0x%x%n", indent, this.members.getName(), this.getClass().getName(), this.hashCode());
    }

    public void showInternalMembers(Formatter f, Indent indent) {
        f.format("%sStructureData %s class=%s hash=0x%x%n", indent, this.members.getName(), this.getClass().getName(), this.hashCode());
        indent.incr();
        for (StructureMembers.Member m3 : this.getMembers()) {
            m3.showInternal(f, indent);
        }
        indent.decr();
    }

    public String toString() {
        return this.members.toString();
    }
}

