/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.BinaryOnly;
import ome.xml.model.Dataset;
import ome.xml.model.Experiment;
import ome.xml.model.Experimenter;
import ome.xml.model.ExperimenterGroup;
import ome.xml.model.Folder;
import ome.xml.model.Image;
import ome.xml.model.Instrument;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Plate;
import ome.xml.model.Project;
import ome.xml.model.ROI;
import ome.xml.model.Reference;
import ome.xml.model.Rights;
import ome.xml.model.Screen;
import ome.xml.model.StructuredAnnotations;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OME
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(OME.class);
    private String uuid;
    private String creator;
    private Rights rights;
    private List<Project> projects = new ArrayList<Project>();
    private List<Dataset> datasets = new ArrayList<Dataset>();
    private List<Folder> folders = new ArrayList<Folder>();
    private List<Experiment> experiments = new ArrayList<Experiment>();
    private List<Plate> plates = new ArrayList<Plate>();
    private List<Screen> screens = new ArrayList<Screen>();
    private List<Experimenter> experimenters = new ArrayList<Experimenter>();
    private List<ExperimenterGroup> experimenterGroups = new ArrayList<ExperimenterGroup>();
    private List<Instrument> instruments = new ArrayList<Instrument>();
    private List<Image> images = new ArrayList<Image>();
    private StructuredAnnotations structuredAnnotations;
    private List<ROI> roIs = new ArrayList<ROI>();
    private BinaryOnly binaryOnly;

    public OME() {
    }

    public OME(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public OME(OME orig) {
        this.uuid = orig.uuid;
        this.creator = orig.creator;
        this.rights = orig.rights;
        this.projects = orig.projects;
        this.datasets = orig.datasets;
        this.folders = orig.folders;
        this.experiments = orig.experiments;
        this.plates = orig.plates;
        this.screens = orig.screens;
        this.experimenters = orig.experimenters;
        this.experimenterGroups = orig.experimenterGroups;
        this.instruments = orig.instruments;
        this.images = orig.images;
        this.structuredAnnotations = orig.structuredAnnotations;
        this.roIs = orig.roIs;
        this.binaryOnly = orig.binaryOnly;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Rights_nodeList;
        super.update(element, model);
        if (element.hasAttribute("UUID")) {
            this.setUUID(String.valueOf(element.getAttribute("UUID")));
        }
        if (element.hasAttribute("Creator")) {
            this.setCreator(String.valueOf(element.getAttribute("Creator")));
        }
        if ((Rights_nodeList = OME.getChildrenByTagName(element, "Rights")).size() > 1) {
            throw new RuntimeException(String.format("Rights node list size %d != 1", Rights_nodeList.size()));
        }
        if (Rights_nodeList.size() != 0) {
            this.setRights(new Rights(Rights_nodeList.get(0), model));
        }
        List<Element> Project_nodeList = OME.getChildrenByTagName(element, "Project");
        for (Element element2 : Project_nodeList) {
            this.addProject(new Project(element2, model));
        }
        List<Element> Dataset_nodeList = OME.getChildrenByTagName(element, "Dataset");
        for (Element element3 : Dataset_nodeList) {
            this.addDataset(new Dataset(element3, model));
        }
        List<Element> list = OME.getChildrenByTagName(element, "Folder");
        for (Element element4 : list) {
            this.addFolder(new Folder(element4, model));
        }
        List<Element> list2 = OME.getChildrenByTagName(element, "Experiment");
        for (Element element5 : list2) {
            this.addExperiment(new Experiment(element5, model));
        }
        List<Element> list3 = OME.getChildrenByTagName(element, "Plate");
        for (Element element6 : list3) {
            this.addPlate(new Plate(element6, model));
        }
        List<Element> list4 = OME.getChildrenByTagName(element, "Screen");
        for (Element element7 : list4) {
            this.addScreen(new Screen(element7, model));
        }
        List<Element> list5 = OME.getChildrenByTagName(element, "Experimenter");
        for (Element element8 : list5) {
            this.addExperimenter(new Experimenter(element8, model));
        }
        List<Element> list6 = OME.getChildrenByTagName(element, "ExperimenterGroup");
        for (Element element9 : list6) {
            this.addExperimenterGroup(new ExperimenterGroup(element9, model));
        }
        List<Element> list7 = OME.getChildrenByTagName(element, "Instrument");
        for (Element element10 : list7) {
            this.addInstrument(new Instrument(element10, model));
        }
        List<Element> list8 = OME.getChildrenByTagName(element, "Image");
        for (Element Image_element : list8) {
            this.addImage(new Image(Image_element, model));
        }
        List<Element> list9 = OME.getChildrenByTagName(element, "StructuredAnnotations");
        if (list9.size() > 1) {
            throw new RuntimeException(String.format("StructuredAnnotations node list size %d != 1", list9.size()));
        }
        if (list9.size() != 0) {
            this.setStructuredAnnotations(new StructuredAnnotations(list9.get(0), model));
        }
        List<Element> ROI_nodeList = OME.getChildrenByTagName(element, "ROI");
        for (Element ROI_element : ROI_nodeList) {
            this.addROI(new ROI(ROI_element, model));
        }
        List<Element> BinaryOnly_nodeList = OME.getChildrenByTagName(element, "BinaryOnly");
        if (BinaryOnly_nodeList.size() > 1) {
            throw new RuntimeException(String.format("BinaryOnly node list size %d != 1", BinaryOnly_nodeList.size()));
        }
        if (BinaryOnly_nodeList.size() != 0) {
            this.setBinaryOnly(new BinaryOnly(BinaryOnly_nodeList.get(0), model));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        return super.link(reference, o);
    }

    public String getUUID() {
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Rights getRights() {
        return this.rights;
    }

    public void setRights(Rights rights) {
        this.rights = rights;
    }

    public int sizeOfProjectList() {
        return this.projects.size();
    }

    public List<Project> copyProjectList() {
        return new ArrayList<Project>(this.projects);
    }

    public Project getProject(int index) {
        return this.projects.get(index);
    }

    public Project setProject(int index, Project project) {
        return this.projects.set(index, project);
    }

    public void addProject(Project project) {
        this.projects.add(project);
    }

    public void removeProject(Project project) {
        this.projects.remove(project);
    }

    public int sizeOfDatasetList() {
        return this.datasets.size();
    }

    public List<Dataset> copyDatasetList() {
        return new ArrayList<Dataset>(this.datasets);
    }

    public Dataset getDataset(int index) {
        return this.datasets.get(index);
    }

    public Dataset setDataset(int index, Dataset dataset) {
        return this.datasets.set(index, dataset);
    }

    public void addDataset(Dataset dataset) {
        this.datasets.add(dataset);
    }

    public void removeDataset(Dataset dataset) {
        this.datasets.remove(dataset);
    }

    public int sizeOfFolderList() {
        return this.folders.size();
    }

    public List<Folder> copyFolderList() {
        return new ArrayList<Folder>(this.folders);
    }

    public Folder getFolder(int index) {
        return this.folders.get(index);
    }

    public Folder setFolder(int index, Folder folder) {
        return this.folders.set(index, folder);
    }

    public void addFolder(Folder folder) {
        this.folders.add(folder);
    }

    public void removeFolder(Folder folder) {
        this.folders.remove(folder);
    }

    public int sizeOfExperimentList() {
        return this.experiments.size();
    }

    public List<Experiment> copyExperimentList() {
        return new ArrayList<Experiment>(this.experiments);
    }

    public Experiment getExperiment(int index) {
        return this.experiments.get(index);
    }

    public Experiment setExperiment(int index, Experiment experiment) {
        return this.experiments.set(index, experiment);
    }

    public void addExperiment(Experiment experiment) {
        this.experiments.add(experiment);
    }

    public void removeExperiment(Experiment experiment) {
        this.experiments.remove(experiment);
    }

    public int sizeOfPlateList() {
        return this.plates.size();
    }

    public List<Plate> copyPlateList() {
        return new ArrayList<Plate>(this.plates);
    }

    public Plate getPlate(int index) {
        return this.plates.get(index);
    }

    public Plate setPlate(int index, Plate plate) {
        return this.plates.set(index, plate);
    }

    public void addPlate(Plate plate) {
        this.plates.add(plate);
    }

    public void removePlate(Plate plate) {
        this.plates.remove(plate);
    }

    public int sizeOfScreenList() {
        return this.screens.size();
    }

    public List<Screen> copyScreenList() {
        return new ArrayList<Screen>(this.screens);
    }

    public Screen getScreen(int index) {
        return this.screens.get(index);
    }

    public Screen setScreen(int index, Screen screen) {
        return this.screens.set(index, screen);
    }

    public void addScreen(Screen screen) {
        this.screens.add(screen);
    }

    public void removeScreen(Screen screen) {
        this.screens.remove(screen);
    }

    public int sizeOfExperimenterList() {
        return this.experimenters.size();
    }

    public List<Experimenter> copyExperimenterList() {
        return new ArrayList<Experimenter>(this.experimenters);
    }

    public Experimenter getExperimenter(int index) {
        return this.experimenters.get(index);
    }

    public Experimenter setExperimenter(int index, Experimenter experimenter) {
        return this.experimenters.set(index, experimenter);
    }

    public void addExperimenter(Experimenter experimenter) {
        this.experimenters.add(experimenter);
    }

    public void removeExperimenter(Experimenter experimenter) {
        this.experimenters.remove(experimenter);
    }

    public int sizeOfExperimenterGroupList() {
        return this.experimenterGroups.size();
    }

    public List<ExperimenterGroup> copyExperimenterGroupList() {
        return new ArrayList<ExperimenterGroup>(this.experimenterGroups);
    }

    public ExperimenterGroup getExperimenterGroup(int index) {
        return this.experimenterGroups.get(index);
    }

    public ExperimenterGroup setExperimenterGroup(int index, ExperimenterGroup experimenterGroup) {
        return this.experimenterGroups.set(index, experimenterGroup);
    }

    public void addExperimenterGroup(ExperimenterGroup experimenterGroup) {
        this.experimenterGroups.add(experimenterGroup);
    }

    public void removeExperimenterGroup(ExperimenterGroup experimenterGroup) {
        this.experimenterGroups.remove(experimenterGroup);
    }

    public int sizeOfInstrumentList() {
        return this.instruments.size();
    }

    public List<Instrument> copyInstrumentList() {
        return new ArrayList<Instrument>(this.instruments);
    }

    public Instrument getInstrument(int index) {
        return this.instruments.get(index);
    }

    public Instrument setInstrument(int index, Instrument instrument) {
        return this.instruments.set(index, instrument);
    }

    public void addInstrument(Instrument instrument) {
        this.instruments.add(instrument);
    }

    public void removeInstrument(Instrument instrument) {
        this.instruments.remove(instrument);
    }

    public int sizeOfImageList() {
        return this.images.size();
    }

    public List<Image> copyImageList() {
        return new ArrayList<Image>(this.images);
    }

    public Image getImage(int index) {
        return this.images.get(index);
    }

    public Image setImage(int index, Image image) {
        return this.images.set(index, image);
    }

    public void addImage(Image image) {
        this.images.add(image);
    }

    public void removeImage(Image image) {
        this.images.remove(image);
    }

    public StructuredAnnotations getStructuredAnnotations() {
        return this.structuredAnnotations;
    }

    public void setStructuredAnnotations(StructuredAnnotations structuredAnnotations) {
        this.structuredAnnotations = structuredAnnotations;
    }

    public int sizeOfROIList() {
        return this.roIs.size();
    }

    public List<ROI> copyROIList() {
        return new ArrayList<ROI>(this.roIs);
    }

    public ROI getROI(int index) {
        return this.roIs.get(index);
    }

    public ROI setROI(int index, ROI roi) {
        return this.roIs.set(index, roi);
    }

    public void addROI(ROI roi) {
        this.roIs.add(roi);
    }

    public void removeROI(ROI roi) {
        this.roIs.remove(roi);
    }

    public BinaryOnly getBinaryOnly() {
        return this.binaryOnly;
    }

    public void setBinaryOnly(BinaryOnly binaryOnly) {
        this.binaryOnly = binaryOnly;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element OME_element) {
        Element child;
        Object child2;
        if (OME_element == null) {
            OME_element = document.createElementNS(NAMESPACE, "OME");
        }
        super.asXMLElement(document, OME_element);
        if (this.uuid != null) {
            OME_element.setAttribute("UUID", this.uuid);
        }
        if (this.creator != null) {
            OME_element.setAttribute("Creator", this.creator);
        }
        if (this.rights != null) {
            child2 = document.createElementNS(NAMESPACE, "Rights");
            this.rights.asXMLElement(document, (Element)child2);
            OME_element.appendChild((Node)child2);
        }
        if (this.projects != null) {
            for (Project projects_value : this.projects) {
                child = document.createElementNS(NAMESPACE, "Project");
                projects_value.asXMLElement(document, child);
                OME_element.appendChild(child);
            }
        }
        if (this.datasets != null) {
            for (Dataset datasets_value : this.datasets) {
                child = document.createElementNS(NAMESPACE, "Dataset");
                datasets_value.asXMLElement(document, child);
                OME_element.appendChild(child);
            }
        }
        if (this.folders != null) {
            for (Folder folders_value : this.folders) {
                child = document.createElementNS(NAMESPACE, "Folder");
                folders_value.asXMLElement(document, child);
                OME_element.appendChild(child);
            }
        }
        if (this.experiments != null) {
            for (Experiment experiments_value : this.experiments) {
                child = document.createElementNS(NAMESPACE, "Experiment");
                experiments_value.asXMLElement(document, child);
                OME_element.appendChild(child);
            }
        }
        if (this.plates != null) {
            for (Plate plates_value : this.plates) {
                child = document.createElementNS(NAMESPACE, "Plate");
                plates_value.asXMLElement(document, child);
                OME_element.appendChild(child);
            }
        }
        if (this.screens != null) {
            for (Screen screens_value : this.screens) {
                child = document.createElementNS(NAMESPACE, "Screen");
                screens_value.asXMLElement(document, child);
                OME_element.appendChild(child);
            }
        }
        if (this.experimenters != null) {
            for (Experimenter experimenters_value : this.experimenters) {
                child = document.createElementNS(NAMESPACE, "Experimenter");
                experimenters_value.asXMLElement(document, child);
                OME_element.appendChild(child);
            }
        }
        if (this.experimenterGroups != null) {
            for (ExperimenterGroup experimenterGroups_value : this.experimenterGroups) {
                child = document.createElementNS(NAMESPACE, "ExperimenterGroup");
                experimenterGroups_value.asXMLElement(document, child);
                OME_element.appendChild(child);
            }
        }
        if (this.instruments != null) {
            for (Instrument instruments_value : this.instruments) {
                child = document.createElementNS(NAMESPACE, "Instrument");
                instruments_value.asXMLElement(document, child);
                OME_element.appendChild(child);
            }
        }
        if (this.images != null) {
            for (Image images_value : this.images) {
                child = document.createElementNS(NAMESPACE, "Image");
                images_value.asXMLElement(document, child);
                OME_element.appendChild(child);
            }
        }
        if (this.structuredAnnotations != null) {
            child2 = document.createElementNS(NAMESPACE, "StructuredAnnotations");
            this.structuredAnnotations.asXMLElement(document, (Element)child2);
            OME_element.appendChild((Node)child2);
        }
        if (this.roIs != null) {
            for (ROI roIs_value : this.roIs) {
                child = document.createElementNS(NAMESPACE, "ROI");
                roIs_value.asXMLElement(document, child);
                OME_element.appendChild(child);
            }
        }
        if (this.binaryOnly != null) {
            child2 = document.createElementNS(NAMESPACE, "BinaryOnly");
            this.binaryOnly.asXMLElement(document, (Element)child2);
            OME_element.appendChild((Node)child2);
        }
        return OME_element;
    }
}

