/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.xml.model.primitives.Timestamp;

public class GatanDM2Reader
extends FormatReader {
    private static final int HEADER_SIZE = 24;
    private static final int DM2_MAGIC_BYTES = 0x3D0000;
    private Double pixelSizeX;
    private Double pixelSizeY;
    private String pixelSizeUnits;

    public GatanDM2Reader() {
        super("Gatan DM2", "dm2");
        this.domains = new String[]{"Scanning Probe Microscopy (SPM)"};
        this.suffixNecessary = false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4;
        if (!FormatTools.validStream(stream, 4, false)) {
            return false;
        }
        return stream.readInt() == 0x3D0000;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelSizeX = null;
            this.pixelSizeY = null;
            this.pixelSizeUnits = null;
        }
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        this.in.seek(24L);
        this.readPlane(this.in, x, y, w, h2, buf);
        return buf;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.setEncoding("ISO-8859-1");
        int magicBytes = this.in.readInt();
        if (magicBytes != 0x3D0000) {
            throw new FormatException("Invalid DM2 file");
        }
        this.in.skipBytes(8);
        long footerOffset = this.in.readInt() + 16;
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        m3.sizeX = this.in.readShort();
        m3.sizeY = this.in.readShort();
        short bpp = this.in.readShort();
        boolean signed = this.in.readShort() == 1;
        m3.pixelType = FormatTools.pixelTypeFromBytes(bpp, signed, true);
        m3.sizeC = 1;
        m3.sizeT = 1;
        m3.sizeZ = 1;
        m3.imageCount = 1;
        m3.dimensionOrder = "XYZCT";
        m3.littleEndian = false;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrumentID, 0);
        store.setImageInstrumentRef(instrumentID, 0);
        String date = null;
        String time = null;
        String name = null;
        this.in.skipBytes(FormatTools.getPlaneSize(this) + 35);
        MetadataLevel level = this.getMetadataOptions().getMetadataLevel();
        while (this.in.getFilePointer() < this.in.length() && (level != MetadataLevel.MINIMUM || date == null || time == null || name == null)) {
            StringBuilder value;
            String label;
            block39: {
                int count;
                block44: {
                    String type;
                    block43: {
                        block42: {
                            block41: {
                                int block;
                                block38: {
                                    short strlen;
                                    block40: {
                                        strlen = this.in.readShort();
                                        if (strlen == 0 || strlen > 255) {
                                            this.in.skipBytes(35);
                                            strlen = this.in.readShort();
                                            if (strlen < 0 || (long)strlen + this.in.getFilePointer() >= this.in.length()) {
                                                this.in.seek(this.in.getFilePointer() - 10L);
                                                strlen = this.in.readShort();
                                            }
                                        }
                                        if (strlen < 0 || (long)strlen + this.in.getFilePointer() >= this.in.length()) break;
                                        label = this.in.readString(strlen);
                                        value = new StringBuilder();
                                        block = this.in.readInt();
                                        if (block != 5) break block40;
                                        this.in.skipBytes(33);
                                        if (this.in.readShort() == 0) {
                                            if (this.in.readShort() == 39) {
                                                this.in.skipBytes(1);
                                                break block38;
                                            } else {
                                                this.in.skipBytes(2);
                                            }
                                            break block38;
                                        } else {
                                            this.in.seek(this.in.getFilePointer() - 2L);
                                            continue;
                                        }
                                    }
                                    if (block == 0 || block > 65535 && block < 0x1000000) {
                                        if (block != 0 && strlen > 0) {
                                            this.in.seek(this.in.getFilePointer() - 4L);
                                            value.append(label);
                                            label = "Description";
                                            this.addGlobalMeta(label, value.toString());
                                        } else if (block != 0) {
                                            this.in.skipBytes(15);
                                        }
                                        this.parseExtraTags();
                                        continue;
                                    }
                                    if (block >= 0x1000000) {
                                        this.in.skipBytes(34);
                                        strlen = this.in.readShort();
                                        if ((long)strlen + this.in.getFilePointer() >= this.in.length()) break;
                                        label = this.in.readString(strlen);
                                        block = this.in.readInt();
                                        if (block == 5) {
                                            this.in.skipBytes(33);
                                            continue;
                                        }
                                    }
                                }
                                int len = this.in.readInt();
                                if ((long)len + this.in.getFilePointer() >= this.in.length() || len < 0) break;
                                type = this.in.readString(len);
                                int extra = this.in.readInt() - 2;
                                count = this.in.readInt();
                                if (!type.equals("TEXT")) break block41;
                                value.append(this.in.readString(count));
                                if (block == 5) {
                                    this.in.skipBytes(22);
                                    if (this.in.readInt() == 4) {
                                        if (this.in.readString(4).equals("TEXT")) {
                                            this.in.skipBytes(4);
                                            count = this.in.readInt();
                                            value.append(", " + this.in.readString(count));
                                            this.in.skipBytes(37);
                                            break block39;
                                        } else {
                                            this.in.skipBytes(7);
                                        }
                                        break block39;
                                    } else {
                                        this.in.skipBytes(11);
                                    }
                                }
                                break block39;
                            }
                            if (!type.equals("long")) break block42;
                            count /= 8;
                            for (int i = 0; i < count; ++i) {
                                value.append(this.in.readLong());
                                if (i >= count - 1) continue;
                                value.append(", ");
                            }
                            this.in.skipBytes(4);
                            break block39;
                        }
                        if (!type.equals("bool")) break block43;
                        break block44;
                    }
                    if (type.equals("shor")) {
                        count /= 2;
                        for (int i = 0; i < count; ++i) {
                            value.append(this.in.readShort());
                            if (i >= count - 1) continue;
                            value.append(", ");
                        }
                        break block39;
                    } else if (type.equals("sing")) {
                        count /= 4;
                        for (int i = 0; i < count; ++i) {
                            value.append(this.in.readFloat());
                            if (i >= count - 1) continue;
                            value.append(", ");
                        }
                        break block39;
                    } else {
                        if (count < 0 || (long)count + this.in.getFilePointer() > this.in.length()) break;
                        this.in.skipBytes(count);
                    }
                    break block39;
                }
                for (int i = 0; i < count; ++i) {
                    value.append(this.in.read() == 1);
                    if (i >= count - 1) continue;
                    value.append(", ");
                }
            }
            this.in.skipBytes(16);
            this.addGlobalMeta(label, value.toString());
            if (label.equals("Acquisition Date")) {
                date = value.toString();
                if (date == null || date.indexOf(47) == -1) continue;
                String year = date.substring(date.lastIndexOf("/") + 1);
                if (year.length() < 2) {
                    year = "0" + year;
                }
                date = date.substring(0, date.lastIndexOf("/") + 1) + year;
                continue;
            }
            if (label.equals("Acquisition Time")) {
                time = value.toString();
                continue;
            }
            if (label.equals("Binning")) {
                int bin = (int)Double.parseDouble(value.toString());
                store.setDetectorSettingsBinning(MetadataTools.getBinning(bin + "x" + bin), 0, 0);
                String detectorID = MetadataTools.createLSID("Detector", 0, 0);
                store.setDetectorID(detectorID, 0, 0);
                store.setDetectorSettingsID(detectorID, 0, 0);
                continue;
            }
            if (label.equals("Name")) {
                name = value.toString();
                continue;
            }
            if (!label.equals("Operator")) continue;
            String[] experimenterName = value.toString().split(" ");
            store.setExperimenterFirstName(experimenterName[0], 0);
            if (experimenterName.length > 1) {
                store.setExperimenterLastName(experimenterName[1], 0);
            }
            String expID = MetadataTools.createLSID("Experimenter", 0);
            store.setExperimenterID(expID, 0);
            store.setImageExperimenterRef(expID, 0);
        }
        if (date != null && time != null) {
            String[] format = new String[]{"M/d/yy h:mm:ss a", "d/M/yy h:mm:ss a", "M/d/yy H:mm:ss", "d/M/yy H:mm:ss"};
            date = date + " " + time;
            if ((date = DateTools.formatDate(date, format)) != null) {
                store.setImageAcquisitionDate(new Timestamp(date), 0);
            }
        }
        if (name != null) {
            store.setImageName(name, 0);
        }
        if (this.pixelSizeX != null) {
            store.setPixelsPhysicalSizeX(FormatTools.createLength(this.pixelSizeX, UNITS.MICROMETER), 0);
        }
        if (this.pixelSizeY != null) {
            store.setPixelsPhysicalSizeY(FormatTools.createLength(this.pixelSizeY, UNITS.MICROMETER), 0);
        }
    }

    private void parseExtraTags() throws IOException {
        while (this.in.getFilePointer() < this.in.length()) {
            short tag = this.in.readShort();
            int length = this.in.readInt();
            String value = "foo";
            if (length == 4) {
                value = String.valueOf(this.in.readFloat());
            } else if (length == 2) {
                value = String.valueOf(this.in.readShort());
            } else if (length == 1) {
                value = String.valueOf(this.in.read());
            } else {
                value = this.in.readString(length);
                int nullIndex = value.indexOf("\u0000");
                if (nullIndex >= 0) {
                    value = value.substring(0, nullIndex);
                }
            }
            value = value.trim();
            String label = "Tag " + Integer.toHexString(tag);
            switch (tag) {
                case 17: {
                    label = "BlackContrastLimit";
                    break;
                }
                case 18: {
                    label = "WhiteContrastLimit";
                    break;
                }
                case 22: {
                    label = "Scale";
                    break;
                }
                case 27: {
                    label = "MaxPixelValue";
                    break;
                }
                case 28: {
                    label = "MinPixelValue";
                    break;
                }
                case 31: {
                    label = "Physical width";
                    this.pixelSizeX = new Double(value);
                    break;
                }
                case 32: {
                    label = "Physical height";
                    this.pixelSizeY = new Double(value);
                    break;
                }
                case 37: {
                    label = "Image label";
                    break;
                }
                case 38: {
                    label = "MinimumContrast";
                    break;
                }
                case 53: {
                    label = "Physical size units";
                    this.pixelSizeUnits = value;
                    break;
                }
                case 62: {
                    label = "Origin";
                }
            }
            this.addGlobalMeta(label, value);
        }
        if (this.pixelSizeUnits != null && !this.pixelSizeUnits.equals("\u00b5m")) {
            LOGGER.warn("Unsupported units: " + this.pixelSizeUnits);
        }
    }
}

