/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.dicom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.dicom.DicomAttribute;
import loci.formats.dicom.DicomVR;

public class DicomTag {
    public DicomTag parent = null;
    public List<DicomTag> children = new ArrayList<DicomTag>();
    public int tag;
    public DicomAttribute attribute = null;
    public DicomVR vr = null;
    public String key = null;
    public Object value = null;
    public int elementLength = 0;
    private long start = 0L;
    private boolean bigEndianTransferSyntax = false;
    private boolean oddLocations = false;

    public DicomTag(DicomAttribute attribute) {
        this(attribute, null);
    }

    public DicomTag(DicomAttribute attribute, DicomVR vr) {
        this.attribute = attribute;
        this.vr = vr != null ? vr : attribute.getDefaultVR();
        this.tag = attribute.getTag();
    }

    public DicomTag(RandomAccessInputStream in, boolean bigEndian, long location, boolean oddLocations) throws FormatException, IOException {
        this(in, bigEndian, location, oddLocations, true);
    }

    public DicomTag(RandomAccessInputStream in, boolean bigEndian, long location, boolean oddLocations, boolean readValue) throws FormatException, IOException {
        this.bigEndianTransferSyntax = bigEndian;
        this.oddLocations = oddLocations;
        this.tag = this.getNextTag(in);
        this.attribute = DicomAttribute.get(this.tag);
        this.start = in.getFilePointer();
        this.key = this.attribute != null ? this.attribute.getDescription() : DicomAttribute.getDescription(this.tag);
        String id = null;
        if (this.attribute != null) {
            DicomVR altVR;
            id = this.attribute.getDescription();
            if (this.vr == DicomVR.IMPLICIT && id != null && (altVR = DicomVR.get((id.charAt(0) << 8) + id.charAt(1))) != null) {
                this.vr = altVR;
            }
            if (id.length() > 2) {
                id = id.substring(2);
            }
            if (this.attribute == DicomAttribute.RED_LUT_DATA || this.attribute == DicomAttribute.GREEN_LUT_DATA || this.attribute == DicomAttribute.BLUE_LUT_DATA || this.attribute == DicomAttribute.SEGMENTED_RED_LUT_DATA || this.attribute == DicomAttribute.SEGMENTED_GREEN_LUT_DATA || this.attribute == DicomAttribute.SEGMENTED_BLUE_LUT_DATA) {
                this.vr = DicomVR.US;
            }
        } else if (this.vr == DicomVR.IMPLICIT) {
            this.vr = DicomAttribute.getDefaultVR(this.tag);
        }
        if (!readValue) {
            return;
        }
        if (this.attribute == DicomAttribute.ITEM) {
            this.value = id;
        }
        if (this.value == null) {
            boolean skip;
            boolean bl = skip = this.vr == null;
            if ((this.vr == DicomVR.IMPLICIT || this.vr == DicomVR.RESERVED) && this.attribute != null) {
                this.vr = this.attribute.getDefaultVR();
            }
            if (this.vr != null) {
                switch (this.vr) {
                    case AE: 
                    case AS: 
                    case CS: 
                    case DA: 
                    case DS: 
                    case DT: 
                    case IS: 
                    case LO: 
                    case LT: 
                    case PN: 
                    case SH: 
                    case ST: 
                    case TM: 
                    case UC: 
                    case UI: 
                    case UR: 
                    case UT: {
                        this.value = in.readString(this.elementLength);
                        break;
                    }
                    case AT: {
                        short[] pair = new short[]{in.readShort(), in.readShort()};
                        this.value = pair;
                        break;
                    }
                    case FL: {
                        if (this.elementLength % 4 == 0 && this.elementLength > 4) {
                            float[] f = new float[this.elementLength / 4];
                            for (int i = 0; i < f.length; ++i) {
                                f[i] = in.readFloat();
                            }
                            this.value = f;
                            break;
                        }
                        this.value = Float.valueOf(in.readFloat());
                        break;
                    }
                    case FD: {
                        if (this.elementLength % 8 == 0 && this.elementLength > 8) {
                            double[] d = new double[this.elementLength / 8];
                            for (int i = 0; i < d.length; ++i) {
                                d[i] = in.readDouble();
                            }
                            this.value = d;
                            break;
                        }
                        this.value = in.readDouble();
                        break;
                    }
                    case OB: {
                        this.value = new byte[this.elementLength];
                        in.read((byte[])this.value);
                        break;
                    }
                    case SL: {
                        if (this.elementLength % 4 == 0 && this.elementLength > 4) {
                            long[] v = new long[this.elementLength / 4];
                            for (int i = 0; i < v.length; ++i) {
                                v[i] = in.readInt();
                            }
                            this.value = v;
                            break;
                        }
                        this.value = in.readInt();
                        break;
                    }
                    case SS: {
                        if (this.elementLength == 2) {
                            this.value = in.readShort();
                            break;
                        }
                        short[] values = new short[this.elementLength / 2];
                        for (int i = 0; i < values.length; ++i) {
                            values[i] = in.readShort();
                        }
                        this.value = values;
                        break;
                    }
                    case SV: {
                        if (this.elementLength % 8 == 0 && this.elementLength > 8) {
                            long[] v = new long[this.elementLength / 8];
                            for (int i = 0; i < v.length; ++i) {
                                v[i] = in.readLong();
                            }
                            this.value = v;
                            break;
                        }
                        this.value = in.readLong();
                        break;
                    }
                    case UL: {
                        if (this.elementLength % 4 == 0 && this.elementLength > 4) {
                            long[] v = new long[this.elementLength / 4];
                            for (int i = 0; i < v.length; ++i) {
                                v[i] = (long)in.readInt() & 0xFFFFFFFFL;
                            }
                            this.value = v;
                            break;
                        }
                        this.value = (long)in.readInt() & 0xFFFFFFFFL;
                        break;
                    }
                    case US: {
                        if (this.elementLength == 2) {
                            this.value = in.readShort();
                            break;
                        }
                        short[] values = new short[this.elementLength / 2];
                        for (int i = 0; i < values.length; ++i) {
                            values[i] = in.readShort();
                        }
                        this.value = values;
                        break;
                    }
                    case IMPLICIT: {
                        if (this.elementLength == 2) {
                            this.value = in.readShort();
                            break;
                        }
                        if (this.elementLength <= 44) {
                            this.value = in.readString(this.elementLength);
                            break;
                        }
                        short[] values = new short[this.elementLength / 2];
                        for (int i = 0; i < values.length; ++i) {
                            values[i] = in.readShort();
                        }
                        this.value = values;
                        break;
                    }
                    case SQ: {
                        long stop = in.getFilePointer() + (long)this.elementLength;
                        if (this.elementLength == -1) {
                            stop = in.length();
                            this.elementLength = 0;
                        }
                        while (in.getFilePointer() < stop) {
                            long fp = in.getFilePointer();
                            DicomTag child = new DicomTag(in, bigEndian, location, oddLocations);
                            if (child.attribute == DicomAttribute.SEQUENCE_DELIMITATION_ITEM) {
                                stop = in.getFilePointer();
                                break;
                            }
                            if (child.attribute == DicomAttribute.PIXEL_DATA) {
                                stop = fp;
                                break;
                            }
                            if (child.attribute == DicomAttribute.ITEM || child.attribute == DicomAttribute.ITEM_DELIMITATION_ITEM) continue;
                            child.parent = this;
                            this.children.add(child);
                        }
                        if (this.elementLength == 0) {
                            this.elementLength = (int)(stop - this.start);
                        }
                        in.seek(stop);
                        break;
                    }
                    default: {
                        skip = true;
                    }
                }
            }
            if (skip && this.elementLength > 0) {
                long skipCount = this.elementLength;
                if (in.getFilePointer() + skipCount <= in.length()) {
                    in.skipBytes(skipCount);
                }
                location += (long)this.elementLength;
                this.value = "";
            }
        }
    }

    private int getNextTag(RandomAccessInputStream in) throws FormatException, IOException {
        long fp = in.getFilePointer();
        if (fp >= in.length() - 2L) {
            return 0;
        }
        int groupWord = in.readShort() & 0xFFFF;
        if (groupWord == 2048 && this.bigEndianTransferSyntax) {
            groupWord = 8;
            in.order(false);
        }
        short elementWord = in.readShort();
        int tag = groupWord << 16 & 0xFFFF0000 | elementWord & 0xFFFF;
        this.elementLength = this.getLength(in);
        if ((long)this.elementLength > in.length()) {
            in.seek(fp);
            in.order(!in.isLittleEndian());
            groupWord = in.readShort() & 0xFFFF;
            elementWord = in.readShort();
            tag = groupWord << 16 & 0xFFFF0000 | elementWord & 0xFFFF;
            this.elementLength = this.getLength(in);
            if ((long)this.elementLength > in.length()) {
                throw new FormatException("Invalid tag length " + this.elementLength);
            }
            return tag;
        }
        if (this.elementLength < 0 && groupWord == 32736) {
            in.skipBytes(12);
            this.elementLength = in.readInt();
            if (this.elementLength < 0) {
                this.elementLength = in.readInt();
            }
        }
        if (this.elementLength == 0 && (groupWord == 32736 || tag == 2691092)) {
            this.elementLength = this.getLength(in);
        } else if (this.elementLength == 0) {
            in.seek(in.getFilePointer() - 4L);
            DicomVR v = DicomVR.get(in.readShort() & 0xFFFF);
            if (v == DicomVR.UT) {
                in.skipBytes(2);
                this.elementLength = in.readInt();
            } else {
                in.skipBytes(2);
            }
        }
        if (!this.oddLocations && this.elementLength % 2 == 1) {
            ++this.elementLength;
        }
        return tag;
    }

    private int getLength(RandomAccessInputStream in) throws IOException {
        byte[] b = new byte[4];
        in.read(b);
        this.vr = DicomVR.get((b[0] & 0xFF) << 8 | b[1] & 0xFF);
        if (this.vr == null) {
            this.vr = DicomVR.IMPLICIT;
            int len = DataTools.bytesToInt(b, in.isLittleEndian());
            if ((long)len + in.getFilePointer() > in.length() || len < 0) {
                len = DataTools.bytesToInt(b, 2, 2, in.isLittleEndian());
                len &= 0xFFFF;
            }
            return len;
        }
        switch (this.vr) {
            case UC: 
            case UT: 
            case OB: 
            case SQ: 
            case OW: 
            case UN: {
                if (b[2] == 0 || b[3] == 0) {
                    return in.readInt();
                }
                this.vr = DicomVR.IMPLICIT;
                return DataTools.bytesToInt(b, in.isLittleEndian());
            }
            case AE: 
            case AS: 
            case CS: 
            case DA: 
            case DS: 
            case DT: 
            case IS: 
            case LO: 
            case LT: 
            case PN: 
            case SH: 
            case ST: 
            case TM: 
            case UI: 
            case AT: 
            case FL: 
            case FD: 
            case SL: 
            case SS: 
            case UL: 
            case US: 
            case QQ: {
                if (this.attribute == DicomAttribute.LUT_DATA) {
                    return DataTools.bytesToInt(b, 2, 2, in.isLittleEndian());
                }
                int n1 = DataTools.bytesToShort(b, 2, 2, in.isLittleEndian());
                int n2 = DataTools.bytesToShort(b, 2, 2, !in.isLittleEndian());
                n2 &= 0xFFFF;
                if ((n1 &= 0xFFFF) < 0 || (long)n1 + in.getFilePointer() > in.length()) {
                    return n2;
                }
                if (n2 < 0 || (long)n2 + in.getFilePointer() > in.length()) {
                    return n1;
                }
                return n1;
            }
            case RESERVED: {
                int len = DataTools.bytesToInt(b, 0, 4, in.isLittleEndian());
                if (len == -1) {
                    return len;
                }
                this.vr = DicomVR.IMPLICIT;
                return 8;
            }
        }
        throw new IllegalArgumentException(this.vr.toString());
    }

    public String getStringValue() {
        return this.value == null ? null : this.value.toString().trim();
    }

    public Number getNumberValue() {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof Number) {
            return (Number)this.value;
        }
        String v = this.value.toString().trim();
        try {
            return new Double(v);
        }
        catch (NumberFormatException e) {
            return DataTools.parseDouble(v);
        }
    }

    public long getValueStartPointer() {
        return this.start;
    }

    public long getEndPointer() {
        if (this.elementLength < 0) {
            return this.start;
        }
        return this.start + (long)this.elementLength;
    }

    public DicomTag lookupChild(DicomAttribute attr) {
        for (DicomTag child : this.children) {
            if (child.attribute != attr) continue;
            return child;
        }
        return null;
    }

    public String toString() {
        return this.key + " = " + this.value;
    }
}

