"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OriginAccessIdentity = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const cloudfront_generated_1 = require("./cloudfront.generated");
class OriginAccessIdentityBase extends cdk.Resource {
    /**
     * The ARN to include in S3 bucket policy to allow CloudFront access
     */
    arn() {
        return cdk.Stack.of(this).formatArn({
            service: 'iam',
            region: '',
            account: 'cloudfront',
            resource: 'user',
            resourceName: `CloudFront Origin Access Identity ${this.originAccessIdentityName}`,
        });
    }
}
/**
 * An origin access identity is a special CloudFront user that you can
 * associate with Amazon S3 origins, so that you can secure all or just some of
 * your Amazon S3 content.
 *
 * @resource AWS::CloudFront::CloudFrontOriginAccessIdentity
 */
class OriginAccessIdentity extends OriginAccessIdentityBase {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cloudfront_OriginAccessIdentityProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, OriginAccessIdentity);
            }
            throw error;
        }
        // Comment has a max length of 128.
        const comment = (props?.comment ?? 'Allows CloudFront to reach the bucket').slice(0, 128);
        this.resource = new cloudfront_generated_1.CfnCloudFrontOriginAccessIdentity(this, 'Resource', {
            cloudFrontOriginAccessIdentityConfig: { comment },
        });
        // physical id - OAI name
        this.originAccessIdentityName = this.getResourceNameAttribute(this.resource.ref);
        // Canonical user to grant access to in the S3 Bucket Policy
        this.cloudFrontOriginAccessIdentityS3CanonicalUserId = this.resource.attrS3CanonicalUserId;
        // The principal for must be either the canonical user or a special ARN
        // with the CloudFront Origin Access Id (see `arn()` method). For
        // import/export the OAI is anyway required so the principal is constructed
        // with it. But for the normal case the S3 Canonical User as a nicer
        // interface and does not require constructing the ARN.
        this.grantPrincipal = new iam.CanonicalUserPrincipal(this.cloudFrontOriginAccessIdentityS3CanonicalUserId);
    }
    /**
     * Creates a OriginAccessIdentity by providing the OriginAccessIdentityName
     */
    static fromOriginAccessIdentityName(scope, id, originAccessIdentityName) {
        class Import extends OriginAccessIdentityBase {
            constructor(s, i) {
                super(s, i, { physicalName: originAccessIdentityName });
                this.originAccessIdentityName = originAccessIdentityName;
                this.grantPrincipal = new iam.ArnPrincipal(this.arn());
            }
        }
        return new Import(scope, id);
    }
}
exports.OriginAccessIdentity = OriginAccessIdentity;
_a = JSII_RTTI_SYMBOL_1;
OriginAccessIdentity[_a] = { fqn: "@aws-cdk/aws-cloudfront.OriginAccessIdentity", version: "1.198.1" };
//# sourceMappingURL=data:application/json;base64,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