import { HasProps } from "../core/has_props";
import { Color, Data, Attrs } from "../core/types";
import { Vector } from "../core/vectorization";
import { VectorSpec, ScalarSpec, Property } from "../core/properties";
import { Class } from "../core/class";
import { Location, MarkerType } from "../core/enums";
import { ViewOf } from "../core/view";
import { Glyph, GlyphRenderer, Axis, Grid, Range, Scale, ColumnarDataSource, CDSView, Plot, Tool } from "./models";
import { AnnularWedge, Annulus, Arc, Bezier, Circle, Ellipse, HArea, HBar, HexTile, Image, ImageRGBA, ImageURL, Line, MultiLine, MultiPolygons, Oval, Patch, Patches, Quad, Quadratic, Ray, Rect, Scatter, Segment, Step, Text, VArea, VBar, Wedge } from "../models/glyphs";
import { Marker } from "../models/glyphs/marker";
import { LayoutDOM } from "../models/layouts/layout_dom";
import { Legend } from "../models/annotations/legend";
import { ToolAliases } from "../models/tools/tool";
export { gridplot } from "./gridplot";
export { rgb2hex as color } from "../core/util/color";
export declare type ToolName = keyof ToolAliases;
export declare type VectorArg<T> = T | T[] | Vector<T>;
export declare type ColorArg = VectorArg<Color | null>;
export declare type AlphaArg = VectorArg<number>;
export declare type ColorAlpha = {
    color: ColorArg;
    selection_color: ColorArg;
    nonselection_color: ColorArg;
    hover_color: ColorArg;
    alpha: AlphaArg;
    selection_alpha: AlphaArg;
    nonselection_alpha: AlphaArg;
    hover_alpha: AlphaArg;
};
export declare type AuxFill = {
    selection_fill_color: ColorArg;
    selection_fill_alpha: AlphaArg;
    nonselection_fill_color: ColorArg;
    nonselection_fill_alpha: AlphaArg;
    hover_fill_color: ColorArg;
    hover_fill_alpha: AlphaArg;
};
export declare type AuxLine = {
    selection_line_color: ColorArg;
    selection_line_alpha: AlphaArg;
    nonselection_line_color: ColorArg;
    nonselection_line_alpha: AlphaArg;
    hover_line_color: ColorArg;
    hover_line_alpha: AlphaArg;
};
export declare type AuxText = {
    selection_text_color: ColorArg;
    selection_text_alpha: AlphaArg;
    nonselection_text_color: ColorArg;
    nonselection_text_alpha: AlphaArg;
    hover_text_color: ColorArg;
    hover_text_alpha: AlphaArg;
};
export declare type AuxGlyph = {
    source: ColumnarDataSource;
    view: CDSView;
    legend: string;
};
export declare type ArgsOf<P> = {
    [K in keyof P]: (P[K] extends VectorSpec<infer T, infer V> ? T | T[] | V : (P[K] extends ScalarSpec<infer T, infer S> ? T | S : (P[K] extends Property<infer T> ? T : never)));
};
export declare type GlyphArgs<P> = ArgsOf<P> & AuxGlyph & ColorAlpha;
export declare type AnnularWedgeArgs = GlyphArgs<AnnularWedge.Props> & AuxLine & AuxFill;
export declare type AnnulusArgs = GlyphArgs<Annulus.Props> & AuxLine & AuxFill;
export declare type ArcArgs = GlyphArgs<Arc.Props> & AuxLine;
export declare type BezierArgs = GlyphArgs<Bezier.Props> & AuxLine;
export declare type CircleArgs = GlyphArgs<Circle.Props> & AuxLine & AuxFill;
export declare type EllipseArgs = GlyphArgs<Ellipse.Props> & AuxLine & AuxFill;
export declare type HAreaArgs = GlyphArgs<HArea.Props> & AuxFill;
export declare type HBarArgs = GlyphArgs<HBar.Props> & AuxLine & AuxFill;
export declare type HexTileArgs = GlyphArgs<HexTile.Props> & AuxLine & AuxFill;
export declare type ImageArgs = GlyphArgs<Image.Props>;
export declare type ImageRGBAArgs = GlyphArgs<ImageRGBA.Props>;
export declare type ImageURLArgs = GlyphArgs<ImageURL.Props>;
export declare type LineArgs = GlyphArgs<Line.Props> & AuxLine;
export declare type MarkerArgs = GlyphArgs<Marker.Props> & AuxLine & AuxFill;
export declare type MultiLineArgs = GlyphArgs<MultiLine.Props> & AuxLine;
export declare type MultiPolygonsArgs = GlyphArgs<MultiPolygons.Props> & AuxLine & AuxFill;
export declare type OvalArgs = GlyphArgs<Oval.Props> & AuxLine & AuxFill;
export declare type PatchArgs = GlyphArgs<Patch.Props> & AuxLine & AuxFill;
export declare type PatchesArgs = GlyphArgs<Patches.Props> & AuxLine & AuxFill;
export declare type QuadArgs = GlyphArgs<Quad.Props> & AuxLine & AuxFill;
export declare type QuadraticArgs = GlyphArgs<Quadratic.Props> & AuxLine;
export declare type RayArgs = GlyphArgs<Ray.Props> & AuxLine;
export declare type RectArgs = GlyphArgs<Rect.Props> & AuxLine & AuxFill;
export declare type ScatterArgs = GlyphArgs<Scatter.Props> & AuxLine & AuxFill;
export declare type SegmentArgs = GlyphArgs<Segment.Props> & AuxLine;
export declare type StepArgs = GlyphArgs<Step.Props> & AuxLine;
export declare type TextArgs = GlyphArgs<Text.Props> & AuxText;
export declare type VAreaArgs = GlyphArgs<VArea.Props> & AuxFill;
export declare type VBarArgs = GlyphArgs<VBar.Props> & AuxLine & AuxFill;
export declare type WedgeArgs = GlyphArgs<Wedge.Props> & AuxLine & AuxFill;
export declare type AxisType = "auto" | "linear" | "datetime" | "log" | "mercator" | null;
export declare namespace Figure {
    type Attrs = Omit<Plot.Attrs, "x_range" | "y_range"> & {
        x_range: Range | [number, number] | string[];
        y_range: Range | [number, number] | string[];
        x_axis_type: AxisType;
        y_axis_type: AxisType;
        x_axis_location: Location;
        y_axis_location: Location;
        x_axis_label: string;
        y_axis_label: string;
        x_minor_ticks: number | "auto";
        y_minor_ticks: number | "auto";
        tools: (Tool | ToolName)[] | string;
    };
}
export declare class Figure extends Plot {
    static __name__: string;
    get xgrid(): Grid[];
    get ygrid(): Grid[];
    get xaxis(): Axis[];
    get yaxis(): Axis[];
    get legend(): Legend;
    constructor(attrs?: Partial<Figure.Attrs>);
    annular_wedge(args: Partial<AnnularWedgeArgs>): GlyphRenderer;
    annular_wedge(x: AnnularWedgeArgs["x"], y: AnnularWedgeArgs["y"], inner_radius: AnnularWedgeArgs["inner_radius"], outer_radius: AnnularWedgeArgs["outer_radius"], start_angle: AnnularWedgeArgs["start_angle"], end_angle: AnnularWedgeArgs["end_angle"], args?: Partial<AnnularWedgeArgs>): GlyphRenderer;
    annulus(args: Partial<AnnulusArgs>): GlyphRenderer;
    annulus(x: AnnulusArgs["x"], y: AnnulusArgs["y"], inner_radius: AnnulusArgs["inner_radius"], outer_radius: AnnulusArgs["outer_radius"], args?: Partial<AnnulusArgs>): GlyphRenderer;
    arc(args: Partial<ArcArgs>): GlyphRenderer;
    arc(x: ArcArgs["x"], y: ArcArgs["y"], radius: ArcArgs["radius"], start_angle: ArcArgs["start_angle"], end_angle: ArcArgs["end_angle"], args?: Partial<ArcArgs>): GlyphRenderer;
    bezier(args: Partial<BezierArgs>): GlyphRenderer;
    bezier(x0: BezierArgs["x0"], y0: BezierArgs["y0"], x1: BezierArgs["x1"], y1: BezierArgs["y1"], cx0: BezierArgs["cx0"], cy0: BezierArgs["cy0"], cx1: BezierArgs["cx1"], cy1: BezierArgs["cy1"], args?: Partial<BezierArgs>): GlyphRenderer;
    circle(args: Partial<CircleArgs>): GlyphRenderer;
    circle(x: CircleArgs["x"], y: CircleArgs["y"], args?: Partial<CircleArgs>): GlyphRenderer;
    ellipse(args: Partial<EllipseArgs>): GlyphRenderer;
    ellipse(x: EllipseArgs["x"], y: EllipseArgs["y"], width: EllipseArgs["width"], height: EllipseArgs["height"], args?: Partial<EllipseArgs>): GlyphRenderer;
    harea(args: Partial<HAreaArgs>): GlyphRenderer;
    harea(x1: HAreaArgs["x1"], x2: HAreaArgs["x2"], y: HAreaArgs["y"], args?: Partial<HAreaArgs>): GlyphRenderer;
    hbar(args: Partial<HBarArgs>): GlyphRenderer;
    hbar(y: HBarArgs["y"], height: HBarArgs["height"], right: HBarArgs["right"], left: HBarArgs["left"], args?: Partial<HBarArgs>): GlyphRenderer;
    hex_tile(args: Partial<HexTileArgs>): GlyphRenderer;
    hex_tile(q: HexTileArgs["q"], r: HexTileArgs["r"], args?: Partial<HexTileArgs>): GlyphRenderer;
    image(args: Partial<ImageArgs>): GlyphRenderer;
    image(image: ImageArgs["image"], x: ImageArgs["x"], y: ImageArgs["y"], dw: ImageArgs["dw"], dh: ImageArgs["dh"], args?: Partial<ImageArgs>): GlyphRenderer;
    image_rgba(args: Partial<ImageRGBAArgs>): GlyphRenderer;
    image_rgba(image: ImageRGBAArgs["image"], x: ImageRGBAArgs["x"], y: ImageRGBAArgs["y"], dw: ImageRGBAArgs["dw"], dh: ImageRGBAArgs["dh"], args?: Partial<ImageRGBAArgs>): GlyphRenderer;
    image_url(args: Partial<ImageURLArgs>): GlyphRenderer;
    image_url(url: ImageURLArgs["url"], x: ImageURLArgs["x"], y: ImageURLArgs["y"], w: ImageURLArgs["w"], h: ImageURLArgs["h"], args?: Partial<ImageURLArgs>): GlyphRenderer;
    line(args: Partial<LineArgs>): GlyphRenderer;
    line(x: LineArgs["x"], y: LineArgs["y"], args?: Partial<LineArgs>): GlyphRenderer;
    multi_line(args: Partial<MultiLineArgs>): GlyphRenderer;
    multi_line(xs: MultiLineArgs["xs"], ys: MultiLineArgs["ys"], args?: Partial<MultiLineArgs>): GlyphRenderer;
    multi_polygons(args: Partial<MultiPolygonsArgs>): GlyphRenderer;
    multi_polygons(xs: MultiPolygonsArgs["xs"], ys: MultiPolygonsArgs["ys"], args?: Partial<MultiPolygonsArgs>): GlyphRenderer;
    oval(args: Partial<OvalArgs>): GlyphRenderer;
    oval(x: OvalArgs["x"], y: OvalArgs["y"], width: OvalArgs["width"], height: OvalArgs["height"], args?: Partial<OvalArgs>): GlyphRenderer;
    patch(args: Partial<PatchArgs>): GlyphRenderer;
    patch(x: PatchArgs["x"], y: PatchArgs["y"], args?: Partial<PatchArgs>): GlyphRenderer;
    patches(args: Partial<PatchesArgs>): GlyphRenderer;
    patches(xs: PatchesArgs["xs"], ys: PatchesArgs["ys"], args?: Partial<PatchesArgs>): GlyphRenderer;
    quad(args: Partial<QuadArgs>): GlyphRenderer;
    quad(left: QuadArgs["left"], right: QuadArgs["right"], bottom: QuadArgs["bottom"], top: QuadArgs["top"], args?: Partial<QuadArgs>): GlyphRenderer;
    quadratic(args: Partial<QuadraticArgs>): GlyphRenderer;
    quadratic(x0: QuadraticArgs["x0"], y0: QuadraticArgs["y0"], x1: QuadraticArgs["x1"], y1: QuadraticArgs["y1"], cx: QuadraticArgs["cx"], cy: QuadraticArgs["cy"], args?: Partial<QuadraticArgs>): GlyphRenderer;
    ray(args: Partial<RayArgs>): GlyphRenderer;
    ray(x: RayArgs["x"], y: RayArgs["y"], length: RayArgs["length"], args?: Partial<RayArgs>): GlyphRenderer;
    rect(args: Partial<RectArgs>): GlyphRenderer;
    rect(x: RectArgs["x"], y: RectArgs["y"], width: RectArgs["width"], height: RectArgs["height"], args?: Partial<RectArgs>): GlyphRenderer;
    segment(args: Partial<SegmentArgs>): GlyphRenderer;
    segment(x0: SegmentArgs["x0"], y0: SegmentArgs["y0"], x1: SegmentArgs["x1"], y1: SegmentArgs["y1"], args?: Partial<SegmentArgs>): GlyphRenderer;
    step(args: Partial<StepArgs>): GlyphRenderer;
    step(x: StepArgs["x"], y: StepArgs["y"], mode: StepArgs["mode"], args?: Partial<StepArgs>): GlyphRenderer;
    text(args: Partial<TextArgs>): GlyphRenderer;
    text(x: TextArgs["x"], y: TextArgs["y"], text: TextArgs["text"], args?: Partial<TextArgs>): GlyphRenderer;
    varea(args: Partial<VAreaArgs>): GlyphRenderer;
    varea(x: VAreaArgs["x"], y1: VAreaArgs["y1"], y2: VAreaArgs["y2"], args?: Partial<VAreaArgs>): GlyphRenderer;
    vbar(args: Partial<VBarArgs>): GlyphRenderer;
    vbar(x: VBarArgs["x"], width: VBarArgs["width"], top: VBarArgs["top"], bottom: VBarArgs["bottom"], args?: Partial<VBarArgs>): GlyphRenderer;
    wedge(args: Partial<WedgeArgs>): GlyphRenderer;
    wedge(x: WedgeArgs["x"], y: WedgeArgs["y"], radius: WedgeArgs["radius"], start_angle: WedgeArgs["start_angle"], end_angle: WedgeArgs["end_angle"], args?: Partial<WedgeArgs>): GlyphRenderer;
    protected _scatter(args: unknown[], marker?: MarkerType): GlyphRenderer;
    scatter(args: Partial<ScatterArgs>): GlyphRenderer;
    scatter(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<ScatterArgs>): GlyphRenderer;
    asterisk(args: Partial<MarkerArgs>): GlyphRenderer;
    asterisk(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): GlyphRenderer;
    circle_cross(args: Partial<MarkerArgs>): GlyphRenderer;
    circle_cross(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): GlyphRenderer;
    circle_dot(args: Partial<MarkerArgs>): GlyphRenderer;
    circle_dot(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): GlyphRenderer;
    circle_x(args: Partial<MarkerArgs>): GlyphRenderer;
    circle_x(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): GlyphRenderer;
    circle_y(args: Partial<MarkerArgs>): GlyphRenderer;
    circle_y(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): GlyphRenderer;
    cross(args: Partial<MarkerArgs>): GlyphRenderer;
    cross(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): GlyphRenderer;
    dash(args: Partial<MarkerArgs>): GlyphRenderer;
    dash(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): GlyphRenderer;
    diamond(args: Partial<MarkerArgs>): GlyphRenderer;
    diamond(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): GlyphRenderer;
    diamond_cross(args: Partial<MarkerArgs>): GlyphRenderer;
    diamond_cross(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): GlyphRenderer;
    diamond_dot(args: Partial<MarkerArgs>): GlyphRenderer;
    diamond_dot(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): GlyphRenderer;
    dot(args: Partial<MarkerArgs>): GlyphRenderer;
    dot(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): GlyphRenderer;
    hex(args: Partial<MarkerArgs>): GlyphRenderer;
    hex(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): GlyphRenderer;
    hex_dot(args: Partial<MarkerArgs>): GlyphRenderer;
    hex_dot(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): GlyphRenderer;
    inverted_triangle(args: Partial<MarkerArgs>): GlyphRenderer;
    inverted_triangle(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): GlyphRenderer;
    plus(args: Partial<MarkerArgs>): GlyphRenderer;
    plus(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): GlyphRenderer;
    square(args: Partial<MarkerArgs>): GlyphRenderer;
    square(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): GlyphRenderer;
    square_cross(args: Partial<MarkerArgs>): GlyphRenderer;
    square_cross(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): GlyphRenderer;
    square_dot(args: Partial<MarkerArgs>): GlyphRenderer;
    square_dot(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): GlyphRenderer;
    square_pin(args: Partial<MarkerArgs>): GlyphRenderer;
    square_pin(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): GlyphRenderer;
    square_x(args: Partial<MarkerArgs>): GlyphRenderer;
    square_x(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): GlyphRenderer;
    triangle(args: Partial<MarkerArgs>): GlyphRenderer;
    triangle(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): GlyphRenderer;
    triangle_dot(args: Partial<MarkerArgs>): GlyphRenderer;
    triangle_dot(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): GlyphRenderer;
    triangle_pin(args: Partial<MarkerArgs>): GlyphRenderer;
    triangle_pin(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): GlyphRenderer;
    x(args: Partial<MarkerArgs>): GlyphRenderer;
    x(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): GlyphRenderer;
    y(args: Partial<MarkerArgs>): GlyphRenderer;
    y(x: MarkerArgs["x"], y: MarkerArgs["y"], args?: Partial<MarkerArgs>): GlyphRenderer;
    _pop_visuals(cls: Class<HasProps>, props: Attrs, prefix?: string, defaults?: Attrs, override_defaults?: Attrs): Attrs;
    _find_uniq_name(data: Data, name: string): string;
    _fixup_values(cls: Class<HasProps>, data: Data, attrs: Attrs): void;
    _glyph(cls: Class<Glyph>, params_string: string, args: unknown[], overrides?: object): GlyphRenderer;
    static _get_range(range?: Range | [number, number] | string[]): Range;
    static _get_scale(range_input: Range, axis_type: AxisType): Scale;
    _process_axis_and_grid(axis_type: AxisType, axis_location: Location, minor_ticks: number | "auto" | undefined, axis_label: string, rng: Range, dim: 0 | 1): void;
    _get_axis(axis_type: AxisType, range: Range, dim: 0 | 1): Axis | null;
    _get_num_minor_ticks(axis: Axis, num_minor_ticks?: number | "auto"): number;
    _process_tools(tools: (Tool | string)[] | string): Tool[];
    _process_legend(legend: string | Vector<string> | undefined, source: ColumnarDataSource): Vector<string> | null;
    _update_legend(legend_item_label: Vector<string>, glyph_renderer: GlyphRenderer): void;
}
export declare function figure(attributes?: Partial<Figure.Attrs>): Figure;
export declare function show<T extends LayoutDOM>(obj: T, target?: HTMLElement | string): Promise<ViewOf<T>>;
export declare function show<T extends LayoutDOM>(obj: T[], target?: HTMLElement | string): Promise<ViewOf<T>[]>;
//# sourceMappingURL=plotting.d.ts.map