import flatpickr from "flatpickr";
import { InputWidget, InputWidgetView } from "./input_widget";
import { input } from "../../core/dom";
import { CalendarPosition } from "../../core/enums";
import { isString } from "../../core/util/types";
import { bk_input } from "../../styles/widgets/inputs";
import flatpickr_css from "../../styles/widgets/flatpickr.css";
function _convert_date_list(value) {
    const result = [];
    for (const item of value) {
        if (isString(item))
            result.push(item);
        else {
            const [from, to] = item;
            result.push({ from, to });
        }
    }
    return result;
}
export class DatePickerView extends InputWidgetView {
    connect_signals() {
        super.connect_signals();
        const { value, min_date, max_date, disabled_dates, enabled_dates, position, inline } = this.model.properties;
        this.connect(value.change, () => this._picker?.setDate(value.value()));
        this.connect(min_date.change, () => this._picker?.set("minDate", min_date.value()));
        this.connect(max_date.change, () => this._picker?.set("maxDate", max_date.value()));
        this.connect(disabled_dates.change, () => this._picker?.set("disable", disabled_dates.value()));
        this.connect(enabled_dates.change, () => this._picker?.set("enable", enabled_dates.value()));
        this.connect(position.change, () => this._picker?.set("position", position.value()));
        this.connect(inline.change, () => this._picker?.set("inline", inline.value()));
    }
    remove() {
        this._picker?.destroy();
        super.remove();
    }
    styles() {
        return [...super.styles(), flatpickr_css];
    }
    render() {
        if (this._picker != null)
            return;
        super.render();
        this.input_el = input({ type: "text", class: bk_input, disabled: this.model.disabled });
        this.group_el.appendChild(this.input_el);
        this._picker = flatpickr(this.input_el, {
            defaultDate: this.model.value,
            minDate: this.model.min_date,
            maxDate: this.model.max_date,
            inline: this.model.inline,
            position: this.model.position,
            disable: _convert_date_list(this.model.disabled_dates),
            enable: _convert_date_list(this.model.enabled_dates),
            onChange: (selected_dates, date_string, instance) => this._on_change(selected_dates, date_string, instance),
        });
    }
    _on_change(_selected_dates, date_string, _instance) {
        this.model.value = date_string;
        this.change_input();
    }
}
DatePickerView.__name__ = "DatePickerView";
export class DatePicker extends InputWidget {
    constructor(attrs) {
        super(attrs);
    }
    static init_DatePicker() {
        this.prototype.default_view = DatePickerView;
        this.define(({ Boolean, String, Array, Tuple, Or }) => {
            const DateStr = String;
            const DatesList = Array(Or(DateStr, Tuple(DateStr, DateStr)));
            return {
                value: [String],
                min_date: [String],
                max_date: [String],
                disabled_dates: [DatesList, []],
                enabled_dates: [DatesList, []],
                position: [CalendarPosition, "auto"],
                inline: [Boolean, false],
            };
        });
    }
}
DatePicker.__name__ = "DatePicker";
DatePicker.init_DatePicker();
//# sourceMappingURL=date_picker.js.map