# coding: utf-8

"""
    FINBOURNE Insights API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, constr
from finbourne_insights.models.resource import Resource

class AuditData(BaseModel):
    """
    AuditData
    """
    action: constr(strict=True, max_length=64, min_length=0) = Field(...)
    category: constr(strict=True, max_length=16, min_length=0) = Field(...)
    user_id: Optional[constr(strict=True, max_length=128, min_length=0)] = Field(None, alias="userId")
    message: Optional[constr(strict=True, max_length=1024, min_length=0)] = None
    resource: Optional[Resource] = None
    details_type: Optional[constr(strict=True, max_length=16, min_length=0)] = Field(None, alias="detailsType")
    details: Optional[Any] = None
    __properties = ["action", "category", "userId", "message", "resource", "detailsType", "details"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AuditData:
        """Create an instance of AuditData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of resource
        if self.resource:
            _dict['resource'] = self.resource.to_dict()
        # set to None if user_id (nullable) is None
        # and __fields_set__ contains the field
        if self.user_id is None and "user_id" in self.__fields_set__:
            _dict['userId'] = None

        # set to None if message (nullable) is None
        # and __fields_set__ contains the field
        if self.message is None and "message" in self.__fields_set__:
            _dict['message'] = None

        # set to None if details_type (nullable) is None
        # and __fields_set__ contains the field
        if self.details_type is None and "details_type" in self.__fields_set__:
            _dict['detailsType'] = None

        # set to None if details (nullable) is None
        # and __fields_set__ contains the field
        if self.details is None and "details" in self.__fields_set__:
            _dict['details'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AuditData:
        """Create an instance of AuditData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AuditData.parse_obj(obj)

        _obj = AuditData.parse_obj({
            "action": obj.get("action"),
            "category": obj.get("category"),
            "user_id": obj.get("userId"),
            "message": obj.get("message"),
            "resource": Resource.from_dict(obj.get("resource")) if obj.get("resource") is not None else None,
            "details_type": obj.get("detailsType"),
            "details": obj.get("details")
        })
        return _obj
