/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.glm;

import hex.genmodel.GenModel;
import hex.genmodel.algos.glm.GlmMojoModelBase;
import java.io.Serializable;

public class GlmMojoModel
extends GlmMojoModelBase {
    String _link;
    double _tweedieLinkPower;
    private Function1 _linkFn;
    private boolean _binomial;

    GlmMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    void init() {
        this._linkFn = this.createLinkFunction();
        this._binomial = this._family.equals("binomial");
    }

    @Override
    double[] glmScore0(double[] data, double[] preds) {
        int ival;
        int i2;
        double eta = 0.0;
        if (!this._useAllFactorLevels) {
            for (i2 = 0; i2 < this._catOffsets.length - 1; ++i2) {
                if (data[i2] == 0.0) continue;
                ival = (int)data[i2] - 1;
                if ((double)ival != data[i2] - 1.0) {
                    throw new IllegalArgumentException("categorical value out of range");
                }
                if ((ival += this._catOffsets[i2]) >= this._catOffsets[i2 + 1]) continue;
                eta += this._beta[ival];
            }
        } else {
            for (i2 = 0; i2 < this._catOffsets.length - 1; ++i2) {
                ival = (int)data[i2];
                if ((double)ival != data[i2]) {
                    throw new IllegalArgumentException("categorical value out of range");
                }
                if ((ival += this._catOffsets[i2]) >= this._catOffsets[i2 + 1]) continue;
                eta += this._beta[ival];
            }
        }
        int noff = this._catOffsets[this._cats] - this._cats;
        for (int i3 = this._cats; i3 < this._beta.length - 1 - noff; ++i3) {
            eta += this._beta[noff + i3] * data[i3];
        }
        double mu = this._linkFn.eval(eta += this._beta[this._beta.length - 1]);
        if (this._binomial || this._family.equals("fractionalbinomial")) {
            preds[0] = mu >= this._defaultThreshold ? 1.0 : 0.0;
            preds[1] = 1.0 - mu;
            preds[2] = mu;
        } else {
            preds[0] = mu;
        }
        return preds;
    }

    public double[] applyCoefficients(double[] data, double[] output, int destPos) {
        int offset = this._useAllFactorLevels ? 0 : -1;
        for (int i2 = 0; i2 < this._catOffsets.length - 1; ++i2) {
            int ival = (int)data[i2] - offset;
            if (ival < 0 || (ival += this._catOffsets[i2]) >= this._catOffsets[i2 + 1]) continue;
            output[i2 + destPos] = this._beta[ival];
        }
        int p2 = destPos + this._catOffsets.length - 1;
        int noff = this._catOffsets[this._cats] - this._cats;
        for (int i3 = this._cats; i3 < this._beta.length - 1 - noff; ++i3) {
            output[p2++] = this._beta[noff + i3] * data[i3];
        }
        return output;
    }

    public double getIntercept() {
        return this._beta[this._beta.length - 1];
    }

    private Function1 createLinkFunction() {
        if ("identity".equals(this._link)) {
            return new GLM_identityInv();
        }
        if ("logit".equals(this._link)) {
            return new GLM_logitInv();
        }
        if ("log".equals(this._link)) {
            return new GLM_logInv();
        }
        if ("inverse".equals(this._link)) {
            return new GLM_inverseInv();
        }
        if ("tweedie".equals(this._link)) {
            return new GLM_tweedieInv(this._tweedieLinkPower);
        }
        throw new UnsupportedOperationException("Unexpected link function " + this._link);
    }

    private static class GLM_tweedieInv
    implements Function1 {
        private final double _tweedie_link_power;

        GLM_tweedieInv(double tweedie_link_power) {
            this._tweedie_link_power = tweedie_link_power;
        }

        @Override
        public double eval(double x2) {
            return GenModel.GLM_tweedieInv(x2, this._tweedie_link_power);
        }
    }

    private static class GLM_ologitInv
    implements Function1 {
        private GLM_ologitInv() {
        }

        @Override
        public double eval(double x2) {
            return GenModel.GLM_ologitInv(x2);
        }
    }

    private static class GLM_inverseInv
    implements Function1 {
        private GLM_inverseInv() {
        }

        @Override
        public double eval(double x2) {
            return GenModel.GLM_inverseInv(x2);
        }
    }

    private static class GLM_logInv
    implements Function1 {
        private GLM_logInv() {
        }

        @Override
        public double eval(double x2) {
            return GenModel.GLM_logInv(x2);
        }
    }

    private static class GLM_logitInv
    implements Function1 {
        private GLM_logitInv() {
        }

        @Override
        public double eval(double x2) {
            return GenModel.GLM_logitInv(x2);
        }
    }

    private static class GLM_identityInv
    implements Function1 {
        private GLM_identityInv() {
        }

        @Override
        public double eval(double x2) {
            return GenModel.GLM_identityInv(x2);
        }
    }

    private static interface Function1
    extends Serializable {
        public double eval(double var1);
    }
}

