# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import WfmIntradayDataUpdateTopicIntradayDataGroup
    from . import WfmIntradayDataUpdateTopicIntradayMetric

class WfmIntradayDataUpdateTopicIntradayDataUpdate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WfmIntradayDataUpdateTopicIntradayDataUpdate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'start_date': 'datetime',
            'end_date': 'datetime',
            'interval_length_minutes': 'int',
            'number_of_intervals': 'int',
            'metrics': 'list[WfmIntradayDataUpdateTopicIntradayMetric]',
            'queue_ids': 'list[str]',
            'intraday_data_groupings': 'list[WfmIntradayDataUpdateTopicIntradayDataGroup]'
        }

        self.attribute_map = {
            'start_date': 'startDate',
            'end_date': 'endDate',
            'interval_length_minutes': 'intervalLengthMinutes',
            'number_of_intervals': 'numberOfIntervals',
            'metrics': 'metrics',
            'queue_ids': 'queueIds',
            'intraday_data_groupings': 'intradayDataGroupings'
        }

        self._start_date = None
        self._end_date = None
        self._interval_length_minutes = None
        self._number_of_intervals = None
        self._metrics = None
        self._queue_ids = None
        self._intraday_data_groupings = None

    @property
    def start_date(self) -> datetime:
        """
        Gets the start_date of this WfmIntradayDataUpdateTopicIntradayDataUpdate.


        :return: The start_date of this WfmIntradayDataUpdateTopicIntradayDataUpdate.
        :rtype: datetime
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date: datetime) -> None:
        """
        Sets the start_date of this WfmIntradayDataUpdateTopicIntradayDataUpdate.


        :param start_date: The start_date of this WfmIntradayDataUpdateTopicIntradayDataUpdate.
        :type: datetime
        """
        

        self._start_date = start_date

    @property
    def end_date(self) -> datetime:
        """
        Gets the end_date of this WfmIntradayDataUpdateTopicIntradayDataUpdate.


        :return: The end_date of this WfmIntradayDataUpdateTopicIntradayDataUpdate.
        :rtype: datetime
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date: datetime) -> None:
        """
        Sets the end_date of this WfmIntradayDataUpdateTopicIntradayDataUpdate.


        :param end_date: The end_date of this WfmIntradayDataUpdateTopicIntradayDataUpdate.
        :type: datetime
        """
        

        self._end_date = end_date

    @property
    def interval_length_minutes(self) -> int:
        """
        Gets the interval_length_minutes of this WfmIntradayDataUpdateTopicIntradayDataUpdate.


        :return: The interval_length_minutes of this WfmIntradayDataUpdateTopicIntradayDataUpdate.
        :rtype: int
        """
        return self._interval_length_minutes

    @interval_length_minutes.setter
    def interval_length_minutes(self, interval_length_minutes: int) -> None:
        """
        Sets the interval_length_minutes of this WfmIntradayDataUpdateTopicIntradayDataUpdate.


        :param interval_length_minutes: The interval_length_minutes of this WfmIntradayDataUpdateTopicIntradayDataUpdate.
        :type: int
        """
        

        self._interval_length_minutes = interval_length_minutes

    @property
    def number_of_intervals(self) -> int:
        """
        Gets the number_of_intervals of this WfmIntradayDataUpdateTopicIntradayDataUpdate.


        :return: The number_of_intervals of this WfmIntradayDataUpdateTopicIntradayDataUpdate.
        :rtype: int
        """
        return self._number_of_intervals

    @number_of_intervals.setter
    def number_of_intervals(self, number_of_intervals: int) -> None:
        """
        Sets the number_of_intervals of this WfmIntradayDataUpdateTopicIntradayDataUpdate.


        :param number_of_intervals: The number_of_intervals of this WfmIntradayDataUpdateTopicIntradayDataUpdate.
        :type: int
        """
        

        self._number_of_intervals = number_of_intervals

    @property
    def metrics(self) -> List['WfmIntradayDataUpdateTopicIntradayMetric']:
        """
        Gets the metrics of this WfmIntradayDataUpdateTopicIntradayDataUpdate.


        :return: The metrics of this WfmIntradayDataUpdateTopicIntradayDataUpdate.
        :rtype: list[WfmIntradayDataUpdateTopicIntradayMetric]
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics: List['WfmIntradayDataUpdateTopicIntradayMetric']) -> None:
        """
        Sets the metrics of this WfmIntradayDataUpdateTopicIntradayDataUpdate.


        :param metrics: The metrics of this WfmIntradayDataUpdateTopicIntradayDataUpdate.
        :type: list[WfmIntradayDataUpdateTopicIntradayMetric]
        """
        

        self._metrics = metrics

    @property
    def queue_ids(self) -> List[str]:
        """
        Gets the queue_ids of this WfmIntradayDataUpdateTopicIntradayDataUpdate.


        :return: The queue_ids of this WfmIntradayDataUpdateTopicIntradayDataUpdate.
        :rtype: list[str]
        """
        return self._queue_ids

    @queue_ids.setter
    def queue_ids(self, queue_ids: List[str]) -> None:
        """
        Sets the queue_ids of this WfmIntradayDataUpdateTopicIntradayDataUpdate.


        :param queue_ids: The queue_ids of this WfmIntradayDataUpdateTopicIntradayDataUpdate.
        :type: list[str]
        """
        

        self._queue_ids = queue_ids

    @property
    def intraday_data_groupings(self) -> List['WfmIntradayDataUpdateTopicIntradayDataGroup']:
        """
        Gets the intraday_data_groupings of this WfmIntradayDataUpdateTopicIntradayDataUpdate.


        :return: The intraday_data_groupings of this WfmIntradayDataUpdateTopicIntradayDataUpdate.
        :rtype: list[WfmIntradayDataUpdateTopicIntradayDataGroup]
        """
        return self._intraday_data_groupings

    @intraday_data_groupings.setter
    def intraday_data_groupings(self, intraday_data_groupings: List['WfmIntradayDataUpdateTopicIntradayDataGroup']) -> None:
        """
        Sets the intraday_data_groupings of this WfmIntradayDataUpdateTopicIntradayDataUpdate.


        :param intraday_data_groupings: The intraday_data_groupings of this WfmIntradayDataUpdateTopicIntradayDataUpdate.
        :type: list[WfmIntradayDataUpdateTopicIntradayDataGroup]
        """
        

        self._intraday_data_groupings = intraday_data_groupings

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

