# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class WfmBuShortTermForecastCopyCompleteTopicForecastSourceDayPointer(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WfmBuShortTermForecastCopyCompleteTopicForecastSourceDayPointer - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'day_of_week': 'str',
            'weight': 'int',
            'date': 'str',
            'file_name': 'str',
            'data_key': 'str'
        }

        self.attribute_map = {
            'day_of_week': 'dayOfWeek',
            'weight': 'weight',
            'date': 'date',
            'file_name': 'fileName',
            'data_key': 'dataKey'
        }

        self._day_of_week = None
        self._weight = None
        self._date = None
        self._file_name = None
        self._data_key = None

    @property
    def day_of_week(self) -> str:
        """
        Gets the day_of_week of this WfmBuShortTermForecastCopyCompleteTopicForecastSourceDayPointer.


        :return: The day_of_week of this WfmBuShortTermForecastCopyCompleteTopicForecastSourceDayPointer.
        :rtype: str
        """
        return self._day_of_week

    @day_of_week.setter
    def day_of_week(self, day_of_week: str) -> None:
        """
        Sets the day_of_week of this WfmBuShortTermForecastCopyCompleteTopicForecastSourceDayPointer.


        :param day_of_week: The day_of_week of this WfmBuShortTermForecastCopyCompleteTopicForecastSourceDayPointer.
        :type: str
        """
        allowed_values = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "EighthDay"]
        if day_of_week.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for day_of_week -> " + day_of_week)
            self._day_of_week = "outdated_sdk_version"
        else:
            self._day_of_week = day_of_week

    @property
    def weight(self) -> int:
        """
        Gets the weight of this WfmBuShortTermForecastCopyCompleteTopicForecastSourceDayPointer.


        :return: The weight of this WfmBuShortTermForecastCopyCompleteTopicForecastSourceDayPointer.
        :rtype: int
        """
        return self._weight

    @weight.setter
    def weight(self, weight: int) -> None:
        """
        Sets the weight of this WfmBuShortTermForecastCopyCompleteTopicForecastSourceDayPointer.


        :param weight: The weight of this WfmBuShortTermForecastCopyCompleteTopicForecastSourceDayPointer.
        :type: int
        """
        

        self._weight = weight

    @property
    def date(self) -> str:
        """
        Gets the date of this WfmBuShortTermForecastCopyCompleteTopicForecastSourceDayPointer.


        :return: The date of this WfmBuShortTermForecastCopyCompleteTopicForecastSourceDayPointer.
        :rtype: str
        """
        return self._date

    @date.setter
    def date(self, date: str) -> None:
        """
        Sets the date of this WfmBuShortTermForecastCopyCompleteTopicForecastSourceDayPointer.


        :param date: The date of this WfmBuShortTermForecastCopyCompleteTopicForecastSourceDayPointer.
        :type: str
        """
        

        self._date = date

    @property
    def file_name(self) -> str:
        """
        Gets the file_name of this WfmBuShortTermForecastCopyCompleteTopicForecastSourceDayPointer.


        :return: The file_name of this WfmBuShortTermForecastCopyCompleteTopicForecastSourceDayPointer.
        :rtype: str
        """
        return self._file_name

    @file_name.setter
    def file_name(self, file_name: str) -> None:
        """
        Sets the file_name of this WfmBuShortTermForecastCopyCompleteTopicForecastSourceDayPointer.


        :param file_name: The file_name of this WfmBuShortTermForecastCopyCompleteTopicForecastSourceDayPointer.
        :type: str
        """
        

        self._file_name = file_name

    @property
    def data_key(self) -> str:
        """
        Gets the data_key of this WfmBuShortTermForecastCopyCompleteTopicForecastSourceDayPointer.


        :return: The data_key of this WfmBuShortTermForecastCopyCompleteTopicForecastSourceDayPointer.
        :rtype: str
        """
        return self._data_key

    @data_key.setter
    def data_key(self, data_key: str) -> None:
        """
        Sets the data_key of this WfmBuShortTermForecastCopyCompleteTopicForecastSourceDayPointer.


        :param data_key: The data_key of this WfmBuShortTermForecastCopyCompleteTopicForecastSourceDayPointer.
        :type: str
        """
        

        self._data_key = data_key

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

