# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import TimeOffLimitReference
    from . import TimeOffRequestReference

class WaitlistPosition(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        WaitlistPosition - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'time_off_request': 'TimeOffRequestReference',
            'time_off_limit': 'TimeOffLimitReference',
            'date': 'date',
            'waitlist_position': 'int'
        }

        self.attribute_map = {
            'time_off_request': 'timeOffRequest',
            'time_off_limit': 'timeOffLimit',
            'date': 'date',
            'waitlist_position': 'waitlistPosition'
        }

        self._time_off_request = None
        self._time_off_limit = None
        self._date = None
        self._waitlist_position = None

    @property
    def time_off_request(self) -> 'TimeOffRequestReference':
        """
        Gets the time_off_request of this WaitlistPosition.
        The time off request for this wait list position

        :return: The time_off_request of this WaitlistPosition.
        :rtype: TimeOffRequestReference
        """
        return self._time_off_request

    @time_off_request.setter
    def time_off_request(self, time_off_request: 'TimeOffRequestReference') -> None:
        """
        Sets the time_off_request of this WaitlistPosition.
        The time off request for this wait list position

        :param time_off_request: The time_off_request of this WaitlistPosition.
        :type: TimeOffRequestReference
        """
        

        self._time_off_request = time_off_request

    @property
    def time_off_limit(self) -> 'TimeOffLimitReference':
        """
        Gets the time_off_limit of this WaitlistPosition.
        The time off limit for which time off request is waitlisted

        :return: The time_off_limit of this WaitlistPosition.
        :rtype: TimeOffLimitReference
        """
        return self._time_off_limit

    @time_off_limit.setter
    def time_off_limit(self, time_off_limit: 'TimeOffLimitReference') -> None:
        """
        Sets the time_off_limit of this WaitlistPosition.
        The time off limit for which time off request is waitlisted

        :param time_off_limit: The time_off_limit of this WaitlistPosition.
        :type: TimeOffLimitReference
        """
        

        self._time_off_limit = time_off_limit

    @property
    def date(self) -> date:
        """
        Gets the date of this WaitlistPosition.
        The date to which this wait list position applies, as defined by the time zone of the business unit. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date of this WaitlistPosition.
        :rtype: date
        """
        return self._date

    @date.setter
    def date(self, date: date) -> None:
        """
        Sets the date of this WaitlistPosition.
        The date to which this wait list position applies, as defined by the time zone of the business unit. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date: The date of this WaitlistPosition.
        :type: date
        """
        

        self._date = date

    @property
    def waitlist_position(self) -> int:
        """
        Gets the waitlist_position of this WaitlistPosition.
        The time off request's position in the waitlist on the date. 1 means time off is the first in the waitlist

        :return: The waitlist_position of this WaitlistPosition.
        :rtype: int
        """
        return self._waitlist_position

    @waitlist_position.setter
    def waitlist_position(self, waitlist_position: int) -> None:
        """
        Sets the waitlist_position of this WaitlistPosition.
        The time off request's position in the waitlist on the date. 1 means time off is the first in the waitlist

        :param waitlist_position: The waitlist_position of this WaitlistPosition.
        :type: int
        """
        

        self._waitlist_position = waitlist_position

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

