# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import V2MobiusAlertsTopicEntityProperties

class V2MobiusAlertsTopicConditionRulePredicate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        V2MobiusAlertsTopicConditionRulePredicate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'entity': 'V2MobiusAlertsTopicEntityProperties',
            'metric': 'str',
            'metric_type': 'str',
            'metric_value_type': 'str',
            'value': 'float',
            'comparison_operator': 'str'
        }

        self.attribute_map = {
            'entity': 'entity',
            'metric': 'metric',
            'metric_type': 'metricType',
            'metric_value_type': 'metricValueType',
            'value': 'value',
            'comparison_operator': 'comparisonOperator'
        }

        self._entity = None
        self._metric = None
        self._metric_type = None
        self._metric_value_type = None
        self._value = None
        self._comparison_operator = None

    @property
    def entity(self) -> 'V2MobiusAlertsTopicEntityProperties':
        """
        Gets the entity of this V2MobiusAlertsTopicConditionRulePredicate.


        :return: The entity of this V2MobiusAlertsTopicConditionRulePredicate.
        :rtype: V2MobiusAlertsTopicEntityProperties
        """
        return self._entity

    @entity.setter
    def entity(self, entity: 'V2MobiusAlertsTopicEntityProperties') -> None:
        """
        Sets the entity of this V2MobiusAlertsTopicConditionRulePredicate.


        :param entity: The entity of this V2MobiusAlertsTopicConditionRulePredicate.
        :type: V2MobiusAlertsTopicEntityProperties
        """
        

        self._entity = entity

    @property
    def metric(self) -> str:
        """
        Gets the metric of this V2MobiusAlertsTopicConditionRulePredicate.


        :return: The metric of this V2MobiusAlertsTopicConditionRulePredicate.
        :rtype: str
        """
        return self._metric

    @metric.setter
    def metric(self, metric: str) -> None:
        """
        Sets the metric of this V2MobiusAlertsTopicConditionRulePredicate.


        :param metric: The metric of this V2MobiusAlertsTopicConditionRulePredicate.
        :type: str
        """
        

        self._metric = metric

    @property
    def metric_type(self) -> str:
        """
        Gets the metric_type of this V2MobiusAlertsTopicConditionRulePredicate.


        :return: The metric_type of this V2MobiusAlertsTopicConditionRulePredicate.
        :rtype: str
        """
        return self._metric_type

    @metric_type.setter
    def metric_type(self, metric_type: str) -> None:
        """
        Sets the metric_type of this V2MobiusAlertsTopicConditionRulePredicate.


        :param metric_type: The metric_type of this V2MobiusAlertsTopicConditionRulePredicate.
        :type: str
        """
        allowed_values = ["Interval", "Instance", "Unknown"]
        if metric_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for metric_type -> " + metric_type)
            self._metric_type = "outdated_sdk_version"
        else:
            self._metric_type = metric_type

    @property
    def metric_value_type(self) -> str:
        """
        Gets the metric_value_type of this V2MobiusAlertsTopicConditionRulePredicate.


        :return: The metric_value_type of this V2MobiusAlertsTopicConditionRulePredicate.
        :rtype: str
        """
        return self._metric_value_type

    @metric_value_type.setter
    def metric_value_type(self, metric_value_type: str) -> None:
        """
        Sets the metric_value_type of this V2MobiusAlertsTopicConditionRulePredicate.


        :param metric_value_type: The metric_value_type of this V2MobiusAlertsTopicConditionRulePredicate.
        :type: str
        """
        allowed_values = ["Count", "Percentage", "Average", "Timer", "Observation", "Min", "Max", "Unknown"]
        if metric_value_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for metric_value_type -> " + metric_value_type)
            self._metric_value_type = "outdated_sdk_version"
        else:
            self._metric_value_type = metric_value_type

    @property
    def value(self) -> float:
        """
        Gets the value of this V2MobiusAlertsTopicConditionRulePredicate.


        :return: The value of this V2MobiusAlertsTopicConditionRulePredicate.
        :rtype: float
        """
        return self._value

    @value.setter
    def value(self, value: float) -> None:
        """
        Sets the value of this V2MobiusAlertsTopicConditionRulePredicate.


        :param value: The value of this V2MobiusAlertsTopicConditionRulePredicate.
        :type: float
        """
        

        self._value = value

    @property
    def comparison_operator(self) -> str:
        """
        Gets the comparison_operator of this V2MobiusAlertsTopicConditionRulePredicate.


        :return: The comparison_operator of this V2MobiusAlertsTopicConditionRulePredicate.
        :rtype: str
        """
        return self._comparison_operator

    @comparison_operator.setter
    def comparison_operator(self, comparison_operator: str) -> None:
        """
        Sets the comparison_operator of this V2MobiusAlertsTopicConditionRulePredicate.


        :param comparison_operator: The comparison_operator of this V2MobiusAlertsTopicConditionRulePredicate.
        :type: str
        """
        allowed_values = ["Gt", "Gte", "Lt", "Lte", "Eq", "Ne", "Unknown"]
        if comparison_operator.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for comparison_operator -> " + comparison_operator)
            self._comparison_operator = "outdated_sdk_version"
        else:
            self._comparison_operator = comparison_operator

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

