# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import V2MobiusAlertsTopicAlertNotification
    from . import V2MobiusAlertsTopicAlertRuleProperties
    from . import V2MobiusAlertsTopicCondition

class V2MobiusAlertsTopicAlert(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        V2MobiusAlertsTopicAlert - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'rule': 'V2MobiusAlertsTopicAlertRuleProperties',
            'id': 'str',
            'user_id': 'str',
            'notifications': 'list[V2MobiusAlertsTopicAlertNotification]',
            'date_start': 'datetime',
            'date_end': 'datetime',
            'conditions': 'V2MobiusAlertsTopicCondition',
            'additional_properties': 'dict(str, str)',
            'active': 'bool',
            'unread': 'bool',
            'muted': 'bool',
            'snoozed': 'bool',
            'date_muted_until': 'datetime',
            'date_snoozed_until': 'datetime',
            'action': 'str'
        }

        self.attribute_map = {
            'rule': 'rule',
            'id': 'id',
            'user_id': 'userId',
            'notifications': 'notifications',
            'date_start': 'dateStart',
            'date_end': 'dateEnd',
            'conditions': 'conditions',
            'additional_properties': 'additionalProperties',
            'active': 'active',
            'unread': 'unread',
            'muted': 'muted',
            'snoozed': 'snoozed',
            'date_muted_until': 'dateMutedUntil',
            'date_snoozed_until': 'dateSnoozedUntil',
            'action': 'action'
        }

        self._rule = None
        self._id = None
        self._user_id = None
        self._notifications = None
        self._date_start = None
        self._date_end = None
        self._conditions = None
        self._additional_properties = None
        self._active = None
        self._unread = None
        self._muted = None
        self._snoozed = None
        self._date_muted_until = None
        self._date_snoozed_until = None
        self._action = None

    @property
    def rule(self) -> 'V2MobiusAlertsTopicAlertRuleProperties':
        """
        Gets the rule of this V2MobiusAlertsTopicAlert.


        :return: The rule of this V2MobiusAlertsTopicAlert.
        :rtype: V2MobiusAlertsTopicAlertRuleProperties
        """
        return self._rule

    @rule.setter
    def rule(self, rule: 'V2MobiusAlertsTopicAlertRuleProperties') -> None:
        """
        Sets the rule of this V2MobiusAlertsTopicAlert.


        :param rule: The rule of this V2MobiusAlertsTopicAlert.
        :type: V2MobiusAlertsTopicAlertRuleProperties
        """
        

        self._rule = rule

    @property
    def id(self) -> str:
        """
        Gets the id of this V2MobiusAlertsTopicAlert.


        :return: The id of this V2MobiusAlertsTopicAlert.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this V2MobiusAlertsTopicAlert.


        :param id: The id of this V2MobiusAlertsTopicAlert.
        :type: str
        """
        

        self._id = id

    @property
    def user_id(self) -> str:
        """
        Gets the user_id of this V2MobiusAlertsTopicAlert.


        :return: The user_id of this V2MobiusAlertsTopicAlert.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id: str) -> None:
        """
        Sets the user_id of this V2MobiusAlertsTopicAlert.


        :param user_id: The user_id of this V2MobiusAlertsTopicAlert.
        :type: str
        """
        

        self._user_id = user_id

    @property
    def notifications(self) -> List['V2MobiusAlertsTopicAlertNotification']:
        """
        Gets the notifications of this V2MobiusAlertsTopicAlert.


        :return: The notifications of this V2MobiusAlertsTopicAlert.
        :rtype: list[V2MobiusAlertsTopicAlertNotification]
        """
        return self._notifications

    @notifications.setter
    def notifications(self, notifications: List['V2MobiusAlertsTopicAlertNotification']) -> None:
        """
        Sets the notifications of this V2MobiusAlertsTopicAlert.


        :param notifications: The notifications of this V2MobiusAlertsTopicAlert.
        :type: list[V2MobiusAlertsTopicAlertNotification]
        """
        

        self._notifications = notifications

    @property
    def date_start(self) -> datetime:
        """
        Gets the date_start of this V2MobiusAlertsTopicAlert.


        :return: The date_start of this V2MobiusAlertsTopicAlert.
        :rtype: datetime
        """
        return self._date_start

    @date_start.setter
    def date_start(self, date_start: datetime) -> None:
        """
        Sets the date_start of this V2MobiusAlertsTopicAlert.


        :param date_start: The date_start of this V2MobiusAlertsTopicAlert.
        :type: datetime
        """
        

        self._date_start = date_start

    @property
    def date_end(self) -> datetime:
        """
        Gets the date_end of this V2MobiusAlertsTopicAlert.


        :return: The date_end of this V2MobiusAlertsTopicAlert.
        :rtype: datetime
        """
        return self._date_end

    @date_end.setter
    def date_end(self, date_end: datetime) -> None:
        """
        Sets the date_end of this V2MobiusAlertsTopicAlert.


        :param date_end: The date_end of this V2MobiusAlertsTopicAlert.
        :type: datetime
        """
        

        self._date_end = date_end

    @property
    def conditions(self) -> 'V2MobiusAlertsTopicCondition':
        """
        Gets the conditions of this V2MobiusAlertsTopicAlert.


        :return: The conditions of this V2MobiusAlertsTopicAlert.
        :rtype: V2MobiusAlertsTopicCondition
        """
        return self._conditions

    @conditions.setter
    def conditions(self, conditions: 'V2MobiusAlertsTopicCondition') -> None:
        """
        Sets the conditions of this V2MobiusAlertsTopicAlert.


        :param conditions: The conditions of this V2MobiusAlertsTopicAlert.
        :type: V2MobiusAlertsTopicCondition
        """
        

        self._conditions = conditions

    @property
    def additional_properties(self) -> Dict[str, str]:
        """
        Gets the additional_properties of this V2MobiusAlertsTopicAlert.


        :return: The additional_properties of this V2MobiusAlertsTopicAlert.
        :rtype: dict(str, str)
        """
        return self._additional_properties

    @additional_properties.setter
    def additional_properties(self, additional_properties: Dict[str, str]) -> None:
        """
        Sets the additional_properties of this V2MobiusAlertsTopicAlert.


        :param additional_properties: The additional_properties of this V2MobiusAlertsTopicAlert.
        :type: dict(str, str)
        """
        

        self._additional_properties = additional_properties

    @property
    def active(self) -> bool:
        """
        Gets the active of this V2MobiusAlertsTopicAlert.


        :return: The active of this V2MobiusAlertsTopicAlert.
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active: bool) -> None:
        """
        Sets the active of this V2MobiusAlertsTopicAlert.


        :param active: The active of this V2MobiusAlertsTopicAlert.
        :type: bool
        """
        

        self._active = active

    @property
    def unread(self) -> bool:
        """
        Gets the unread of this V2MobiusAlertsTopicAlert.


        :return: The unread of this V2MobiusAlertsTopicAlert.
        :rtype: bool
        """
        return self._unread

    @unread.setter
    def unread(self, unread: bool) -> None:
        """
        Sets the unread of this V2MobiusAlertsTopicAlert.


        :param unread: The unread of this V2MobiusAlertsTopicAlert.
        :type: bool
        """
        

        self._unread = unread

    @property
    def muted(self) -> bool:
        """
        Gets the muted of this V2MobiusAlertsTopicAlert.


        :return: The muted of this V2MobiusAlertsTopicAlert.
        :rtype: bool
        """
        return self._muted

    @muted.setter
    def muted(self, muted: bool) -> None:
        """
        Sets the muted of this V2MobiusAlertsTopicAlert.


        :param muted: The muted of this V2MobiusAlertsTopicAlert.
        :type: bool
        """
        

        self._muted = muted

    @property
    def snoozed(self) -> bool:
        """
        Gets the snoozed of this V2MobiusAlertsTopicAlert.


        :return: The snoozed of this V2MobiusAlertsTopicAlert.
        :rtype: bool
        """
        return self._snoozed

    @snoozed.setter
    def snoozed(self, snoozed: bool) -> None:
        """
        Sets the snoozed of this V2MobiusAlertsTopicAlert.


        :param snoozed: The snoozed of this V2MobiusAlertsTopicAlert.
        :type: bool
        """
        

        self._snoozed = snoozed

    @property
    def date_muted_until(self) -> datetime:
        """
        Gets the date_muted_until of this V2MobiusAlertsTopicAlert.


        :return: The date_muted_until of this V2MobiusAlertsTopicAlert.
        :rtype: datetime
        """
        return self._date_muted_until

    @date_muted_until.setter
    def date_muted_until(self, date_muted_until: datetime) -> None:
        """
        Sets the date_muted_until of this V2MobiusAlertsTopicAlert.


        :param date_muted_until: The date_muted_until of this V2MobiusAlertsTopicAlert.
        :type: datetime
        """
        

        self._date_muted_until = date_muted_until

    @property
    def date_snoozed_until(self) -> datetime:
        """
        Gets the date_snoozed_until of this V2MobiusAlertsTopicAlert.


        :return: The date_snoozed_until of this V2MobiusAlertsTopicAlert.
        :rtype: datetime
        """
        return self._date_snoozed_until

    @date_snoozed_until.setter
    def date_snoozed_until(self, date_snoozed_until: datetime) -> None:
        """
        Sets the date_snoozed_until of this V2MobiusAlertsTopicAlert.


        :param date_snoozed_until: The date_snoozed_until of this V2MobiusAlertsTopicAlert.
        :type: datetime
        """
        

        self._date_snoozed_until = date_snoozed_until

    @property
    def action(self) -> str:
        """
        Gets the action of this V2MobiusAlertsTopicAlert.


        :return: The action of this V2MobiusAlertsTopicAlert.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action: str) -> None:
        """
        Sets the action of this V2MobiusAlertsTopicAlert.


        :param action: The action of this V2MobiusAlertsTopicAlert.
        :type: str
        """
        allowed_values = ["UNKNOWN", "CREATE", "UPDATE", "DELETE", "CLOSE"]
        if action.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for action -> " + action)
            self._action = "outdated_sdk_version"
        else:
            self._action = action

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

