# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import V2ConversationMessageTypingEventForWorkflowTopicConversationContentAttachment
    from . import V2ConversationMessageTypingEventForWorkflowTopicConversationContentButtonResponse
    from . import V2ConversationMessageTypingEventForWorkflowTopicConversationContentGeneric
    from . import V2ConversationMessageTypingEventForWorkflowTopicConversationContentLocation
    from . import V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate
    from . import V2ConversationMessageTypingEventForWorkflowTopicConversationContentQuickReply
    from . import V2ConversationMessageTypingEventForWorkflowTopicConversationContentStory

class V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'content_type': 'str',
            'location': 'V2ConversationMessageTypingEventForWorkflowTopicConversationContentLocation',
            'story': 'V2ConversationMessageTypingEventForWorkflowTopicConversationContentStory',
            'attachment': 'V2ConversationMessageTypingEventForWorkflowTopicConversationContentAttachment',
            'quick_reply': 'V2ConversationMessageTypingEventForWorkflowTopicConversationContentQuickReply',
            'template': 'V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate',
            'button_response': 'V2ConversationMessageTypingEventForWorkflowTopicConversationContentButtonResponse',
            'generic': 'V2ConversationMessageTypingEventForWorkflowTopicConversationContentGeneric'
        }

        self.attribute_map = {
            'content_type': 'contentType',
            'location': 'location',
            'story': 'story',
            'attachment': 'attachment',
            'quick_reply': 'quickReply',
            'template': 'template',
            'button_response': 'buttonResponse',
            'generic': 'generic'
        }

        self._content_type = None
        self._location = None
        self._story = None
        self._attachment = None
        self._quick_reply = None
        self._template = None
        self._button_response = None
        self._generic = None

    @property
    def content_type(self) -> str:
        """
        Gets the content_type of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.


        :return: The content_type of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.
        :rtype: str
        """
        return self._content_type

    @content_type.setter
    def content_type(self, content_type: str) -> None:
        """
        Sets the content_type of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.


        :param content_type: The content_type of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.
        :type: str
        """
        allowed_values = ["Attachment", "Location", "Story", "QuickReply", "Notification", "ButtonResponse", "GenericTemplate"]
        if content_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for content_type -> " + content_type)
            self._content_type = "outdated_sdk_version"
        else:
            self._content_type = content_type

    @property
    def location(self) -> 'V2ConversationMessageTypingEventForWorkflowTopicConversationContentLocation':
        """
        Gets the location of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.


        :return: The location of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.
        :rtype: V2ConversationMessageTypingEventForWorkflowTopicConversationContentLocation
        """
        return self._location

    @location.setter
    def location(self, location: 'V2ConversationMessageTypingEventForWorkflowTopicConversationContentLocation') -> None:
        """
        Sets the location of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.


        :param location: The location of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.
        :type: V2ConversationMessageTypingEventForWorkflowTopicConversationContentLocation
        """
        

        self._location = location

    @property
    def story(self) -> 'V2ConversationMessageTypingEventForWorkflowTopicConversationContentStory':
        """
        Gets the story of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.


        :return: The story of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.
        :rtype: V2ConversationMessageTypingEventForWorkflowTopicConversationContentStory
        """
        return self._story

    @story.setter
    def story(self, story: 'V2ConversationMessageTypingEventForWorkflowTopicConversationContentStory') -> None:
        """
        Sets the story of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.


        :param story: The story of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.
        :type: V2ConversationMessageTypingEventForWorkflowTopicConversationContentStory
        """
        

        self._story = story

    @property
    def attachment(self) -> 'V2ConversationMessageTypingEventForWorkflowTopicConversationContentAttachment':
        """
        Gets the attachment of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.


        :return: The attachment of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.
        :rtype: V2ConversationMessageTypingEventForWorkflowTopicConversationContentAttachment
        """
        return self._attachment

    @attachment.setter
    def attachment(self, attachment: 'V2ConversationMessageTypingEventForWorkflowTopicConversationContentAttachment') -> None:
        """
        Sets the attachment of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.


        :param attachment: The attachment of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.
        :type: V2ConversationMessageTypingEventForWorkflowTopicConversationContentAttachment
        """
        

        self._attachment = attachment

    @property
    def quick_reply(self) -> 'V2ConversationMessageTypingEventForWorkflowTopicConversationContentQuickReply':
        """
        Gets the quick_reply of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.


        :return: The quick_reply of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.
        :rtype: V2ConversationMessageTypingEventForWorkflowTopicConversationContentQuickReply
        """
        return self._quick_reply

    @quick_reply.setter
    def quick_reply(self, quick_reply: 'V2ConversationMessageTypingEventForWorkflowTopicConversationContentQuickReply') -> None:
        """
        Sets the quick_reply of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.


        :param quick_reply: The quick_reply of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.
        :type: V2ConversationMessageTypingEventForWorkflowTopicConversationContentQuickReply
        """
        

        self._quick_reply = quick_reply

    @property
    def template(self) -> 'V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate':
        """
        Gets the template of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.


        :return: The template of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.
        :rtype: V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate
        """
        return self._template

    @template.setter
    def template(self, template: 'V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate') -> None:
        """
        Sets the template of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.


        :param template: The template of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.
        :type: V2ConversationMessageTypingEventForWorkflowTopicConversationContentNotificationTemplate
        """
        

        self._template = template

    @property
    def button_response(self) -> 'V2ConversationMessageTypingEventForWorkflowTopicConversationContentButtonResponse':
        """
        Gets the button_response of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.


        :return: The button_response of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.
        :rtype: V2ConversationMessageTypingEventForWorkflowTopicConversationContentButtonResponse
        """
        return self._button_response

    @button_response.setter
    def button_response(self, button_response: 'V2ConversationMessageTypingEventForWorkflowTopicConversationContentButtonResponse') -> None:
        """
        Sets the button_response of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.


        :param button_response: The button_response of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.
        :type: V2ConversationMessageTypingEventForWorkflowTopicConversationContentButtonResponse
        """
        

        self._button_response = button_response

    @property
    def generic(self) -> 'V2ConversationMessageTypingEventForWorkflowTopicConversationContentGeneric':
        """
        Gets the generic of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.


        :return: The generic of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.
        :rtype: V2ConversationMessageTypingEventForWorkflowTopicConversationContentGeneric
        """
        return self._generic

    @generic.setter
    def generic(self, generic: 'V2ConversationMessageTypingEventForWorkflowTopicConversationContentGeneric') -> None:
        """
        Sets the generic of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.


        :param generic: The generic of this V2ConversationMessageTypingEventForWorkflowTopicConversationMessageContent.
        :type: V2ConversationMessageTypingEventForWorkflowTopicConversationContentGeneric
        """
        

        self._generic = generic

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

