# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import V2ConversationMessageTypingEventForUserTopicConversationMessageContent
    from . import V2ConversationMessageTypingEventForUserTopicConversationMessageEvent
    from . import V2ConversationMessageTypingEventForUserTopicConversationMessagingChannel
    from . import V2ConversationMessageTypingEventForUserTopicConversationReason

class V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'channel': 'V2ConversationMessageTypingEventForUserTopicConversationMessagingChannel',
            'type': 'str',
            'text': 'str',
            'content': 'list[V2ConversationMessageTypingEventForUserTopicConversationMessageContent]',
            'events': 'list[V2ConversationMessageTypingEventForUserTopicConversationMessageEvent]',
            'status': 'str',
            'reasons': 'list[V2ConversationMessageTypingEventForUserTopicConversationReason]',
            'originating_entity': 'str',
            'is_final_receipt': 'bool',
            'direction': 'str',
            'metadata': 'dict(str, str)'
        }

        self.attribute_map = {
            'id': 'id',
            'channel': 'channel',
            'type': 'type',
            'text': 'text',
            'content': 'content',
            'events': 'events',
            'status': 'status',
            'reasons': 'reasons',
            'originating_entity': 'originatingEntity',
            'is_final_receipt': 'isFinalReceipt',
            'direction': 'direction',
            'metadata': 'metadata'
        }

        self._id = None
        self._channel = None
        self._type = None
        self._text = None
        self._content = None
        self._events = None
        self._status = None
        self._reasons = None
        self._originating_entity = None
        self._is_final_receipt = None
        self._direction = None
        self._metadata = None

    @property
    def id(self) -> str:
        """
        Gets the id of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.


        :return: The id of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.


        :param id: The id of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.
        :type: str
        """
        

        self._id = id

    @property
    def channel(self) -> 'V2ConversationMessageTypingEventForUserTopicConversationMessagingChannel':
        """
        Gets the channel of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.


        :return: The channel of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.
        :rtype: V2ConversationMessageTypingEventForUserTopicConversationMessagingChannel
        """
        return self._channel

    @channel.setter
    def channel(self, channel: 'V2ConversationMessageTypingEventForUserTopicConversationMessagingChannel') -> None:
        """
        Sets the channel of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.


        :param channel: The channel of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.
        :type: V2ConversationMessageTypingEventForUserTopicConversationMessagingChannel
        """
        

        self._channel = channel

    @property
    def type(self) -> str:
        """
        Gets the type of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.


        :return: The type of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.


        :param type: The type of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.
        :type: str
        """
        allowed_values = ["Text", "Structured", "Receipt", "Event"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def text(self) -> str:
        """
        Gets the text of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.


        :return: The text of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text: str) -> None:
        """
        Sets the text of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.


        :param text: The text of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.
        :type: str
        """
        

        self._text = text

    @property
    def content(self) -> List['V2ConversationMessageTypingEventForUserTopicConversationMessageContent']:
        """
        Gets the content of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.


        :return: The content of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.
        :rtype: list[V2ConversationMessageTypingEventForUserTopicConversationMessageContent]
        """
        return self._content

    @content.setter
    def content(self, content: List['V2ConversationMessageTypingEventForUserTopicConversationMessageContent']) -> None:
        """
        Sets the content of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.


        :param content: The content of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.
        :type: list[V2ConversationMessageTypingEventForUserTopicConversationMessageContent]
        """
        

        self._content = content

    @property
    def events(self) -> List['V2ConversationMessageTypingEventForUserTopicConversationMessageEvent']:
        """
        Gets the events of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.


        :return: The events of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.
        :rtype: list[V2ConversationMessageTypingEventForUserTopicConversationMessageEvent]
        """
        return self._events

    @events.setter
    def events(self, events: List['V2ConversationMessageTypingEventForUserTopicConversationMessageEvent']) -> None:
        """
        Sets the events of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.


        :param events: The events of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.
        :type: list[V2ConversationMessageTypingEventForUserTopicConversationMessageEvent]
        """
        

        self._events = events

    @property
    def status(self) -> str:
        """
        Gets the status of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.


        :return: The status of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.


        :param status: The status of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.
        :type: str
        """
        allowed_values = ["Sent", "Delivered", "Read", "Failed", "Published", "Removed"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def reasons(self) -> List['V2ConversationMessageTypingEventForUserTopicConversationReason']:
        """
        Gets the reasons of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.


        :return: The reasons of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.
        :rtype: list[V2ConversationMessageTypingEventForUserTopicConversationReason]
        """
        return self._reasons

    @reasons.setter
    def reasons(self, reasons: List['V2ConversationMessageTypingEventForUserTopicConversationReason']) -> None:
        """
        Sets the reasons of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.


        :param reasons: The reasons of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.
        :type: list[V2ConversationMessageTypingEventForUserTopicConversationReason]
        """
        

        self._reasons = reasons

    @property
    def originating_entity(self) -> str:
        """
        Gets the originating_entity of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.


        :return: The originating_entity of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.
        :rtype: str
        """
        return self._originating_entity

    @originating_entity.setter
    def originating_entity(self, originating_entity: str) -> None:
        """
        Sets the originating_entity of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.


        :param originating_entity: The originating_entity of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.
        :type: str
        """
        allowed_values = ["Human", "Bot"]
        if originating_entity.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for originating_entity -> " + originating_entity)
            self._originating_entity = "outdated_sdk_version"
        else:
            self._originating_entity = originating_entity

    @property
    def is_final_receipt(self) -> bool:
        """
        Gets the is_final_receipt of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.


        :return: The is_final_receipt of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.
        :rtype: bool
        """
        return self._is_final_receipt

    @is_final_receipt.setter
    def is_final_receipt(self, is_final_receipt: bool) -> None:
        """
        Sets the is_final_receipt of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.


        :param is_final_receipt: The is_final_receipt of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.
        :type: bool
        """
        

        self._is_final_receipt = is_final_receipt

    @property
    def direction(self) -> str:
        """
        Gets the direction of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.


        :return: The direction of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.
        :rtype: str
        """
        return self._direction

    @direction.setter
    def direction(self, direction: str) -> None:
        """
        Sets the direction of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.


        :param direction: The direction of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.
        :type: str
        """
        allowed_values = ["Inbound", "Outbound"]
        if direction.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for direction -> " + direction)
            self._direction = "outdated_sdk_version"
        else:
            self._direction = direction

    @property
    def metadata(self) -> Dict[str, str]:
        """
        Gets the metadata of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.


        :return: The metadata of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.
        :rtype: dict(str, str)
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata: Dict[str, str]) -> None:
        """
        Sets the metadata of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.


        :param metadata: The metadata of this V2ConversationMessageTypingEventForUserTopicConversationNormalizedMessage.
        :type: dict(str, str)
        """
        

        self._metadata = metadata

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

