# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class UserRoutingStatusEvent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        UserRoutingStatusEvent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'event_id': 'str',
            'event_date_time': 'datetime',
            'agent_id': 'str',
            'status': 'str',
            'source_id': 'str'
        }

        self.attribute_map = {
            'event_id': 'eventId',
            'event_date_time': 'eventDateTime',
            'agent_id': 'agentId',
            'status': 'status',
            'source_id': 'sourceId'
        }

        self._event_id = None
        self._event_date_time = None
        self._agent_id = None
        self._status = None
        self._source_id = None

    @property
    def event_id(self) -> str:
        """
        Gets the event_id of this UserRoutingStatusEvent.
        A unique (UUID) eventId for this event

        :return: The event_id of this UserRoutingStatusEvent.
        :rtype: str
        """
        return self._event_id

    @event_id.setter
    def event_id(self, event_id: str) -> None:
        """
        Sets the event_id of this UserRoutingStatusEvent.
        A unique (UUID) eventId for this event

        :param event_id: The event_id of this UserRoutingStatusEvent.
        :type: str
        """
        

        self._event_id = event_id

    @property
    def event_date_time(self) -> datetime:
        """
        Gets the event_date_time of this UserRoutingStatusEvent.
        A timestamp as epoch representing the time this event occurred. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The event_date_time of this UserRoutingStatusEvent.
        :rtype: datetime
        """
        return self._event_date_time

    @event_date_time.setter
    def event_date_time(self, event_date_time: datetime) -> None:
        """
        Sets the event_date_time of this UserRoutingStatusEvent.
        A timestamp as epoch representing the time this event occurred. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param event_date_time: The event_date_time of this UserRoutingStatusEvent.
        :type: datetime
        """
        

        self._event_date_time = event_date_time

    @property
    def agent_id(self) -> str:
        """
        Gets the agent_id of this UserRoutingStatusEvent.
        Unique identifier of the agent.

        :return: The agent_id of this UserRoutingStatusEvent.
        :rtype: str
        """
        return self._agent_id

    @agent_id.setter
    def agent_id(self, agent_id: str) -> None:
        """
        Sets the agent_id of this UserRoutingStatusEvent.
        Unique identifier of the agent.

        :param agent_id: The agent_id of this UserRoutingStatusEvent.
        :type: str
        """
        

        self._agent_id = agent_id

    @property
    def status(self) -> str:
        """
        Gets the status of this UserRoutingStatusEvent.
        The agent's current routing status.

        :return: The status of this UserRoutingStatusEvent.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this UserRoutingStatusEvent.
        The agent's current routing status.

        :param status: The status of this UserRoutingStatusEvent.
        :type: str
        """
        allowed_values = ["OffQueue", "Idle", "Interacting", "Communicating", "NotResponding"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def source_id(self) -> str:
        """
        Gets the source_id of this UserRoutingStatusEvent.
        The agent's source platform Id.

        :return: The source_id of this UserRoutingStatusEvent.
        :rtype: str
        """
        return self._source_id

    @source_id.setter
    def source_id(self, source_id: str) -> None:
        """
        Sets the source_id of this UserRoutingStatusEvent.
        The agent's source platform Id.

        :param source_id: The source_id of this UserRoutingStatusEvent.
        :type: str
        """
        

        self._source_id = source_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

