# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class UserRoutingSkill(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        UserRoutingSkill - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'proficiency': 'float',
            'state': 'str',
            'skill_uri': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'proficiency': 'proficiency',
            'state': 'state',
            'skill_uri': 'skillUri',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._proficiency = None
        self._state = None
        self._skill_uri = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this UserRoutingSkill.
        The globally unique identifier for the object.

        :return: The id of this UserRoutingSkill.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this UserRoutingSkill.
        The globally unique identifier for the object.

        :param id: The id of this UserRoutingSkill.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this UserRoutingSkill.


        :return: The name of this UserRoutingSkill.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this UserRoutingSkill.


        :param name: The name of this UserRoutingSkill.
        :type: str
        """
        

        self._name = name

    @property
    def proficiency(self) -> float:
        """
        Gets the proficiency of this UserRoutingSkill.
        A rating from 0.0 to 5.0 that indicates how adept an agent is at a particular skill. When \"Best available skills\" is enabled for a queue in Genesys Cloud, ACD interactions in that queue are routed to agents with higher proficiency ratings.

        :return: The proficiency of this UserRoutingSkill.
        :rtype: float
        """
        return self._proficiency

    @proficiency.setter
    def proficiency(self, proficiency: float) -> None:
        """
        Sets the proficiency of this UserRoutingSkill.
        A rating from 0.0 to 5.0 that indicates how adept an agent is at a particular skill. When \"Best available skills\" is enabled for a queue in Genesys Cloud, ACD interactions in that queue are routed to agents with higher proficiency ratings.

        :param proficiency: The proficiency of this UserRoutingSkill.
        :type: float
        """
        

        self._proficiency = proficiency

    @property
    def state(self) -> str:
        """
        Gets the state of this UserRoutingSkill.
        Activate or deactivate this routing skill.

        :return: The state of this UserRoutingSkill.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this UserRoutingSkill.
        Activate or deactivate this routing skill.

        :param state: The state of this UserRoutingSkill.
        :type: str
        """
        allowed_values = ["active", "inactive", "deleted"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def skill_uri(self) -> str:
        """
        Gets the skill_uri of this UserRoutingSkill.
        URI to the organization skill used by this user skill.

        :return: The skill_uri of this UserRoutingSkill.
        :rtype: str
        """
        return self._skill_uri

    @skill_uri.setter
    def skill_uri(self, skill_uri: str) -> None:
        """
        Sets the skill_uri of this UserRoutingSkill.
        URI to the organization skill used by this user skill.

        :param skill_uri: The skill_uri of this UserRoutingSkill.
        :type: str
        """
        

        self._skill_uri = skill_uri

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this UserRoutingSkill.
        The URI for this object

        :return: The self_uri of this UserRoutingSkill.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this UserRoutingSkill.
        The URI for this object

        :param self_uri: The self_uri of this UserRoutingSkill.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

