# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import GroupContact
    from . import OrgUser
    from . import User
    from . import UserImage

class TrustGroup(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        TrustGroup - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'date_modified': 'datetime',
            'member_count': 'int',
            'state': 'str',
            'version': 'int',
            'type': 'str',
            'images': 'list[UserImage]',
            'addresses': 'list[GroupContact]',
            'rules_visible': 'bool',
            'visibility': 'str',
            'owners': 'list[User]',
            'date_created': 'datetime',
            'created_by': 'OrgUser'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'date_modified': 'dateModified',
            'member_count': 'memberCount',
            'state': 'state',
            'version': 'version',
            'type': 'type',
            'images': 'images',
            'addresses': 'addresses',
            'rules_visible': 'rulesVisible',
            'visibility': 'visibility',
            'owners': 'owners',
            'date_created': 'dateCreated',
            'created_by': 'createdBy'
        }

        self._id = None
        self._name = None
        self._description = None
        self._date_modified = None
        self._member_count = None
        self._state = None
        self._version = None
        self._type = None
        self._images = None
        self._addresses = None
        self._rules_visible = None
        self._visibility = None
        self._owners = None
        self._date_created = None
        self._created_by = None

    @property
    def id(self) -> str:
        """
        Gets the id of this TrustGroup.
        The globally unique identifier for the object.

        :return: The id of this TrustGroup.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this TrustGroup.
        The globally unique identifier for the object.

        :param id: The id of this TrustGroup.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this TrustGroup.
        The group name.

        :return: The name of this TrustGroup.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this TrustGroup.
        The group name.

        :param name: The name of this TrustGroup.
        :type: str
        """
        

        self._name = name

    @property
    def description(self) -> str:
        """
        Gets the description of this TrustGroup.


        :return: The description of this TrustGroup.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this TrustGroup.


        :param description: The description of this TrustGroup.
        :type: str
        """
        

        self._description = description

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this TrustGroup.
        Last modified date/time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this TrustGroup.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this TrustGroup.
        Last modified date/time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this TrustGroup.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def member_count(self) -> int:
        """
        Gets the member_count of this TrustGroup.
        Number of members.

        :return: The member_count of this TrustGroup.
        :rtype: int
        """
        return self._member_count

    @member_count.setter
    def member_count(self, member_count: int) -> None:
        """
        Sets the member_count of this TrustGroup.
        Number of members.

        :param member_count: The member_count of this TrustGroup.
        :type: int
        """
        

        self._member_count = member_count

    @property
    def state(self) -> str:
        """
        Gets the state of this TrustGroup.
        Active, inactive, or deleted state.

        :return: The state of this TrustGroup.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this TrustGroup.
        Active, inactive, or deleted state.

        :param state: The state of this TrustGroup.
        :type: str
        """
        allowed_values = ["active", "inactive", "deleted"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def version(self) -> int:
        """
        Gets the version of this TrustGroup.
        Current version for this resource.

        :return: The version of this TrustGroup.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version: int) -> None:
        """
        Sets the version of this TrustGroup.
        Current version for this resource.

        :param version: The version of this TrustGroup.
        :type: int
        """
        

        self._version = version

    @property
    def type(self) -> str:
        """
        Gets the type of this TrustGroup.
        Type of group.

        :return: The type of this TrustGroup.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this TrustGroup.
        Type of group.

        :param type: The type of this TrustGroup.
        :type: str
        """
        allowed_values = ["official", "social"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def images(self) -> List['UserImage']:
        """
        Gets the images of this TrustGroup.


        :return: The images of this TrustGroup.
        :rtype: list[UserImage]
        """
        return self._images

    @images.setter
    def images(self, images: List['UserImage']) -> None:
        """
        Sets the images of this TrustGroup.


        :param images: The images of this TrustGroup.
        :type: list[UserImage]
        """
        

        self._images = images

    @property
    def addresses(self) -> List['GroupContact']:
        """
        Gets the addresses of this TrustGroup.


        :return: The addresses of this TrustGroup.
        :rtype: list[GroupContact]
        """
        return self._addresses

    @addresses.setter
    def addresses(self, addresses: List['GroupContact']) -> None:
        """
        Sets the addresses of this TrustGroup.


        :param addresses: The addresses of this TrustGroup.
        :type: list[GroupContact]
        """
        

        self._addresses = addresses

    @property
    def rules_visible(self) -> bool:
        """
        Gets the rules_visible of this TrustGroup.
        Are membership rules visible to the person requesting to view the group

        :return: The rules_visible of this TrustGroup.
        :rtype: bool
        """
        return self._rules_visible

    @rules_visible.setter
    def rules_visible(self, rules_visible: bool) -> None:
        """
        Sets the rules_visible of this TrustGroup.
        Are membership rules visible to the person requesting to view the group

        :param rules_visible: The rules_visible of this TrustGroup.
        :type: bool
        """
        

        self._rules_visible = rules_visible

    @property
    def visibility(self) -> str:
        """
        Gets the visibility of this TrustGroup.
        Who can view this group

        :return: The visibility of this TrustGroup.
        :rtype: str
        """
        return self._visibility

    @visibility.setter
    def visibility(self, visibility: str) -> None:
        """
        Sets the visibility of this TrustGroup.
        Who can view this group

        :param visibility: The visibility of this TrustGroup.
        :type: str
        """
        allowed_values = ["public", "owners", "members"]
        if visibility.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for visibility -> " + visibility)
            self._visibility = "outdated_sdk_version"
        else:
            self._visibility = visibility

    @property
    def owners(self) -> List['User']:
        """
        Gets the owners of this TrustGroup.
        Owners of the group

        :return: The owners of this TrustGroup.
        :rtype: list[User]
        """
        return self._owners

    @owners.setter
    def owners(self, owners: List['User']) -> None:
        """
        Sets the owners of this TrustGroup.
        Owners of the group

        :param owners: The owners of this TrustGroup.
        :type: list[User]
        """
        

        self._owners = owners

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this TrustGroup.
        The date on which the trusted group was added. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this TrustGroup.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this TrustGroup.
        The date on which the trusted group was added. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this TrustGroup.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def created_by(self) -> 'OrgUser':
        """
        Gets the created_by of this TrustGroup.
        The user that added trusted group.

        :return: The created_by of this TrustGroup.
        :rtype: OrgUser
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by: 'OrgUser') -> None:
        """
        Sets the created_by of this TrustGroup.
        The user that added trusted group.

        :param created_by: The created_by of this TrustGroup.
        :type: OrgUser
        """
        

        self._created_by = created_by

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

