# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import TextBotDisconnectAction
    from . import TextBotExitAction
    from . import TextBotOutputPrompts
    from . import TextBotTurnReference
    from . import TextBotWaitForInputAction

class TextBotFlowTurnResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        TextBotFlowTurnResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'previous_turn': 'TextBotTurnReference',
            'prompts': 'TextBotOutputPrompts',
            'next_action_type': 'str',
            'next_action_disconnect': 'TextBotDisconnectAction',
            'next_action_wait_for_input': 'TextBotWaitForInputAction',
            'next_action_exit': 'TextBotExitAction'
        }

        self.attribute_map = {
            'id': 'id',
            'previous_turn': 'previousTurn',
            'prompts': 'prompts',
            'next_action_type': 'nextActionType',
            'next_action_disconnect': 'nextActionDisconnect',
            'next_action_wait_for_input': 'nextActionWaitForInput',
            'next_action_exit': 'nextActionExit'
        }

        self._id = None
        self._previous_turn = None
        self._prompts = None
        self._next_action_type = None
        self._next_action_disconnect = None
        self._next_action_wait_for_input = None
        self._next_action_exit = None

    @property
    def id(self) -> str:
        """
        Gets the id of this TextBotFlowTurnResponse.
        The ID of the bot flow turn. If additional turns are needed, supply this ID as the previous turn in your next turn request.

        :return: The id of this TextBotFlowTurnResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this TextBotFlowTurnResponse.
        The ID of the bot flow turn. If additional turns are needed, supply this ID as the previous turn in your next turn request.

        :param id: The id of this TextBotFlowTurnResponse.
        :type: str
        """
        

        self._id = id

    @property
    def previous_turn(self) -> 'TextBotTurnReference':
        """
        Gets the previous_turn of this TextBotFlowTurnResponse.
        The reference to a previous turn, if applicable.

        :return: The previous_turn of this TextBotFlowTurnResponse.
        :rtype: TextBotTurnReference
        """
        return self._previous_turn

    @previous_turn.setter
    def previous_turn(self, previous_turn: 'TextBotTurnReference') -> None:
        """
        Sets the previous_turn of this TextBotFlowTurnResponse.
        The reference to a previous turn, if applicable.

        :param previous_turn: The previous_turn of this TextBotFlowTurnResponse.
        :type: TextBotTurnReference
        """
        

        self._previous_turn = previous_turn

    @property
    def prompts(self) -> 'TextBotOutputPrompts':
        """
        Gets the prompts of this TextBotFlowTurnResponse.
        The output prompts for this turn.

        :return: The prompts of this TextBotFlowTurnResponse.
        :rtype: TextBotOutputPrompts
        """
        return self._prompts

    @prompts.setter
    def prompts(self, prompts: 'TextBotOutputPrompts') -> None:
        """
        Sets the prompts of this TextBotFlowTurnResponse.
        The output prompts for this turn.

        :param prompts: The prompts of this TextBotFlowTurnResponse.
        :type: TextBotOutputPrompts
        """
        

        self._prompts = prompts

    @property
    def next_action_type(self) -> str:
        """
        Gets the next_action_type of this TextBotFlowTurnResponse.
        Indicates the suggested next action. If appropriate, the matching output event object includes additional information.

        :return: The next_action_type of this TextBotFlowTurnResponse.
        :rtype: str
        """
        return self._next_action_type

    @next_action_type.setter
    def next_action_type(self, next_action_type: str) -> None:
        """
        Sets the next_action_type of this TextBotFlowTurnResponse.
        Indicates the suggested next action. If appropriate, the matching output event object includes additional information.

        :param next_action_type: The next_action_type of this TextBotFlowTurnResponse.
        :type: str
        """
        allowed_values = ["NoOp", "Disconnect", "WaitForInput", "Exit"]
        if next_action_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for next_action_type -> " + next_action_type)
            self._next_action_type = "outdated_sdk_version"
        else:
            self._next_action_type = next_action_type

    @property
    def next_action_disconnect(self) -> 'TextBotDisconnectAction':
        """
        Gets the next_action_disconnect of this TextBotFlowTurnResponse.
        The next action directive for this turn if it is a Disconnect type.

        :return: The next_action_disconnect of this TextBotFlowTurnResponse.
        :rtype: TextBotDisconnectAction
        """
        return self._next_action_disconnect

    @next_action_disconnect.setter
    def next_action_disconnect(self, next_action_disconnect: 'TextBotDisconnectAction') -> None:
        """
        Sets the next_action_disconnect of this TextBotFlowTurnResponse.
        The next action directive for this turn if it is a Disconnect type.

        :param next_action_disconnect: The next_action_disconnect of this TextBotFlowTurnResponse.
        :type: TextBotDisconnectAction
        """
        

        self._next_action_disconnect = next_action_disconnect

    @property
    def next_action_wait_for_input(self) -> 'TextBotWaitForInputAction':
        """
        Gets the next_action_wait_for_input of this TextBotFlowTurnResponse.
        The next action directive for this turn if it is a WaitForInput type.

        :return: The next_action_wait_for_input of this TextBotFlowTurnResponse.
        :rtype: TextBotWaitForInputAction
        """
        return self._next_action_wait_for_input

    @next_action_wait_for_input.setter
    def next_action_wait_for_input(self, next_action_wait_for_input: 'TextBotWaitForInputAction') -> None:
        """
        Sets the next_action_wait_for_input of this TextBotFlowTurnResponse.
        The next action directive for this turn if it is a WaitForInput type.

        :param next_action_wait_for_input: The next_action_wait_for_input of this TextBotFlowTurnResponse.
        :type: TextBotWaitForInputAction
        """
        

        self._next_action_wait_for_input = next_action_wait_for_input

    @property
    def next_action_exit(self) -> 'TextBotExitAction':
        """
        Gets the next_action_exit of this TextBotFlowTurnResponse.
        The next action directive for this turn if it is an Exit type.

        :return: The next_action_exit of this TextBotFlowTurnResponse.
        :rtype: TextBotExitAction
        """
        return self._next_action_exit

    @next_action_exit.setter
    def next_action_exit(self, next_action_exit: 'TextBotExitAction') -> None:
        """
        Sets the next_action_exit of this TextBotFlowTurnResponse.
        The next action directive for this turn if it is an Exit type.

        :param next_action_exit: The next_action_exit of this TextBotFlowTurnResponse.
        :type: TextBotExitAction
        """
        

        self._next_action_exit = next_action_exit

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

