# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import TextBotErrorInputEvent
    from . import TextBotTurnReference
    from . import TextBotUserInputEvent

class TextBotFlowTurnRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        TextBotFlowTurnRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'previous_turn': 'TextBotTurnReference',
            'input_event_type': 'str',
            'input_event_user_input': 'TextBotUserInputEvent',
            'input_event_error': 'TextBotErrorInputEvent'
        }

        self.attribute_map = {
            'previous_turn': 'previousTurn',
            'input_event_type': 'inputEventType',
            'input_event_user_input': 'inputEventUserInput',
            'input_event_error': 'inputEventError'
        }

        self._previous_turn = None
        self._input_event_type = None
        self._input_event_user_input = None
        self._input_event_error = None

    @property
    def previous_turn(self) -> 'TextBotTurnReference':
        """
        Gets the previous_turn of this TextBotFlowTurnRequest.
        The reference to a previous turn if appropriate, used to avoid race conditions.

        :return: The previous_turn of this TextBotFlowTurnRequest.
        :rtype: TextBotTurnReference
        """
        return self._previous_turn

    @previous_turn.setter
    def previous_turn(self, previous_turn: 'TextBotTurnReference') -> None:
        """
        Sets the previous_turn of this TextBotFlowTurnRequest.
        The reference to a previous turn if appropriate, used to avoid race conditions.

        :param previous_turn: The previous_turn of this TextBotFlowTurnRequest.
        :type: TextBotTurnReference
        """
        

        self._previous_turn = previous_turn

    @property
    def input_event_type(self) -> str:
        """
        Gets the input_event_type of this TextBotFlowTurnRequest.
        Indicates the type of input event being requested. If appropriate, fill out the matching user input object details on this request.

        :return: The input_event_type of this TextBotFlowTurnRequest.
        :rtype: str
        """
        return self._input_event_type

    @input_event_type.setter
    def input_event_type(self, input_event_type: str) -> None:
        """
        Sets the input_event_type of this TextBotFlowTurnRequest.
        Indicates the type of input event being requested. If appropriate, fill out the matching user input object details on this request.

        :param input_event_type: The input_event_type of this TextBotFlowTurnRequest.
        :type: str
        """
        allowed_values = ["NoOp", "UserInput", "Error", "NoMatch", "NoInput", "UserDisconnect", "ClientSessionExpired"]
        if input_event_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for input_event_type -> " + input_event_type)
            self._input_event_type = "outdated_sdk_version"
        else:
            self._input_event_type = input_event_type

    @property
    def input_event_user_input(self) -> 'TextBotUserInputEvent':
        """
        Gets the input_event_user_input of this TextBotFlowTurnRequest.
        The data for the input event of this turn if it is a user input event. Only one inputEvent may be set.

        :return: The input_event_user_input of this TextBotFlowTurnRequest.
        :rtype: TextBotUserInputEvent
        """
        return self._input_event_user_input

    @input_event_user_input.setter
    def input_event_user_input(self, input_event_user_input: 'TextBotUserInputEvent') -> None:
        """
        Sets the input_event_user_input of this TextBotFlowTurnRequest.
        The data for the input event of this turn if it is a user input event. Only one inputEvent may be set.

        :param input_event_user_input: The input_event_user_input of this TextBotFlowTurnRequest.
        :type: TextBotUserInputEvent
        """
        

        self._input_event_user_input = input_event_user_input

    @property
    def input_event_error(self) -> 'TextBotErrorInputEvent':
        """
        Gets the input_event_error of this TextBotFlowTurnRequest.
        The data for the input event of this turn if it is an error event. Only one inputEvent may be set.

        :return: The input_event_error of this TextBotFlowTurnRequest.
        :rtype: TextBotErrorInputEvent
        """
        return self._input_event_error

    @input_event_error.setter
    def input_event_error(self, input_event_error: 'TextBotErrorInputEvent') -> None:
        """
        Sets the input_event_error of this TextBotFlowTurnRequest.
        The data for the input event of this turn if it is an error event. Only one inputEvent may be set.

        :param input_event_error: The input_event_error of this TextBotFlowTurnRequest.
        :type: TextBotErrorInputEvent
        """
        

        self._input_event_error = input_event_error

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

