# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import SkillGroupLanguageCondition
    from . import SkillGroupRoutingCondition

class SkillGroupCondition(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        SkillGroupCondition - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'routing_skill_conditions': 'list[SkillGroupRoutingCondition]',
            'language_skill_conditions': 'list[SkillGroupLanguageCondition]',
            'operation': 'str'
        }

        self.attribute_map = {
            'routing_skill_conditions': 'routingSkillConditions',
            'language_skill_conditions': 'languageSkillConditions',
            'operation': 'operation'
        }

        self._routing_skill_conditions = None
        self._language_skill_conditions = None
        self._operation = None

    @property
    def routing_skill_conditions(self) -> List['SkillGroupRoutingCondition']:
        """
        Gets the routing_skill_conditions of this SkillGroupCondition.
        Routing skill conditions that will be used for building the query

        :return: The routing_skill_conditions of this SkillGroupCondition.
        :rtype: list[SkillGroupRoutingCondition]
        """
        return self._routing_skill_conditions

    @routing_skill_conditions.setter
    def routing_skill_conditions(self, routing_skill_conditions: List['SkillGroupRoutingCondition']) -> None:
        """
        Sets the routing_skill_conditions of this SkillGroupCondition.
        Routing skill conditions that will be used for building the query

        :param routing_skill_conditions: The routing_skill_conditions of this SkillGroupCondition.
        :type: list[SkillGroupRoutingCondition]
        """
        

        self._routing_skill_conditions = routing_skill_conditions

    @property
    def language_skill_conditions(self) -> List['SkillGroupLanguageCondition']:
        """
        Gets the language_skill_conditions of this SkillGroupCondition.
        Routing skill conditions that will be used for building the query

        :return: The language_skill_conditions of this SkillGroupCondition.
        :rtype: list[SkillGroupLanguageCondition]
        """
        return self._language_skill_conditions

    @language_skill_conditions.setter
    def language_skill_conditions(self, language_skill_conditions: List['SkillGroupLanguageCondition']) -> None:
        """
        Sets the language_skill_conditions of this SkillGroupCondition.
        Routing skill conditions that will be used for building the query

        :param language_skill_conditions: The language_skill_conditions of this SkillGroupCondition.
        :type: list[SkillGroupLanguageCondition]
        """
        

        self._language_skill_conditions = language_skill_conditions

    @property
    def operation(self) -> str:
        """
        Gets the operation of this SkillGroupCondition.
        Operator that will be applied to the conditions

        :return: The operation of this SkillGroupCondition.
        :rtype: str
        """
        return self._operation

    @operation.setter
    def operation(self, operation: str) -> None:
        """
        Sets the operation of this SkillGroupCondition.
        Operator that will be applied to the conditions

        :param operation: The operation of this SkillGroupCondition.
        :type: str
        """
        allowed_values = ["And", "Not", "Or"]
        if operation.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for operation -> " + operation)
            self._operation = "outdated_sdk_version"
        else:
            self._operation = operation

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

