# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import RequestScoredAgent

class RoutingConversationAttributesRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        RoutingConversationAttributesRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'priority': 'int',
            'skill_ids': 'list[str]',
            'language_id': 'str',
            'request_scored_agents': 'list[RequestScoredAgent]'
        }

        self.attribute_map = {
            'priority': 'priority',
            'skill_ids': 'skillIds',
            'language_id': 'languageId',
            'request_scored_agents': 'requestScoredAgents'
        }

        self._priority = None
        self._skill_ids = None
        self._language_id = None
        self._request_scored_agents = None

    @property
    def priority(self) -> int:
        """
        Gets the priority of this RoutingConversationAttributesRequest.
        Priority for the conversation.  Each point of priority is equivalent to one minute of time in queue.  Range:[-25000000, 25000000].  To reset, specify 0.

        :return: The priority of this RoutingConversationAttributesRequest.
        :rtype: int
        """
        return self._priority

    @priority.setter
    def priority(self, priority: int) -> None:
        """
        Sets the priority of this RoutingConversationAttributesRequest.
        Priority for the conversation.  Each point of priority is equivalent to one minute of time in queue.  Range:[-25000000, 25000000].  To reset, specify 0.

        :param priority: The priority of this RoutingConversationAttributesRequest.
        :type: int
        """
        
        if priority > 25000000:
            raise ValueError("Invalid value for `priority`, must be a value less than or equal to `25000000`")

        if priority < -25000000:
            raise ValueError("Invalid value for `priority`, must be a value greater than or equal to `-25000000`")


        self._priority = priority

    @property
    def skill_ids(self) -> List[str]:
        """
        Gets the skill_ids of this RoutingConversationAttributesRequest.
        Skill requirements for the conversation.  To remove all skill requirements, specify an empty list, i.e. [].

        :return: The skill_ids of this RoutingConversationAttributesRequest.
        :rtype: list[str]
        """
        return self._skill_ids

    @skill_ids.setter
    def skill_ids(self, skill_ids: List[str]) -> None:
        """
        Sets the skill_ids of this RoutingConversationAttributesRequest.
        Skill requirements for the conversation.  To remove all skill requirements, specify an empty list, i.e. [].

        :param skill_ids: The skill_ids of this RoutingConversationAttributesRequest.
        :type: list[str]
        """
        

        self._skill_ids = skill_ids

    @property
    def language_id(self) -> str:
        """
        Gets the language_id of this RoutingConversationAttributesRequest.
        Language requirement for the conversation.  To remove the language requirement, specify an empty string, i.e., \"\".

        :return: The language_id of this RoutingConversationAttributesRequest.
        :rtype: str
        """
        return self._language_id

    @language_id.setter
    def language_id(self, language_id: str) -> None:
        """
        Sets the language_id of this RoutingConversationAttributesRequest.
        Language requirement for the conversation.  To remove the language requirement, specify an empty string, i.e., \"\".

        :param language_id: The language_id of this RoutingConversationAttributesRequest.
        :type: str
        """
        

        self._language_id = language_id

    @property
    def request_scored_agents(self) -> List['RequestScoredAgent']:
        """
        Gets the request_scored_agents of this RoutingConversationAttributesRequest.


        :return: The request_scored_agents of this RoutingConversationAttributesRequest.
        :rtype: list[RequestScoredAgent]
        """
        return self._request_scored_agents

    @request_scored_agents.setter
    def request_scored_agents(self, request_scored_agents: List['RequestScoredAgent']) -> None:
        """
        Sets the request_scored_agents of this RoutingConversationAttributesRequest.


        :param request_scored_agents: The request_scored_agents of this RoutingConversationAttributesRequest.
        :type: list[RequestScoredAgent]
        """
        

        self._request_scored_agents = request_scored_agents

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

