# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class RestorePresenceSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        RestorePresenceSettings - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'enabled': 'bool',
            'restore_time_milliseconds': 'int',
            'restore_on_queue_enabled': 'bool'
        }

        self.attribute_map = {
            'enabled': 'enabled',
            'restore_time_milliseconds': 'restoreTimeMilliseconds',
            'restore_on_queue_enabled': 'restoreOnQueueEnabled'
        }

        self._enabled = None
        self._restore_time_milliseconds = None
        self._restore_on_queue_enabled = None

    @property
    def enabled(self) -> bool:
        """
        Gets the enabled of this RestorePresenceSettings.
        Whether the restore presence feature is enabled

        :return: The enabled of this RestorePresenceSettings.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled: bool) -> None:
        """
        Sets the enabled of this RestorePresenceSettings.
        Whether the restore presence feature is enabled

        :param enabled: The enabled of this RestorePresenceSettings.
        :type: bool
        """
        

        self._enabled = enabled

    @property
    def restore_time_milliseconds(self) -> int:
        """
        Gets the restore_time_milliseconds of this RestorePresenceSettings.
        How many milliseconds the presence will be restored within

        :return: The restore_time_milliseconds of this RestorePresenceSettings.
        :rtype: int
        """
        return self._restore_time_milliseconds

    @restore_time_milliseconds.setter
    def restore_time_milliseconds(self, restore_time_milliseconds: int) -> None:
        """
        Sets the restore_time_milliseconds of this RestorePresenceSettings.
        How many milliseconds the presence will be restored within

        :param restore_time_milliseconds: The restore_time_milliseconds of this RestorePresenceSettings.
        :type: int
        """
        

        self._restore_time_milliseconds = restore_time_milliseconds

    @property
    def restore_on_queue_enabled(self) -> bool:
        """
        Gets the restore_on_queue_enabled of this RestorePresenceSettings.
        Whether the ON_QUEUE presence will be restored

        :return: The restore_on_queue_enabled of this RestorePresenceSettings.
        :rtype: bool
        """
        return self._restore_on_queue_enabled

    @restore_on_queue_enabled.setter
    def restore_on_queue_enabled(self, restore_on_queue_enabled: bool) -> None:
        """
        Sets the restore_on_queue_enabled of this RestorePresenceSettings.
        Whether the ON_QUEUE presence will be restored

        :param restore_on_queue_enabled: The restore_on_queue_enabled of this RestorePresenceSettings.
        :type: bool
        """
        

        self._restore_on_queue_enabled = restore_on_queue_enabled

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

