# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import QueueConversationVideoEventTopicAddress
    from . import QueueConversationVideoEventTopicAfterCallWork
    from . import QueueConversationVideoEventTopicWrapup

class QueueConversationVideoEventTopicScreenshare(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        QueueConversationVideoEventTopicScreenshare - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'state': 'str',
            'initial_state': 'str',
            'pcSelf': 'QueueConversationVideoEventTopicAddress',
            'id': 'str',
            'context': 'str',
            'sharing': 'bool',
            'provider': 'str',
            'script_id': 'str',
            'peer_id': 'str',
            'peer_count': 'object',
            'disconnect_type': 'str',
            'connected_time': 'datetime',
            'disconnected_time': 'datetime',
            'wrapup': 'QueueConversationVideoEventTopicWrapup',
            'after_call_work': 'QueueConversationVideoEventTopicAfterCallWork',
            'after_call_work_required': 'bool'
        }

        self.attribute_map = {
            'state': 'state',
            'initial_state': 'initialState',
            'pcSelf': 'self',
            'id': 'id',
            'context': 'context',
            'sharing': 'sharing',
            'provider': 'provider',
            'script_id': 'scriptId',
            'peer_id': 'peerId',
            'peer_count': 'peerCount',
            'disconnect_type': 'disconnectType',
            'connected_time': 'connectedTime',
            'disconnected_time': 'disconnectedTime',
            'wrapup': 'wrapup',
            'after_call_work': 'afterCallWork',
            'after_call_work_required': 'afterCallWorkRequired'
        }

        self._state = None
        self._initial_state = None
        self._pcSelf = None
        self._id = None
        self._context = None
        self._sharing = None
        self._provider = None
        self._script_id = None
        self._peer_id = None
        self._peer_count = None
        self._disconnect_type = None
        self._connected_time = None
        self._disconnected_time = None
        self._wrapup = None
        self._after_call_work = None
        self._after_call_work_required = None

    @property
    def state(self) -> str:
        """
        Gets the state of this QueueConversationVideoEventTopicScreenshare.


        :return: The state of this QueueConversationVideoEventTopicScreenshare.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this QueueConversationVideoEventTopicScreenshare.


        :param state: The state of this QueueConversationVideoEventTopicScreenshare.
        :type: str
        """
        allowed_values = ["alerting", "dialing", "contacting", "offering", "connected", "disconnected", "terminated", "none"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def initial_state(self) -> str:
        """
        Gets the initial_state of this QueueConversationVideoEventTopicScreenshare.


        :return: The initial_state of this QueueConversationVideoEventTopicScreenshare.
        :rtype: str
        """
        return self._initial_state

    @initial_state.setter
    def initial_state(self, initial_state: str) -> None:
        """
        Sets the initial_state of this QueueConversationVideoEventTopicScreenshare.


        :param initial_state: The initial_state of this QueueConversationVideoEventTopicScreenshare.
        :type: str
        """
        allowed_values = ["alerting", "dialing", "contacting", "offering", "connected", "disconnected", "terminated", "none"]
        if initial_state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for initial_state -> " + initial_state)
            self._initial_state = "outdated_sdk_version"
        else:
            self._initial_state = initial_state

    @property
    def pcSelf(self) -> 'QueueConversationVideoEventTopicAddress':
        """
        Gets the pcSelf of this QueueConversationVideoEventTopicScreenshare.
        Address and name data for a call endpoint.

        :return: The pcSelf of this QueueConversationVideoEventTopicScreenshare.
        :rtype: QueueConversationVideoEventTopicAddress
        """
        return self._pcSelf

    @pcSelf.setter
    def pcSelf(self, pcSelf: 'QueueConversationVideoEventTopicAddress') -> None:
        """
        Sets the pcSelf of this QueueConversationVideoEventTopicScreenshare.
        Address and name data for a call endpoint.

        :param pcSelf: The pcSelf of this QueueConversationVideoEventTopicScreenshare.
        :type: QueueConversationVideoEventTopicAddress
        """
        

        self._pcSelf = pcSelf

    @property
    def id(self) -> str:
        """
        Gets the id of this QueueConversationVideoEventTopicScreenshare.
        A globally unique identifier for this communication.

        :return: The id of this QueueConversationVideoEventTopicScreenshare.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this QueueConversationVideoEventTopicScreenshare.
        A globally unique identifier for this communication.

        :param id: The id of this QueueConversationVideoEventTopicScreenshare.
        :type: str
        """
        

        self._id = id

    @property
    def context(self) -> str:
        """
        Gets the context of this QueueConversationVideoEventTopicScreenshare.
        The room id context (xmpp jid) for the conference session.

        :return: The context of this QueueConversationVideoEventTopicScreenshare.
        :rtype: str
        """
        return self._context

    @context.setter
    def context(self, context: str) -> None:
        """
        Sets the context of this QueueConversationVideoEventTopicScreenshare.
        The room id context (xmpp jid) for the conference session.

        :param context: The context of this QueueConversationVideoEventTopicScreenshare.
        :type: str
        """
        

        self._context = context

    @property
    def sharing(self) -> bool:
        """
        Gets the sharing of this QueueConversationVideoEventTopicScreenshare.
        Indicates whether this participant is sharing their screen to the session.

        :return: The sharing of this QueueConversationVideoEventTopicScreenshare.
        :rtype: bool
        """
        return self._sharing

    @sharing.setter
    def sharing(self, sharing: bool) -> None:
        """
        Sets the sharing of this QueueConversationVideoEventTopicScreenshare.
        Indicates whether this participant is sharing their screen to the session.

        :param sharing: The sharing of this QueueConversationVideoEventTopicScreenshare.
        :type: bool
        """
        

        self._sharing = sharing

    @property
    def provider(self) -> str:
        """
        Gets the provider of this QueueConversationVideoEventTopicScreenshare.
        The source provider of the screen share.

        :return: The provider of this QueueConversationVideoEventTopicScreenshare.
        :rtype: str
        """
        return self._provider

    @provider.setter
    def provider(self, provider: str) -> None:
        """
        Sets the provider of this QueueConversationVideoEventTopicScreenshare.
        The source provider of the screen share.

        :param provider: The provider of this QueueConversationVideoEventTopicScreenshare.
        :type: str
        """
        

        self._provider = provider

    @property
    def script_id(self) -> str:
        """
        Gets the script_id of this QueueConversationVideoEventTopicScreenshare.
        The UUID of the script to use.

        :return: The script_id of this QueueConversationVideoEventTopicScreenshare.
        :rtype: str
        """
        return self._script_id

    @script_id.setter
    def script_id(self, script_id: str) -> None:
        """
        Sets the script_id of this QueueConversationVideoEventTopicScreenshare.
        The UUID of the script to use.

        :param script_id: The script_id of this QueueConversationVideoEventTopicScreenshare.
        :type: str
        """
        

        self._script_id = script_id

    @property
    def peer_id(self) -> str:
        """
        Gets the peer_id of this QueueConversationVideoEventTopicScreenshare.
        The id of the peer communication corresponding to a matching leg for this communication.

        :return: The peer_id of this QueueConversationVideoEventTopicScreenshare.
        :rtype: str
        """
        return self._peer_id

    @peer_id.setter
    def peer_id(self, peer_id: str) -> None:
        """
        Sets the peer_id of this QueueConversationVideoEventTopicScreenshare.
        The id of the peer communication corresponding to a matching leg for this communication.

        :param peer_id: The peer_id of this QueueConversationVideoEventTopicScreenshare.
        :type: str
        """
        

        self._peer_id = peer_id

    @property
    def peer_count(self) -> object:
        """
        Gets the peer_count of this QueueConversationVideoEventTopicScreenshare.
        The number of peer participants from the perspective of the participant in the conference.

        :return: The peer_count of this QueueConversationVideoEventTopicScreenshare.
        :rtype: object
        """
        return self._peer_count

    @peer_count.setter
    def peer_count(self, peer_count: object) -> None:
        """
        Sets the peer_count of this QueueConversationVideoEventTopicScreenshare.
        The number of peer participants from the perspective of the participant in the conference.

        :param peer_count: The peer_count of this QueueConversationVideoEventTopicScreenshare.
        :type: object
        """
        

        self._peer_count = peer_count

    @property
    def disconnect_type(self) -> str:
        """
        Gets the disconnect_type of this QueueConversationVideoEventTopicScreenshare.
        System defined string indicating what caused the communication to disconnect. Will be null until the communication disconnects.

        :return: The disconnect_type of this QueueConversationVideoEventTopicScreenshare.
        :rtype: str
        """
        return self._disconnect_type

    @disconnect_type.setter
    def disconnect_type(self, disconnect_type: str) -> None:
        """
        Sets the disconnect_type of this QueueConversationVideoEventTopicScreenshare.
        System defined string indicating what caused the communication to disconnect. Will be null until the communication disconnects.

        :param disconnect_type: The disconnect_type of this QueueConversationVideoEventTopicScreenshare.
        :type: str
        """
        allowed_values = ["endpoint", "client", "system", "timeout", "transfer", "transfer.conference", "transfer.consult", "transfer.forward", "transfer.noanswer", "transfer.notavailable", "transport.failure", "error", "peer", "other", "spam", "uncallable"]
        if disconnect_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for disconnect_type -> " + disconnect_type)
            self._disconnect_type = "outdated_sdk_version"
        else:
            self._disconnect_type = disconnect_type

    @property
    def connected_time(self) -> datetime:
        """
        Gets the connected_time of this QueueConversationVideoEventTopicScreenshare.
        The timestamp when this communication was connected in the cloud clock.

        :return: The connected_time of this QueueConversationVideoEventTopicScreenshare.
        :rtype: datetime
        """
        return self._connected_time

    @connected_time.setter
    def connected_time(self, connected_time: datetime) -> None:
        """
        Sets the connected_time of this QueueConversationVideoEventTopicScreenshare.
        The timestamp when this communication was connected in the cloud clock.

        :param connected_time: The connected_time of this QueueConversationVideoEventTopicScreenshare.
        :type: datetime
        """
        

        self._connected_time = connected_time

    @property
    def disconnected_time(self) -> datetime:
        """
        Gets the disconnected_time of this QueueConversationVideoEventTopicScreenshare.
        The timestamp when this communication disconnected from the conversation in the provider clock.

        :return: The disconnected_time of this QueueConversationVideoEventTopicScreenshare.
        :rtype: datetime
        """
        return self._disconnected_time

    @disconnected_time.setter
    def disconnected_time(self, disconnected_time: datetime) -> None:
        """
        Sets the disconnected_time of this QueueConversationVideoEventTopicScreenshare.
        The timestamp when this communication disconnected from the conversation in the provider clock.

        :param disconnected_time: The disconnected_time of this QueueConversationVideoEventTopicScreenshare.
        :type: datetime
        """
        

        self._disconnected_time = disconnected_time

    @property
    def wrapup(self) -> 'QueueConversationVideoEventTopicWrapup':
        """
        Gets the wrapup of this QueueConversationVideoEventTopicScreenshare.
        Call wrap up or disposition data.

        :return: The wrapup of this QueueConversationVideoEventTopicScreenshare.
        :rtype: QueueConversationVideoEventTopicWrapup
        """
        return self._wrapup

    @wrapup.setter
    def wrapup(self, wrapup: 'QueueConversationVideoEventTopicWrapup') -> None:
        """
        Sets the wrapup of this QueueConversationVideoEventTopicScreenshare.
        Call wrap up or disposition data.

        :param wrapup: The wrapup of this QueueConversationVideoEventTopicScreenshare.
        :type: QueueConversationVideoEventTopicWrapup
        """
        

        self._wrapup = wrapup

    @property
    def after_call_work(self) -> 'QueueConversationVideoEventTopicAfterCallWork':
        """
        Gets the after_call_work of this QueueConversationVideoEventTopicScreenshare.
        A communication's after-call work data.

        :return: The after_call_work of this QueueConversationVideoEventTopicScreenshare.
        :rtype: QueueConversationVideoEventTopicAfterCallWork
        """
        return self._after_call_work

    @after_call_work.setter
    def after_call_work(self, after_call_work: 'QueueConversationVideoEventTopicAfterCallWork') -> None:
        """
        Sets the after_call_work of this QueueConversationVideoEventTopicScreenshare.
        A communication's after-call work data.

        :param after_call_work: The after_call_work of this QueueConversationVideoEventTopicScreenshare.
        :type: QueueConversationVideoEventTopicAfterCallWork
        """
        

        self._after_call_work = after_call_work

    @property
    def after_call_work_required(self) -> bool:
        """
        Gets the after_call_work_required of this QueueConversationVideoEventTopicScreenshare.
        Indicates if after-call is required for a communication. Only used when the ACW Setting is Agent Requested.

        :return: The after_call_work_required of this QueueConversationVideoEventTopicScreenshare.
        :rtype: bool
        """
        return self._after_call_work_required

    @after_call_work_required.setter
    def after_call_work_required(self, after_call_work_required: bool) -> None:
        """
        Sets the after_call_work_required of this QueueConversationVideoEventTopicScreenshare.
        Indicates if after-call is required for a communication. Only used when the ACW Setting is Agent Requested.

        :param after_call_work_required: The after_call_work_required of this QueueConversationVideoEventTopicScreenshare.
        :type: bool
        """
        

        self._after_call_work_required = after_call_work_required

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

