# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ContentSetting
    from . import DomainEntityRef
    from . import EventSetting

class MessagingSettingReference(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        MessagingSettingReference - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'self_uri': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'version': 'str',
            'created_by': 'DomainEntityRef',
            'updated_by': 'DomainEntityRef',
            'content': 'ContentSetting',
            'event': 'EventSetting'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'self_uri': 'selfUri',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'version': 'version',
            'created_by': 'createdBy',
            'updated_by': 'updatedBy',
            'content': 'content',
            'event': 'event'
        }

        self._id = None
        self._name = None
        self._self_uri = None
        self._date_created = None
        self._date_modified = None
        self._version = None
        self._created_by = None
        self._updated_by = None
        self._content = None
        self._event = None

    @property
    def id(self) -> str:
        """
        Gets the id of this MessagingSettingReference.
        The messaging Setting unique identifier associated with this integration

        :return: The id of this MessagingSettingReference.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this MessagingSettingReference.
        The messaging Setting unique identifier associated with this integration

        :param id: The id of this MessagingSettingReference.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this MessagingSettingReference.
        The messaging Setting profile name

        :return: The name of this MessagingSettingReference.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this MessagingSettingReference.
        The messaging Setting profile name

        :param name: The name of this MessagingSettingReference.
        :type: str
        """
        

        self._name = name

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this MessagingSettingReference.
        The messaging Setting profile URI

        :return: The self_uri of this MessagingSettingReference.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this MessagingSettingReference.
        The messaging Setting profile URI

        :param self_uri: The self_uri of this MessagingSettingReference.
        :type: str
        """
        

        self._self_uri = self_uri

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this MessagingSettingReference.
        Date this messaging Setting was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this MessagingSettingReference.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this MessagingSettingReference.
        Date this messaging Setting was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this MessagingSettingReference.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this MessagingSettingReference.
        Date this messaging Setting was modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this MessagingSettingReference.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this MessagingSettingReference.
        Date this messaging Setting was modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this MessagingSettingReference.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def version(self) -> str:
        """
        Gets the version of this MessagingSettingReference.
        Version number

        :return: The version of this MessagingSettingReference.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version: str) -> None:
        """
        Sets the version of this MessagingSettingReference.
        Version number

        :param version: The version of this MessagingSettingReference.
        :type: str
        """
        

        self._version = version

    @property
    def created_by(self) -> 'DomainEntityRef':
        """
        Gets the created_by of this MessagingSettingReference.
        User reference that created this Setting

        :return: The created_by of this MessagingSettingReference.
        :rtype: DomainEntityRef
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by: 'DomainEntityRef') -> None:
        """
        Sets the created_by of this MessagingSettingReference.
        User reference that created this Setting

        :param created_by: The created_by of this MessagingSettingReference.
        :type: DomainEntityRef
        """
        

        self._created_by = created_by

    @property
    def updated_by(self) -> 'DomainEntityRef':
        """
        Gets the updated_by of this MessagingSettingReference.
        User reference that modified this Setting

        :return: The updated_by of this MessagingSettingReference.
        :rtype: DomainEntityRef
        """
        return self._updated_by

    @updated_by.setter
    def updated_by(self, updated_by: 'DomainEntityRef') -> None:
        """
        Sets the updated_by of this MessagingSettingReference.
        User reference that modified this Setting

        :param updated_by: The updated_by of this MessagingSettingReference.
        :type: DomainEntityRef
        """
        

        self._updated_by = updated_by

    @property
    def content(self) -> 'ContentSetting':
        """
        Gets the content of this MessagingSettingReference.
        Settings relating to message contents

        :return: The content of this MessagingSettingReference.
        :rtype: ContentSetting
        """
        return self._content

    @content.setter
    def content(self, content: 'ContentSetting') -> None:
        """
        Sets the content of this MessagingSettingReference.
        Settings relating to message contents

        :param content: The content of this MessagingSettingReference.
        :type: ContentSetting
        """
        

        self._content = content

    @property
    def event(self) -> 'EventSetting':
        """
        Gets the event of this MessagingSettingReference.
        Settings relating to events which may occur

        :return: The event of this MessagingSettingReference.
        :rtype: EventSetting
        """
        return self._event

    @event.setter
    def event(self, event: 'EventSetting') -> None:
        """
        Sets the event of this MessagingSettingReference.
        Settings relating to events which may occur

        :param event: The event of this MessagingSettingReference.
        :type: EventSetting
        """
        

        self._event = event

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

