# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class MatchCriteria(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        MatchCriteria - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'json_path': 'str',
            'operator': 'str',
            'value': 'object',
            'values': 'list[object]'
        }

        self.attribute_map = {
            'json_path': 'jsonPath',
            'operator': 'operator',
            'value': 'value',
            'values': 'values'
        }

        self._json_path = None
        self._operator = None
        self._value = None
        self._values = None

    @property
    def json_path(self) -> str:
        """
        Gets the json_path of this MatchCriteria.
        The Goessner json path of the field to match

        :return: The json_path of this MatchCriteria.
        :rtype: str
        """
        return self._json_path

    @json_path.setter
    def json_path(self, json_path: str) -> None:
        """
        Sets the json_path of this MatchCriteria.
        The Goessner json path of the field to match

        :param json_path: The json_path of this MatchCriteria.
        :type: str
        """
        

        self._json_path = json_path

    @property
    def operator(self) -> str:
        """
        Gets the operator of this MatchCriteria.
        The type of operation to perform for matching check

        :return: The operator of this MatchCriteria.
        :rtype: str
        """
        return self._operator

    @operator.setter
    def operator(self, operator: str) -> None:
        """
        Sets the operator of this MatchCriteria.
        The type of operation to perform for matching check

        :param operator: The operator of this MatchCriteria.
        :type: str
        """
        allowed_values = ["GreaterThanOrEqual", "LessThanOrEqual", "Equal", "NotEqual", "LessThan", "GreaterThan", "NotIn", "In", "Contains", "All", "Exists", "Size"]
        if operator.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for operator -> " + operator)
            self._operator = "outdated_sdk_version"
        else:
            self._operator = operator

    @property
    def value(self) -> 'object':
        """
        Gets the value of this MatchCriteria.
        The value to match on. Only one of value and values can be included

        :return: The value of this MatchCriteria.
        :rtype: object
        """
        return self._value

    @value.setter
    def value(self, value: 'object') -> None:
        """
        Sets the value of this MatchCriteria.
        The value to match on. Only one of value and values can be included

        :param value: The value of this MatchCriteria.
        :type: object
        """
        

        self._value = value

    @property
    def values(self) -> List[object]:
        """
        Gets the values of this MatchCriteria.
        The list of values to match on. Only one of value and values can be included

        :return: The values of this MatchCriteria.
        :rtype: list[object]
        """
        return self._values

    @values.setter
    def values(self, values: List[object]) -> None:
        """
        Sets the values of this MatchCriteria.
        The list of values to match on. Only one of value and values can be included

        :param values: The values of this MatchCriteria.
        :type: list[object]
        """
        

        self._values = values

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

