# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DomainEntityRef
    from . import ErrorBody
    from . import MessagingSettingReference
    from . import SupportedContentReference

class LineIntegration(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        LineIntegration - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'supported_content': 'SupportedContentReference',
            'messaging_setting': 'MessagingSettingReference',
            'channel_id': 'str',
            'webhook_uri': 'str',
            'status': 'str',
            'recipient': 'DomainEntityRef',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'created_by': 'DomainEntityRef',
            'modified_by': 'DomainEntityRef',
            'version': 'int',
            'create_status': 'str',
            'create_error': 'ErrorBody',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'supported_content': 'supportedContent',
            'messaging_setting': 'messagingSetting',
            'channel_id': 'channelId',
            'webhook_uri': 'webhookUri',
            'status': 'status',
            'recipient': 'recipient',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'created_by': 'createdBy',
            'modified_by': 'modifiedBy',
            'version': 'version',
            'create_status': 'createStatus',
            'create_error': 'createError',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._supported_content = None
        self._messaging_setting = None
        self._channel_id = None
        self._webhook_uri = None
        self._status = None
        self._recipient = None
        self._date_created = None
        self._date_modified = None
        self._created_by = None
        self._modified_by = None
        self._version = None
        self._create_status = None
        self._create_error = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this LineIntegration.
        A unique Integration Id

        :return: The id of this LineIntegration.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this LineIntegration.
        A unique Integration Id

        :param id: The id of this LineIntegration.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this LineIntegration.
        The name of the LINE Integration

        :return: The name of this LineIntegration.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this LineIntegration.
        The name of the LINE Integration

        :param name: The name of this LineIntegration.
        :type: str
        """
        

        self._name = name

    @property
    def supported_content(self) -> 'SupportedContentReference':
        """
        Gets the supported_content of this LineIntegration.
        Defines the SupportedContent profile configured for an integration

        :return: The supported_content of this LineIntegration.
        :rtype: SupportedContentReference
        """
        return self._supported_content

    @supported_content.setter
    def supported_content(self, supported_content: 'SupportedContentReference') -> None:
        """
        Sets the supported_content of this LineIntegration.
        Defines the SupportedContent profile configured for an integration

        :param supported_content: The supported_content of this LineIntegration.
        :type: SupportedContentReference
        """
        

        self._supported_content = supported_content

    @property
    def messaging_setting(self) -> 'MessagingSettingReference':
        """
        Gets the messaging_setting of this LineIntegration.


        :return: The messaging_setting of this LineIntegration.
        :rtype: MessagingSettingReference
        """
        return self._messaging_setting

    @messaging_setting.setter
    def messaging_setting(self, messaging_setting: 'MessagingSettingReference') -> None:
        """
        Sets the messaging_setting of this LineIntegration.


        :param messaging_setting: The messaging_setting of this LineIntegration.
        :type: MessagingSettingReference
        """
        

        self._messaging_setting = messaging_setting

    @property
    def channel_id(self) -> str:
        """
        Gets the channel_id of this LineIntegration.
        The Channel Id from LINE messenger

        :return: The channel_id of this LineIntegration.
        :rtype: str
        """
        return self._channel_id

    @channel_id.setter
    def channel_id(self, channel_id: str) -> None:
        """
        Sets the channel_id of this LineIntegration.
        The Channel Id from LINE messenger

        :param channel_id: The channel_id of this LineIntegration.
        :type: str
        """
        

        self._channel_id = channel_id

    @property
    def webhook_uri(self) -> str:
        """
        Gets the webhook_uri of this LineIntegration.
        The Webhook URI to be updated in LINE platform

        :return: The webhook_uri of this LineIntegration.
        :rtype: str
        """
        return self._webhook_uri

    @webhook_uri.setter
    def webhook_uri(self, webhook_uri: str) -> None:
        """
        Sets the webhook_uri of this LineIntegration.
        The Webhook URI to be updated in LINE platform

        :param webhook_uri: The webhook_uri of this LineIntegration.
        :type: str
        """
        

        self._webhook_uri = webhook_uri

    @property
    def status(self) -> str:
        """
        Gets the status of this LineIntegration.
        The status of the LINE Integration

        :return: The status of this LineIntegration.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this LineIntegration.
        The status of the LINE Integration

        :param status: The status of this LineIntegration.
        :type: str
        """
        

        self._status = status

    @property
    def recipient(self) -> 'DomainEntityRef':
        """
        Gets the recipient of this LineIntegration.
        The recipient associated to the Line Integration. This recipient is used to associate a flow to an integration

        :return: The recipient of this LineIntegration.
        :rtype: DomainEntityRef
        """
        return self._recipient

    @recipient.setter
    def recipient(self, recipient: 'DomainEntityRef') -> None:
        """
        Sets the recipient of this LineIntegration.
        The recipient associated to the Line Integration. This recipient is used to associate a flow to an integration

        :param recipient: The recipient of this LineIntegration.
        :type: DomainEntityRef
        """
        

        self._recipient = recipient

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this LineIntegration.
        Date this Integration was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this LineIntegration.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this LineIntegration.
        Date this Integration was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this LineIntegration.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this LineIntegration.
        Date this Integration was modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this LineIntegration.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this LineIntegration.
        Date this Integration was modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this LineIntegration.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def created_by(self) -> 'DomainEntityRef':
        """
        Gets the created_by of this LineIntegration.
        User reference that created this Integration

        :return: The created_by of this LineIntegration.
        :rtype: DomainEntityRef
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by: 'DomainEntityRef') -> None:
        """
        Sets the created_by of this LineIntegration.
        User reference that created this Integration

        :param created_by: The created_by of this LineIntegration.
        :type: DomainEntityRef
        """
        

        self._created_by = created_by

    @property
    def modified_by(self) -> 'DomainEntityRef':
        """
        Gets the modified_by of this LineIntegration.
        User reference that last modified this Integration

        :return: The modified_by of this LineIntegration.
        :rtype: DomainEntityRef
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by: 'DomainEntityRef') -> None:
        """
        Sets the modified_by of this LineIntegration.
        User reference that last modified this Integration

        :param modified_by: The modified_by of this LineIntegration.
        :type: DomainEntityRef
        """
        

        self._modified_by = modified_by

    @property
    def version(self) -> int:
        """
        Gets the version of this LineIntegration.
        Version number required for updates.

        :return: The version of this LineIntegration.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version: int) -> None:
        """
        Sets the version of this LineIntegration.
        Version number required for updates.

        :param version: The version of this LineIntegration.
        :type: int
        """
        

        self._version = version

    @property
    def create_status(self) -> str:
        """
        Gets the create_status of this LineIntegration.
        Status of asynchronous create operation

        :return: The create_status of this LineIntegration.
        :rtype: str
        """
        return self._create_status

    @create_status.setter
    def create_status(self, create_status: str) -> None:
        """
        Sets the create_status of this LineIntegration.
        Status of asynchronous create operation

        :param create_status: The create_status of this LineIntegration.
        :type: str
        """
        allowed_values = ["Initiated", "Completed", "Error"]
        if create_status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for create_status -> " + create_status)
            self._create_status = "outdated_sdk_version"
        else:
            self._create_status = create_status

    @property
    def create_error(self) -> 'ErrorBody':
        """
        Gets the create_error of this LineIntegration.
        Error information returned, if createStatus is set to Error

        :return: The create_error of this LineIntegration.
        :rtype: ErrorBody
        """
        return self._create_error

    @create_error.setter
    def create_error(self, create_error: 'ErrorBody') -> None:
        """
        Sets the create_error of this LineIntegration.
        Error information returned, if createStatus is set to Error

        :param create_error: The create_error of this LineIntegration.
        :type: ErrorBody
        """
        

        self._create_error = create_error

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this LineIntegration.
        The URI for this object

        :return: The self_uri of this LineIntegration.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this LineIntegration.
        The URI for this object

        :param self_uri: The self_uri of this LineIntegration.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

