# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import KnowledgeGuestDocumentSuggestionResult

class KnowledgeGuestDocumentSuggestion(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        KnowledgeGuestDocumentSuggestion - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'query': 'str',
            'page_size': 'int',
            'session_id': 'str',
            'results': 'list[KnowledgeGuestDocumentSuggestionResult]'
        }

        self.attribute_map = {
            'query': 'query',
            'page_size': 'pageSize',
            'session_id': 'sessionId',
            'results': 'results'
        }

        self._query = None
        self._page_size = None
        self._session_id = None
        self._results = None

    @property
    def query(self) -> str:
        """
        Gets the query of this KnowledgeGuestDocumentSuggestion.
        Query to get autocomplete suggestions for the matching knowledge documents.

        :return: The query of this KnowledgeGuestDocumentSuggestion.
        :rtype: str
        """
        return self._query

    @query.setter
    def query(self, query: str) -> None:
        """
        Sets the query of this KnowledgeGuestDocumentSuggestion.
        Query to get autocomplete suggestions for the matching knowledge documents.

        :param query: The query of this KnowledgeGuestDocumentSuggestion.
        :type: str
        """
        

        self._query = query

    @property
    def page_size(self) -> int:
        """
        Gets the page_size of this KnowledgeGuestDocumentSuggestion.
        Page size of the returned results.

        :return: The page_size of this KnowledgeGuestDocumentSuggestion.
        :rtype: int
        """
        return self._page_size

    @page_size.setter
    def page_size(self, page_size: int) -> None:
        """
        Sets the page_size of this KnowledgeGuestDocumentSuggestion.
        Page size of the returned results.

        :param page_size: The page_size of this KnowledgeGuestDocumentSuggestion.
        :type: int
        """
        

        self._page_size = page_size

    @property
    def session_id(self) -> str:
        """
        Gets the session_id of this KnowledgeGuestDocumentSuggestion.
        Session ID of the guest suggestions.

        :return: The session_id of this KnowledgeGuestDocumentSuggestion.
        :rtype: str
        """
        return self._session_id

    @session_id.setter
    def session_id(self, session_id: str) -> None:
        """
        Sets the session_id of this KnowledgeGuestDocumentSuggestion.
        Session ID of the guest suggestions.

        :param session_id: The session_id of this KnowledgeGuestDocumentSuggestion.
        :type: str
        """
        

        self._session_id = session_id

    @property
    def results(self) -> List['KnowledgeGuestDocumentSuggestionResult']:
        """
        Gets the results of this KnowledgeGuestDocumentSuggestion.
        Suggestions matching the query.

        :return: The results of this KnowledgeGuestDocumentSuggestion.
        :rtype: list[KnowledgeGuestDocumentSuggestionResult]
        """
        return self._results

    @results.setter
    def results(self, results: List['KnowledgeGuestDocumentSuggestionResult']) -> None:
        """
        Sets the results of this KnowledgeGuestDocumentSuggestion.
        Suggestions matching the query.

        :param results: The results of this KnowledgeGuestDocumentSuggestion.
        :type: list[KnowledgeGuestDocumentSuggestionResult]
        """
        

        self._results = results

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

