# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DocumentQuery
    from . import DocumentQueryInterval
    from . import KnowledgeConversationContext
    from . import KnowledgeSearchClientApplication

class KnowledgeDocumentSearchRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        KnowledgeDocumentSearchRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'query': 'str',
            'page_size': 'int',
            'page_number': 'int',
            'search_id': 'str',
            'total': 'int',
            'page_count': 'int',
            'query_type': 'str',
            'include_draft_documents': 'bool',
            'interval': 'DocumentQueryInterval',
            'filter': 'DocumentQuery',
            'sort_order': 'str',
            'sort_by': 'str',
            'application': 'KnowledgeSearchClientApplication',
            'conversation_context': 'KnowledgeConversationContext'
        }

        self.attribute_map = {
            'query': 'query',
            'page_size': 'pageSize',
            'page_number': 'pageNumber',
            'search_id': 'searchId',
            'total': 'total',
            'page_count': 'pageCount',
            'query_type': 'queryType',
            'include_draft_documents': 'includeDraftDocuments',
            'interval': 'interval',
            'filter': 'filter',
            'sort_order': 'sortOrder',
            'sort_by': 'sortBy',
            'application': 'application',
            'conversation_context': 'conversationContext'
        }

        self._query = None
        self._page_size = None
        self._page_number = None
        self._search_id = None
        self._total = None
        self._page_count = None
        self._query_type = None
        self._include_draft_documents = None
        self._interval = None
        self._filter = None
        self._sort_order = None
        self._sort_by = None
        self._application = None
        self._conversation_context = None

    @property
    def query(self) -> str:
        """
        Gets the query of this KnowledgeDocumentSearchRequest.
        Query to search content in the knowledge base. Maximum of 30 records per query can be fetched.

        :return: The query of this KnowledgeDocumentSearchRequest.
        :rtype: str
        """
        return self._query

    @query.setter
    def query(self, query: str) -> None:
        """
        Sets the query of this KnowledgeDocumentSearchRequest.
        Query to search content in the knowledge base. Maximum of 30 records per query can be fetched.

        :param query: The query of this KnowledgeDocumentSearchRequest.
        :type: str
        """
        
        if len(query) > 2147483647:
            raise ValueError("Invalid value for `query`, length must be less than `2147483647`")

        if len(query) < 3:
            raise ValueError("Invalid value for `query`, length must be greater than or equal to `3`")


        self._query = query

    @property
    def page_size(self) -> int:
        """
        Gets the page_size of this KnowledgeDocumentSearchRequest.
        Page size of the returned results.

        :return: The page_size of this KnowledgeDocumentSearchRequest.
        :rtype: int
        """
        return self._page_size

    @page_size.setter
    def page_size(self, page_size: int) -> None:
        """
        Sets the page_size of this KnowledgeDocumentSearchRequest.
        Page size of the returned results.

        :param page_size: The page_size of this KnowledgeDocumentSearchRequest.
        :type: int
        """
        

        self._page_size = page_size

    @property
    def page_number(self) -> int:
        """
        Gets the page_number of this KnowledgeDocumentSearchRequest.
        Page number of the returned results.

        :return: The page_number of this KnowledgeDocumentSearchRequest.
        :rtype: int
        """
        return self._page_number

    @page_number.setter
    def page_number(self, page_number: int) -> None:
        """
        Sets the page_number of this KnowledgeDocumentSearchRequest.
        Page number of the returned results.

        :param page_number: The page_number of this KnowledgeDocumentSearchRequest.
        :type: int
        """
        

        self._page_number = page_number

    @property
    def search_id(self) -> str:
        """
        Gets the search_id of this KnowledgeDocumentSearchRequest.
        The globally unique identifier for the search.

        :return: The search_id of this KnowledgeDocumentSearchRequest.
        :rtype: str
        """
        return self._search_id

    @search_id.setter
    def search_id(self, search_id: str) -> None:
        """
        Sets the search_id of this KnowledgeDocumentSearchRequest.
        The globally unique identifier for the search.

        :param search_id: The search_id of this KnowledgeDocumentSearchRequest.
        :type: str
        """
        

        self._search_id = search_id

    @property
    def total(self) -> int:
        """
        Gets the total of this KnowledgeDocumentSearchRequest.
        The total number of documents matching the query.

        :return: The total of this KnowledgeDocumentSearchRequest.
        :rtype: int
        """
        return self._total

    @total.setter
    def total(self, total: int) -> None:
        """
        Sets the total of this KnowledgeDocumentSearchRequest.
        The total number of documents matching the query.

        :param total: The total of this KnowledgeDocumentSearchRequest.
        :type: int
        """
        

        self._total = total

    @property
    def page_count(self) -> int:
        """
        Gets the page_count of this KnowledgeDocumentSearchRequest.
        Number of pages returned in the result calculated according to the pageSize and the total

        :return: The page_count of this KnowledgeDocumentSearchRequest.
        :rtype: int
        """
        return self._page_count

    @page_count.setter
    def page_count(self, page_count: int) -> None:
        """
        Sets the page_count of this KnowledgeDocumentSearchRequest.
        Number of pages returned in the result calculated according to the pageSize and the total

        :param page_count: The page_count of this KnowledgeDocumentSearchRequest.
        :type: int
        """
        

        self._page_count = page_count

    @property
    def query_type(self) -> str:
        """
        Gets the query_type of this KnowledgeDocumentSearchRequest.
        The type of the query that initiates the search.

        :return: The query_type of this KnowledgeDocumentSearchRequest.
        :rtype: str
        """
        return self._query_type

    @query_type.setter
    def query_type(self, query_type: str) -> None:
        """
        Sets the query_type of this KnowledgeDocumentSearchRequest.
        The type of the query that initiates the search.

        :param query_type: The query_type of this KnowledgeDocumentSearchRequest.
        :type: str
        """
        allowed_values = ["AutoSearch", "ManualSearch", "Suggestion"]
        if query_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for query_type -> " + query_type)
            self._query_type = "outdated_sdk_version"
        else:
            self._query_type = query_type

    @property
    def include_draft_documents(self) -> bool:
        """
        Gets the include_draft_documents of this KnowledgeDocumentSearchRequest.
        Indicates whether the search results would also include draft documents.

        :return: The include_draft_documents of this KnowledgeDocumentSearchRequest.
        :rtype: bool
        """
        return self._include_draft_documents

    @include_draft_documents.setter
    def include_draft_documents(self, include_draft_documents: bool) -> None:
        """
        Sets the include_draft_documents of this KnowledgeDocumentSearchRequest.
        Indicates whether the search results would also include draft documents.

        :param include_draft_documents: The include_draft_documents of this KnowledgeDocumentSearchRequest.
        :type: bool
        """
        

        self._include_draft_documents = include_draft_documents

    @property
    def interval(self) -> 'DocumentQueryInterval':
        """
        Gets the interval of this KnowledgeDocumentSearchRequest.
        Retrieves the documents created/modified/published in specified date and time range.

        :return: The interval of this KnowledgeDocumentSearchRequest.
        :rtype: DocumentQueryInterval
        """
        return self._interval

    @interval.setter
    def interval(self, interval: 'DocumentQueryInterval') -> None:
        """
        Sets the interval of this KnowledgeDocumentSearchRequest.
        Retrieves the documents created/modified/published in specified date and time range.

        :param interval: The interval of this KnowledgeDocumentSearchRequest.
        :type: DocumentQueryInterval
        """
        

        self._interval = interval

    @property
    def filter(self) -> 'DocumentQuery':
        """
        Gets the filter of this KnowledgeDocumentSearchRequest.
        Filter for the document search.

        :return: The filter of this KnowledgeDocumentSearchRequest.
        :rtype: DocumentQuery
        """
        return self._filter

    @filter.setter
    def filter(self, filter: 'DocumentQuery') -> None:
        """
        Sets the filter of this KnowledgeDocumentSearchRequest.
        Filter for the document search.

        :param filter: The filter of this KnowledgeDocumentSearchRequest.
        :type: DocumentQuery
        """
        

        self._filter = filter

    @property
    def sort_order(self) -> str:
        """
        Gets the sort_order of this KnowledgeDocumentSearchRequest.
        The sort order for search results.

        :return: The sort_order of this KnowledgeDocumentSearchRequest.
        :rtype: str
        """
        return self._sort_order

    @sort_order.setter
    def sort_order(self, sort_order: str) -> None:
        """
        Sets the sort_order of this KnowledgeDocumentSearchRequest.
        The sort order for search results.

        :param sort_order: The sort_order of this KnowledgeDocumentSearchRequest.
        :type: str
        """
        allowed_values = ["Asc", "Desc"]
        if sort_order.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for sort_order -> " + sort_order)
            self._sort_order = "outdated_sdk_version"
        else:
            self._sort_order = sort_order

    @property
    def sort_by(self) -> str:
        """
        Gets the sort_by of this KnowledgeDocumentSearchRequest.
        The field in the documents that you want to sort the search results by.

        :return: The sort_by of this KnowledgeDocumentSearchRequest.
        :rtype: str
        """
        return self._sort_by

    @sort_by.setter
    def sort_by(self, sort_by: str) -> None:
        """
        Sets the sort_by of this KnowledgeDocumentSearchRequest.
        The field in the documents that you want to sort the search results by.

        :param sort_by: The sort_by of this KnowledgeDocumentSearchRequest.
        :type: str
        """
        allowed_values = ["ConfidenceScore", "DateCreated", "DateModified", "CategoryName", "LabelName"]
        if sort_by.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for sort_by -> " + sort_by)
            self._sort_by = "outdated_sdk_version"
        else:
            self._sort_by = sort_by

    @property
    def application(self) -> 'KnowledgeSearchClientApplication':
        """
        Gets the application of this KnowledgeDocumentSearchRequest.
        The client application details from which search request was sent.

        :return: The application of this KnowledgeDocumentSearchRequest.
        :rtype: KnowledgeSearchClientApplication
        """
        return self._application

    @application.setter
    def application(self, application: 'KnowledgeSearchClientApplication') -> None:
        """
        Sets the application of this KnowledgeDocumentSearchRequest.
        The client application details from which search request was sent.

        :param application: The application of this KnowledgeDocumentSearchRequest.
        :type: KnowledgeSearchClientApplication
        """
        

        self._application = application

    @property
    def conversation_context(self) -> 'KnowledgeConversationContext':
        """
        Gets the conversation_context of this KnowledgeDocumentSearchRequest.
        Conversation context information if the search is initiated in the context of a conversation.

        :return: The conversation_context of this KnowledgeDocumentSearchRequest.
        :rtype: KnowledgeConversationContext
        """
        return self._conversation_context

    @conversation_context.setter
    def conversation_context(self, conversation_context: 'KnowledgeConversationContext') -> None:
        """
        Sets the conversation_context of this KnowledgeDocumentSearchRequest.
        Conversation context information if the search is initiated in the context of a conversation.

        :param conversation_context: The conversation_context of this KnowledgeDocumentSearchRequest.
        :type: KnowledgeConversationContext
        """
        

        self._conversation_context = conversation_context

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

