# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import JourneyWebActionEventsNotificationActionMap
    from . import JourneyWebActionEventsNotificationActionMapPageUrlCondition
    from . import JourneyWebActionEventsNotificationActionTarget
    from . import JourneyWebActionEventsNotificationEmergencyGroup
    from . import JourneyWebActionEventsNotificationEventAction
    from . import JourneyWebActionEventsNotificationScheduleGroup

class JourneyWebActionEventsNotificationBlockedWebActionOfferMessage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        JourneyWebActionEventsNotificationBlockedWebActionOfferMessage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'action': 'JourneyWebActionEventsNotificationEventAction',
            'action_map': 'JourneyWebActionEventsNotificationActionMap',
            'action_target': 'JourneyWebActionEventsNotificationActionTarget',
            'blocking_reason': 'str',
            'blocking_action_map': 'JourneyWebActionEventsNotificationActionMap',
            'blocking_action': 'JourneyWebActionEventsNotificationEventAction',
            'blocking_frequency_cap_behaviour': 'str',
            'blocking_page_url_conditions': 'list[JourneyWebActionEventsNotificationActionMapPageUrlCondition]',
            'blocking_schedule_group': 'JourneyWebActionEventsNotificationScheduleGroup',
            'blocking_emergency_schedule_group': 'JourneyWebActionEventsNotificationEmergencyGroup'
        }

        self.attribute_map = {
            'action': 'action',
            'action_map': 'actionMap',
            'action_target': 'actionTarget',
            'blocking_reason': 'blockingReason',
            'blocking_action_map': 'blockingActionMap',
            'blocking_action': 'blockingAction',
            'blocking_frequency_cap_behaviour': 'blockingFrequencyCapBehaviour',
            'blocking_page_url_conditions': 'blockingPageUrlConditions',
            'blocking_schedule_group': 'blockingScheduleGroup',
            'blocking_emergency_schedule_group': 'blockingEmergencyScheduleGroup'
        }

        self._action = None
        self._action_map = None
        self._action_target = None
        self._blocking_reason = None
        self._blocking_action_map = None
        self._blocking_action = None
        self._blocking_frequency_cap_behaviour = None
        self._blocking_page_url_conditions = None
        self._blocking_schedule_group = None
        self._blocking_emergency_schedule_group = None

    @property
    def action(self) -> 'JourneyWebActionEventsNotificationEventAction':
        """
        Gets the action of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.


        :return: The action of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.
        :rtype: JourneyWebActionEventsNotificationEventAction
        """
        return self._action

    @action.setter
    def action(self, action: 'JourneyWebActionEventsNotificationEventAction') -> None:
        """
        Sets the action of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.


        :param action: The action of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.
        :type: JourneyWebActionEventsNotificationEventAction
        """
        

        self._action = action

    @property
    def action_map(self) -> 'JourneyWebActionEventsNotificationActionMap':
        """
        Gets the action_map of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.


        :return: The action_map of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.
        :rtype: JourneyWebActionEventsNotificationActionMap
        """
        return self._action_map

    @action_map.setter
    def action_map(self, action_map: 'JourneyWebActionEventsNotificationActionMap') -> None:
        """
        Sets the action_map of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.


        :param action_map: The action_map of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.
        :type: JourneyWebActionEventsNotificationActionMap
        """
        

        self._action_map = action_map

    @property
    def action_target(self) -> 'JourneyWebActionEventsNotificationActionTarget':
        """
        Gets the action_target of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.


        :return: The action_target of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.
        :rtype: JourneyWebActionEventsNotificationActionTarget
        """
        return self._action_target

    @action_target.setter
    def action_target(self, action_target: 'JourneyWebActionEventsNotificationActionTarget') -> None:
        """
        Sets the action_target of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.


        :param action_target: The action_target of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.
        :type: JourneyWebActionEventsNotificationActionTarget
        """
        

        self._action_target = action_target

    @property
    def blocking_reason(self) -> str:
        """
        Gets the blocking_reason of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.


        :return: The blocking_reason of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.
        :rtype: str
        """
        return self._blocking_reason

    @blocking_reason.setter
    def blocking_reason(self, blocking_reason: str) -> None:
        """
        Sets the blocking_reason of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.


        :param blocking_reason: The blocking_reason of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.
        :type: str
        """
        allowed_values = ["Unknown", "PageUrlConditionsNotMatching", "ServiceLevelThrottling", "AlreadyExistingOffer", "TriggerDateInFuture", "MultipleSimultaneousOffers", "NoAvailableAgents", "FrequencyCapping", "OfferedOutsideSchedule"]
        if blocking_reason.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for blocking_reason -> " + blocking_reason)
            self._blocking_reason = "outdated_sdk_version"
        else:
            self._blocking_reason = blocking_reason

    @property
    def blocking_action_map(self) -> 'JourneyWebActionEventsNotificationActionMap':
        """
        Gets the blocking_action_map of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.


        :return: The blocking_action_map of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.
        :rtype: JourneyWebActionEventsNotificationActionMap
        """
        return self._blocking_action_map

    @blocking_action_map.setter
    def blocking_action_map(self, blocking_action_map: 'JourneyWebActionEventsNotificationActionMap') -> None:
        """
        Sets the blocking_action_map of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.


        :param blocking_action_map: The blocking_action_map of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.
        :type: JourneyWebActionEventsNotificationActionMap
        """
        

        self._blocking_action_map = blocking_action_map

    @property
    def blocking_action(self) -> 'JourneyWebActionEventsNotificationEventAction':
        """
        Gets the blocking_action of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.


        :return: The blocking_action of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.
        :rtype: JourneyWebActionEventsNotificationEventAction
        """
        return self._blocking_action

    @blocking_action.setter
    def blocking_action(self, blocking_action: 'JourneyWebActionEventsNotificationEventAction') -> None:
        """
        Sets the blocking_action of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.


        :param blocking_action: The blocking_action of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.
        :type: JourneyWebActionEventsNotificationEventAction
        """
        

        self._blocking_action = blocking_action

    @property
    def blocking_frequency_cap_behaviour(self) -> str:
        """
        Gets the blocking_frequency_cap_behaviour of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.


        :return: The blocking_frequency_cap_behaviour of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.
        :rtype: str
        """
        return self._blocking_frequency_cap_behaviour

    @blocking_frequency_cap_behaviour.setter
    def blocking_frequency_cap_behaviour(self, blocking_frequency_cap_behaviour: str) -> None:
        """
        Sets the blocking_frequency_cap_behaviour of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.


        :param blocking_frequency_cap_behaviour: The blocking_frequency_cap_behaviour of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.
        :type: str
        """
        allowed_values = ["Unknown", "CapOnceFinalized", "CapOnceRejected", "CapForPeriod"]
        if blocking_frequency_cap_behaviour.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for blocking_frequency_cap_behaviour -> " + blocking_frequency_cap_behaviour)
            self._blocking_frequency_cap_behaviour = "outdated_sdk_version"
        else:
            self._blocking_frequency_cap_behaviour = blocking_frequency_cap_behaviour

    @property
    def blocking_page_url_conditions(self) -> List['JourneyWebActionEventsNotificationActionMapPageUrlCondition']:
        """
        Gets the blocking_page_url_conditions of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.


        :return: The blocking_page_url_conditions of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.
        :rtype: list[JourneyWebActionEventsNotificationActionMapPageUrlCondition]
        """
        return self._blocking_page_url_conditions

    @blocking_page_url_conditions.setter
    def blocking_page_url_conditions(self, blocking_page_url_conditions: List['JourneyWebActionEventsNotificationActionMapPageUrlCondition']) -> None:
        """
        Sets the blocking_page_url_conditions of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.


        :param blocking_page_url_conditions: The blocking_page_url_conditions of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.
        :type: list[JourneyWebActionEventsNotificationActionMapPageUrlCondition]
        """
        

        self._blocking_page_url_conditions = blocking_page_url_conditions

    @property
    def blocking_schedule_group(self) -> 'JourneyWebActionEventsNotificationScheduleGroup':
        """
        Gets the blocking_schedule_group of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.


        :return: The blocking_schedule_group of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.
        :rtype: JourneyWebActionEventsNotificationScheduleGroup
        """
        return self._blocking_schedule_group

    @blocking_schedule_group.setter
    def blocking_schedule_group(self, blocking_schedule_group: 'JourneyWebActionEventsNotificationScheduleGroup') -> None:
        """
        Sets the blocking_schedule_group of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.


        :param blocking_schedule_group: The blocking_schedule_group of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.
        :type: JourneyWebActionEventsNotificationScheduleGroup
        """
        

        self._blocking_schedule_group = blocking_schedule_group

    @property
    def blocking_emergency_schedule_group(self) -> 'JourneyWebActionEventsNotificationEmergencyGroup':
        """
        Gets the blocking_emergency_schedule_group of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.


        :return: The blocking_emergency_schedule_group of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.
        :rtype: JourneyWebActionEventsNotificationEmergencyGroup
        """
        return self._blocking_emergency_schedule_group

    @blocking_emergency_schedule_group.setter
    def blocking_emergency_schedule_group(self, blocking_emergency_schedule_group: 'JourneyWebActionEventsNotificationEmergencyGroup') -> None:
        """
        Sets the blocking_emergency_schedule_group of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.


        :param blocking_emergency_schedule_group: The blocking_emergency_schedule_group of this JourneyWebActionEventsNotificationBlockedWebActionOfferMessage.
        :type: JourneyWebActionEventsNotificationEmergencyGroup
        """
        

        self._blocking_emergency_schedule_group = blocking_emergency_schedule_group

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

