# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import FormsTrackTrigger
    from . import IdleEventTrigger
    from . import ScrollPercentageEventTrigger
    from . import SelectorEventTrigger

class JourneyEventsSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        JourneyEventsSettings - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'enabled': 'bool',
            'excluded_query_parameters': 'list[str]',
            'should_keep_url_fragment': 'bool',
            'search_query_parameters': 'list[str]',
            'pageview_config': 'str',
            'click_events': 'list[SelectorEventTrigger]',
            'forms_track_events': 'list[FormsTrackTrigger]',
            'idle_events': 'list[IdleEventTrigger]',
            'in_viewport_events': 'list[SelectorEventTrigger]',
            'scroll_depth_events': 'list[ScrollPercentageEventTrigger]'
        }

        self.attribute_map = {
            'enabled': 'enabled',
            'excluded_query_parameters': 'excludedQueryParameters',
            'should_keep_url_fragment': 'shouldKeepUrlFragment',
            'search_query_parameters': 'searchQueryParameters',
            'pageview_config': 'pageviewConfig',
            'click_events': 'clickEvents',
            'forms_track_events': 'formsTrackEvents',
            'idle_events': 'idleEvents',
            'in_viewport_events': 'inViewportEvents',
            'scroll_depth_events': 'scrollDepthEvents'
        }

        self._enabled = None
        self._excluded_query_parameters = None
        self._should_keep_url_fragment = None
        self._search_query_parameters = None
        self._pageview_config = None
        self._click_events = None
        self._forms_track_events = None
        self._idle_events = None
        self._in_viewport_events = None
        self._scroll_depth_events = None

    @property
    def enabled(self) -> bool:
        """
        Gets the enabled of this JourneyEventsSettings.
        Whether or not journey event collection is enabled.

        :return: The enabled of this JourneyEventsSettings.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled: bool) -> None:
        """
        Sets the enabled of this JourneyEventsSettings.
        Whether or not journey event collection is enabled.

        :param enabled: The enabled of this JourneyEventsSettings.
        :type: bool
        """
        

        self._enabled = enabled

    @property
    def excluded_query_parameters(self) -> List[str]:
        """
        Gets the excluded_query_parameters of this JourneyEventsSettings.
        List of parameters to be excluded from the query string.

        :return: The excluded_query_parameters of this JourneyEventsSettings.
        :rtype: list[str]
        """
        return self._excluded_query_parameters

    @excluded_query_parameters.setter
    def excluded_query_parameters(self, excluded_query_parameters: List[str]) -> None:
        """
        Sets the excluded_query_parameters of this JourneyEventsSettings.
        List of parameters to be excluded from the query string.

        :param excluded_query_parameters: The excluded_query_parameters of this JourneyEventsSettings.
        :type: list[str]
        """
        

        self._excluded_query_parameters = excluded_query_parameters

    @property
    def should_keep_url_fragment(self) -> bool:
        """
        Gets the should_keep_url_fragment of this JourneyEventsSettings.
        Whether or not to keep the URL fragment.

        :return: The should_keep_url_fragment of this JourneyEventsSettings.
        :rtype: bool
        """
        return self._should_keep_url_fragment

    @should_keep_url_fragment.setter
    def should_keep_url_fragment(self, should_keep_url_fragment: bool) -> None:
        """
        Sets the should_keep_url_fragment of this JourneyEventsSettings.
        Whether or not to keep the URL fragment.

        :param should_keep_url_fragment: The should_keep_url_fragment of this JourneyEventsSettings.
        :type: bool
        """
        

        self._should_keep_url_fragment = should_keep_url_fragment

    @property
    def search_query_parameters(self) -> List[str]:
        """
        Gets the search_query_parameters of this JourneyEventsSettings.
        List of query parameters used for search (e.g. 'q').

        :return: The search_query_parameters of this JourneyEventsSettings.
        :rtype: list[str]
        """
        return self._search_query_parameters

    @search_query_parameters.setter
    def search_query_parameters(self, search_query_parameters: List[str]) -> None:
        """
        Sets the search_query_parameters of this JourneyEventsSettings.
        List of query parameters used for search (e.g. 'q').

        :param search_query_parameters: The search_query_parameters of this JourneyEventsSettings.
        :type: list[str]
        """
        

        self._search_query_parameters = search_query_parameters

    @property
    def pageview_config(self) -> str:
        """
        Gets the pageview_config of this JourneyEventsSettings.
        Controls how the pageview events are tracked.

        :return: The pageview_config of this JourneyEventsSettings.
        :rtype: str
        """
        return self._pageview_config

    @pageview_config.setter
    def pageview_config(self, pageview_config: str) -> None:
        """
        Sets the pageview_config of this JourneyEventsSettings.
        Controls how the pageview events are tracked.

        :param pageview_config: The pageview_config of this JourneyEventsSettings.
        :type: str
        """
        allowed_values = ["Auto", "Once", "Off"]
        if pageview_config.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for pageview_config -> " + pageview_config)
            self._pageview_config = "outdated_sdk_version"
        else:
            self._pageview_config = pageview_config

    @property
    def click_events(self) -> List['SelectorEventTrigger']:
        """
        Gets the click_events of this JourneyEventsSettings.
        Tracks when and where a visitor clicks on a webpage.

        :return: The click_events of this JourneyEventsSettings.
        :rtype: list[SelectorEventTrigger]
        """
        return self._click_events

    @click_events.setter
    def click_events(self, click_events: List['SelectorEventTrigger']) -> None:
        """
        Sets the click_events of this JourneyEventsSettings.
        Tracks when and where a visitor clicks on a webpage.

        :param click_events: The click_events of this JourneyEventsSettings.
        :type: list[SelectorEventTrigger]
        """
        

        self._click_events = click_events

    @property
    def forms_track_events(self) -> List['FormsTrackTrigger']:
        """
        Gets the forms_track_events of this JourneyEventsSettings.
        Controls how the form submitted and form abandoned events are tracked after a visitor interacts with a form element.

        :return: The forms_track_events of this JourneyEventsSettings.
        :rtype: list[FormsTrackTrigger]
        """
        return self._forms_track_events

    @forms_track_events.setter
    def forms_track_events(self, forms_track_events: List['FormsTrackTrigger']) -> None:
        """
        Sets the forms_track_events of this JourneyEventsSettings.
        Controls how the form submitted and form abandoned events are tracked after a visitor interacts with a form element.

        :param forms_track_events: The forms_track_events of this JourneyEventsSettings.
        :type: list[FormsTrackTrigger]
        """
        

        self._forms_track_events = forms_track_events

    @property
    def idle_events(self) -> List['IdleEventTrigger']:
        """
        Gets the idle_events of this JourneyEventsSettings.
        Tracks when and where a visitor becomes inactive on a webpage.

        :return: The idle_events of this JourneyEventsSettings.
        :rtype: list[IdleEventTrigger]
        """
        return self._idle_events

    @idle_events.setter
    def idle_events(self, idle_events: List['IdleEventTrigger']) -> None:
        """
        Sets the idle_events of this JourneyEventsSettings.
        Tracks when and where a visitor becomes inactive on a webpage.

        :param idle_events: The idle_events of this JourneyEventsSettings.
        :type: list[IdleEventTrigger]
        """
        

        self._idle_events = idle_events

    @property
    def in_viewport_events(self) -> List['SelectorEventTrigger']:
        """
        Gets the in_viewport_events of this JourneyEventsSettings.
        Tracks when elements become visible or hidden on screen.

        :return: The in_viewport_events of this JourneyEventsSettings.
        :rtype: list[SelectorEventTrigger]
        """
        return self._in_viewport_events

    @in_viewport_events.setter
    def in_viewport_events(self, in_viewport_events: List['SelectorEventTrigger']) -> None:
        """
        Sets the in_viewport_events of this JourneyEventsSettings.
        Tracks when elements become visible or hidden on screen.

        :param in_viewport_events: The in_viewport_events of this JourneyEventsSettings.
        :type: list[SelectorEventTrigger]
        """
        

        self._in_viewport_events = in_viewport_events

    @property
    def scroll_depth_events(self) -> List['ScrollPercentageEventTrigger']:
        """
        Gets the scroll_depth_events of this JourneyEventsSettings.
        Tracks when a visitor scrolls to a specific percentage of a webpage.

        :return: The scroll_depth_events of this JourneyEventsSettings.
        :rtype: list[ScrollPercentageEventTrigger]
        """
        return self._scroll_depth_events

    @scroll_depth_events.setter
    def scroll_depth_events(self, scroll_depth_events: List['ScrollPercentageEventTrigger']) -> None:
        """
        Sets the scroll_depth_events of this JourneyEventsSettings.
        Tracks when a visitor scrolls to a specific percentage of a webpage.

        :param scroll_depth_events: The scroll_depth_events of this JourneyEventsSettings.
        :type: list[ScrollPercentageEventTrigger]
        """
        

        self._scroll_depth_events = scroll_depth_events

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

