# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class GamificationStatus(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        GamificationStatus - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'is_active': 'bool',
            'date_start': 'date',
            'automatic_user_assignment': 'bool',
            'date_start_personal_best': 'date'
        }

        self.attribute_map = {
            'is_active': 'isActive',
            'date_start': 'dateStart',
            'automatic_user_assignment': 'automaticUserAssignment',
            'date_start_personal_best': 'dateStartPersonalBest'
        }

        self._is_active = None
        self._date_start = None
        self._automatic_user_assignment = None
        self._date_start_personal_best = None

    @property
    def is_active(self) -> bool:
        """
        Gets the is_active of this GamificationStatus.
        Gamification status of the organization.

        :return: The is_active of this GamificationStatus.
        :rtype: bool
        """
        return self._is_active

    @is_active.setter
    def is_active(self, is_active: bool) -> None:
        """
        Sets the is_active of this GamificationStatus.
        Gamification status of the organization.

        :param is_active: The is_active of this GamificationStatus.
        :type: bool
        """
        

        self._is_active = is_active

    @property
    def date_start(self) -> date:
        """
        Gets the date_start of this GamificationStatus.
        Gamification start date. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_start of this GamificationStatus.
        :rtype: date
        """
        return self._date_start

    @date_start.setter
    def date_start(self, date_start: date) -> None:
        """
        Sets the date_start of this GamificationStatus.
        Gamification start date. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_start: The date_start of this GamificationStatus.
        :type: date
        """
        

        self._date_start = date_start

    @property
    def automatic_user_assignment(self) -> bool:
        """
        Gets the automatic_user_assignment of this GamificationStatus.
        Automatic assignment of users to the default profile

        :return: The automatic_user_assignment of this GamificationStatus.
        :rtype: bool
        """
        return self._automatic_user_assignment

    @automatic_user_assignment.setter
    def automatic_user_assignment(self, automatic_user_assignment: bool) -> None:
        """
        Sets the automatic_user_assignment of this GamificationStatus.
        Automatic assignment of users to the default profile

        :param automatic_user_assignment: The automatic_user_assignment of this GamificationStatus.
        :type: bool
        """
        

        self._automatic_user_assignment = automatic_user_assignment

    @property
    def date_start_personal_best(self) -> date:
        """
        Gets the date_start_personal_best of this GamificationStatus.
        Personal best aggregation starting date. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_start_personal_best of this GamificationStatus.
        :rtype: date
        """
        return self._date_start_personal_best

    @date_start_personal_best.setter
    def date_start_personal_best(self, date_start_personal_best: date) -> None:
        """
        Sets the date_start_personal_best of this GamificationStatus.
        Personal best aggregation starting date. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_start_personal_best: The date_start_personal_best of this GamificationStatus.
        :type: date
        """
        

        self._date_start_personal_best = date_start_personal_best

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

