# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import Section

class FieldConfig(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        FieldConfig - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'entity_type': 'str',
            'state': 'str',
            'sections': 'list[Section]',
            'version': 'str',
            'schema_version': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'entity_type': 'entityType',
            'state': 'state',
            'sections': 'sections',
            'version': 'version',
            'schema_version': 'schemaVersion',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._entity_type = None
        self._state = None
        self._sections = None
        self._version = None
        self._schema_version = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this FieldConfig.
        The globally unique identifier for the object.

        :return: The id of this FieldConfig.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this FieldConfig.
        The globally unique identifier for the object.

        :param id: The id of this FieldConfig.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this FieldConfig.


        :return: The name of this FieldConfig.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this FieldConfig.


        :param name: The name of this FieldConfig.
        :type: str
        """
        

        self._name = name

    @property
    def entity_type(self) -> str:
        """
        Gets the entity_type of this FieldConfig.


        :return: The entity_type of this FieldConfig.
        :rtype: str
        """
        return self._entity_type

    @entity_type.setter
    def entity_type(self, entity_type: str) -> None:
        """
        Sets the entity_type of this FieldConfig.


        :param entity_type: The entity_type of this FieldConfig.
        :type: str
        """
        allowed_values = ["person", "group", "org", "externalContact"]
        if entity_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for entity_type -> " + entity_type)
            self._entity_type = "outdated_sdk_version"
        else:
            self._entity_type = entity_type

    @property
    def state(self) -> str:
        """
        Gets the state of this FieldConfig.


        :return: The state of this FieldConfig.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this FieldConfig.


        :param state: The state of this FieldConfig.
        :type: str
        """
        

        self._state = state

    @property
    def sections(self) -> List['Section']:
        """
        Gets the sections of this FieldConfig.


        :return: The sections of this FieldConfig.
        :rtype: list[Section]
        """
        return self._sections

    @sections.setter
    def sections(self, sections: List['Section']) -> None:
        """
        Sets the sections of this FieldConfig.


        :param sections: The sections of this FieldConfig.
        :type: list[Section]
        """
        

        self._sections = sections

    @property
    def version(self) -> str:
        """
        Gets the version of this FieldConfig.


        :return: The version of this FieldConfig.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version: str) -> None:
        """
        Sets the version of this FieldConfig.


        :param version: The version of this FieldConfig.
        :type: str
        """
        

        self._version = version

    @property
    def schema_version(self) -> str:
        """
        Gets the schema_version of this FieldConfig.


        :return: The schema_version of this FieldConfig.
        :rtype: str
        """
        return self._schema_version

    @schema_version.setter
    def schema_version(self, schema_version: str) -> None:
        """
        Sets the schema_version of this FieldConfig.


        :param schema_version: The schema_version of this FieldConfig.
        :type: str
        """
        

        self._schema_version = schema_version

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this FieldConfig.
        The URI for this object

        :return: The self_uri of this FieldConfig.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this FieldConfig.
        The URI for this object

        :param self_uri: The self_uri of this FieldConfig.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

