# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class FaxSendResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        FaxSendResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'upload_destination_uri': 'str',
            'upload_method_type': 'str',
            'headers': 'dict(str, str)',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'upload_destination_uri': 'uploadDestinationUri',
            'upload_method_type': 'uploadMethodType',
            'headers': 'headers',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._upload_destination_uri = None
        self._upload_method_type = None
        self._headers = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this FaxSendResponse.
        The globally unique identifier for the object.

        :return: The id of this FaxSendResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this FaxSendResponse.
        The globally unique identifier for the object.

        :param id: The id of this FaxSendResponse.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this FaxSendResponse.


        :return: The name of this FaxSendResponse.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this FaxSendResponse.


        :param name: The name of this FaxSendResponse.
        :type: str
        """
        

        self._name = name

    @property
    def upload_destination_uri(self) -> str:
        """
        Gets the upload_destination_uri of this FaxSendResponse.


        :return: The upload_destination_uri of this FaxSendResponse.
        :rtype: str
        """
        return self._upload_destination_uri

    @upload_destination_uri.setter
    def upload_destination_uri(self, upload_destination_uri: str) -> None:
        """
        Sets the upload_destination_uri of this FaxSendResponse.


        :param upload_destination_uri: The upload_destination_uri of this FaxSendResponse.
        :type: str
        """
        

        self._upload_destination_uri = upload_destination_uri

    @property
    def upload_method_type(self) -> str:
        """
        Gets the upload_method_type of this FaxSendResponse.


        :return: The upload_method_type of this FaxSendResponse.
        :rtype: str
        """
        return self._upload_method_type

    @upload_method_type.setter
    def upload_method_type(self, upload_method_type: str) -> None:
        """
        Sets the upload_method_type of this FaxSendResponse.


        :param upload_method_type: The upload_method_type of this FaxSendResponse.
        :type: str
        """
        allowed_values = ["SINGLE_PUT", "MULTIPART_POST"]
        if upload_method_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for upload_method_type -> " + upload_method_type)
            self._upload_method_type = "outdated_sdk_version"
        else:
            self._upload_method_type = upload_method_type

    @property
    def headers(self) -> Dict[str, str]:
        """
        Gets the headers of this FaxSendResponse.


        :return: The headers of this FaxSendResponse.
        :rtype: dict(str, str)
        """
        return self._headers

    @headers.setter
    def headers(self, headers: Dict[str, str]) -> None:
        """
        Sets the headers of this FaxSendResponse.


        :param headers: The headers of this FaxSendResponse.
        :type: dict(str, str)
        """
        

        self._headers = headers

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this FaxSendResponse.
        The URI for this object

        :return: The self_uri of this FaxSendResponse.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this FaxSendResponse.
        The URI for this object

        :param self_uri: The self_uri of this FaxSendResponse.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

