# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import LocalizedLabels

class CustomI18nLabels(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        CustomI18nLabels - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'language': 'str',
            'localized_labels': 'list[LocalizedLabels]'
        }

        self.attribute_map = {
            'language': 'language',
            'localized_labels': 'localizedLabels'
        }

        self._language = None
        self._localized_labels = None

    @property
    def language(self) -> str:
        """
        Gets the language of this CustomI18nLabels.
        Language of localized labels in homescreen app (eg. en-us, de-de)

        :return: The language of this CustomI18nLabels.
        :rtype: str
        """
        return self._language

    @language.setter
    def language(self, language: str) -> None:
        """
        Sets the language of this CustomI18nLabels.
        Language of localized labels in homescreen app (eg. en-us, de-de)

        :param language: The language of this CustomI18nLabels.
        :type: str
        """
        

        self._language = language

    @property
    def localized_labels(self) -> List['LocalizedLabels']:
        """
        Gets the localized_labels of this CustomI18nLabels.
        Contains localized labels used in homescreen app

        :return: The localized_labels of this CustomI18nLabels.
        :rtype: list[LocalizedLabels]
        """
        return self._localized_labels

    @localized_labels.setter
    def localized_labels(self, localized_labels: List['LocalizedLabels']) -> None:
        """
        Sets the localized_labels of this CustomI18nLabels.
        Contains localized labels used in homescreen app

        :param localized_labels: The localized_labels of this CustomI18nLabels.
        :type: list[LocalizedLabels]
        """
        

        self._localized_labels = localized_labels

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

