# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class ContactColumnConditionSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ContactColumnConditionSettings - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'column_name': 'str',
            'operator': 'str',
            'value': 'str',
            'value_type': 'str'
        }

        self.attribute_map = {
            'column_name': 'columnName',
            'operator': 'operator',
            'value': 'value',
            'value_type': 'valueType'
        }

        self._column_name = None
        self._operator = None
        self._value = None
        self._value_type = None

    @property
    def column_name(self) -> str:
        """
        Gets the column_name of this ContactColumnConditionSettings.
        The name of the contact list column to evaluate.

        :return: The column_name of this ContactColumnConditionSettings.
        :rtype: str
        """
        return self._column_name

    @column_name.setter
    def column_name(self, column_name: str) -> None:
        """
        Sets the column_name of this ContactColumnConditionSettings.
        The name of the contact list column to evaluate.

        :param column_name: The column_name of this ContactColumnConditionSettings.
        :type: str
        """
        

        self._column_name = column_name

    @property
    def operator(self) -> str:
        """
        Gets the operator of this ContactColumnConditionSettings.
        The operator to use when comparing values.

        :return: The operator of this ContactColumnConditionSettings.
        :rtype: str
        """
        return self._operator

    @operator.setter
    def operator(self, operator: str) -> None:
        """
        Sets the operator of this ContactColumnConditionSettings.
        The operator to use when comparing values.

        :param operator: The operator of this ContactColumnConditionSettings.
        :type: str
        """
        allowed_values = ["Equals", "LessThan", "LessThanEquals", "GreaterThan", "GreaterThanEquals", "Contains", "BeginsWith", "EndsWith", "Before", "After"]
        if operator.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for operator -> " + operator)
            self._operator = "outdated_sdk_version"
        else:
            self._operator = operator

    @property
    def value(self) -> str:
        """
        Gets the value of this ContactColumnConditionSettings.
        The value to compare against the contact's data.

        :return: The value of this ContactColumnConditionSettings.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value: str) -> None:
        """
        Sets the value of this ContactColumnConditionSettings.
        The value to compare against the contact's data.

        :param value: The value of this ContactColumnConditionSettings.
        :type: str
        """
        

        self._value = value

    @property
    def value_type(self) -> str:
        """
        Gets the value_type of this ContactColumnConditionSettings.
        The data type the value should be treated as.

        :return: The value_type of this ContactColumnConditionSettings.
        :rtype: str
        """
        return self._value_type

    @value_type.setter
    def value_type(self, value_type: str) -> None:
        """
        Sets the value_type of this ContactColumnConditionSettings.
        The data type the value should be treated as.

        :param value_type: The value_type of this ContactColumnConditionSettings.
        :type: str
        """
        allowed_values = ["DateTime", "Numeric", "Period", "String"]
        if value_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for value_type -> " + value_type)
            self._value_type = "outdated_sdk_version"
        else:
            self._value_type = value_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

