# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ChatMessageUser

class ChatMessage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ChatMessage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'body': 'str',
            'id': 'str',
            'to': 'str',
            'pcFrom': 'str',
            'utc': 'str',
            'chat': 'str',
            'message': 'str',
            'type': 'str',
            'body_type': 'str',
            'sender_communication_id': 'str',
            'participant_purpose': 'str',
            'user': 'ChatMessageUser'
        }

        self.attribute_map = {
            'body': 'body',
            'id': 'id',
            'to': 'to',
            'pcFrom': 'from',
            'utc': 'utc',
            'chat': 'chat',
            'message': 'message',
            'type': 'type',
            'body_type': 'bodyType',
            'sender_communication_id': 'senderCommunicationId',
            'participant_purpose': 'participantPurpose',
            'user': 'user'
        }

        self._body = None
        self._id = None
        self._to = None
        self._pcFrom = None
        self._utc = None
        self._chat = None
        self._message = None
        self._type = None
        self._body_type = None
        self._sender_communication_id = None
        self._participant_purpose = None
        self._user = None

    @property
    def body(self) -> str:
        """
        Gets the body of this ChatMessage.
        The message body

        :return: The body of this ChatMessage.
        :rtype: str
        """
        return self._body

    @body.setter
    def body(self, body: str) -> None:
        """
        Sets the body of this ChatMessage.
        The message body

        :param body: The body of this ChatMessage.
        :type: str
        """
        

        self._body = body

    @property
    def id(self) -> str:
        """
        Gets the id of this ChatMessage.


        :return: The id of this ChatMessage.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ChatMessage.


        :param id: The id of this ChatMessage.
        :type: str
        """
        

        self._id = id

    @property
    def to(self) -> str:
        """
        Gets the to of this ChatMessage.
        The message recipient

        :return: The to of this ChatMessage.
        :rtype: str
        """
        return self._to

    @to.setter
    def to(self, to: str) -> None:
        """
        Sets the to of this ChatMessage.
        The message recipient

        :param to: The to of this ChatMessage.
        :type: str
        """
        

        self._to = to

    @property
    def pcFrom(self) -> str:
        """
        Gets the pcFrom of this ChatMessage.
        The message sender

        :return: The pcFrom of this ChatMessage.
        :rtype: str
        """
        return self._pcFrom

    @pcFrom.setter
    def pcFrom(self, pcFrom: str) -> None:
        """
        Sets the pcFrom of this ChatMessage.
        The message sender

        :param pcFrom: The pcFrom of this ChatMessage.
        :type: str
        """
        

        self._pcFrom = pcFrom

    @property
    def utc(self) -> str:
        """
        Gets the utc of this ChatMessage.


        :return: The utc of this ChatMessage.
        :rtype: str
        """
        return self._utc

    @utc.setter
    def utc(self, utc: str) -> None:
        """
        Sets the utc of this ChatMessage.


        :param utc: The utc of this ChatMessage.
        :type: str
        """
        

        self._utc = utc

    @property
    def chat(self) -> str:
        """
        Gets the chat of this ChatMessage.
        The interaction id (if available)

        :return: The chat of this ChatMessage.
        :rtype: str
        """
        return self._chat

    @chat.setter
    def chat(self, chat: str) -> None:
        """
        Sets the chat of this ChatMessage.
        The interaction id (if available)

        :param chat: The chat of this ChatMessage.
        :type: str
        """
        

        self._chat = chat

    @property
    def message(self) -> str:
        """
        Gets the message of this ChatMessage.
        The message id

        :return: The message of this ChatMessage.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message: str) -> None:
        """
        Sets the message of this ChatMessage.
        The message id

        :param message: The message of this ChatMessage.
        :type: str
        """
        

        self._message = message

    @property
    def type(self) -> str:
        """
        Gets the type of this ChatMessage.


        :return: The type of this ChatMessage.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this ChatMessage.


        :param type: The type of this ChatMessage.
        :type: str
        """
        

        self._type = type

    @property
    def body_type(self) -> str:
        """
        Gets the body_type of this ChatMessage.
        Type of the message body (v2 chats only)

        :return: The body_type of this ChatMessage.
        :rtype: str
        """
        return self._body_type

    @body_type.setter
    def body_type(self, body_type: str) -> None:
        """
        Sets the body_type of this ChatMessage.
        Type of the message body (v2 chats only)

        :param body_type: The body_type of this ChatMessage.
        :type: str
        """
        allowed_values = ["STANDARD", "ACTIVITY", "TYPING", "NOTICE", "MEMBERJOIN", "MEMBERLEAVE", "MEDIAREQUEST"]
        if body_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for body_type -> " + body_type)
            self._body_type = "outdated_sdk_version"
        else:
            self._body_type = body_type

    @property
    def sender_communication_id(self) -> str:
        """
        Gets the sender_communication_id of this ChatMessage.
        Communication of sender (v2 chats only)

        :return: The sender_communication_id of this ChatMessage.
        :rtype: str
        """
        return self._sender_communication_id

    @sender_communication_id.setter
    def sender_communication_id(self, sender_communication_id: str) -> None:
        """
        Sets the sender_communication_id of this ChatMessage.
        Communication of sender (v2 chats only)

        :param sender_communication_id: The sender_communication_id of this ChatMessage.
        :type: str
        """
        

        self._sender_communication_id = sender_communication_id

    @property
    def participant_purpose(self) -> str:
        """
        Gets the participant_purpose of this ChatMessage.
        Participant purpose of sender (v2 chats only)

        :return: The participant_purpose of this ChatMessage.
        :rtype: str
        """
        return self._participant_purpose

    @participant_purpose.setter
    def participant_purpose(self, participant_purpose: str) -> None:
        """
        Sets the participant_purpose of this ChatMessage.
        Participant purpose of sender (v2 chats only)

        :param participant_purpose: The participant_purpose of this ChatMessage.
        :type: str
        """
        

        self._participant_purpose = participant_purpose

    @property
    def user(self) -> 'ChatMessageUser':
        """
        Gets the user of this ChatMessage.
        The user information for the sender (if available)

        :return: The user of this ChatMessage.
        :rtype: ChatMessageUser
        """
        return self._user

    @user.setter
    def user(self, user: 'ChatMessageUser') -> None:
        """
        Sets the user of this ChatMessage.
        The user information for the sender (if available)

        :param user: The user of this ChatMessage.
        :type: ChatMessageUser
        """
        

        self._user = user

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

