# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ChatBadgeTopicBadgeEntity

class ChatBadgeTopicChatBadge(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ChatBadgeTopicChatBadge - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'entity': 'ChatBadgeTopicBadgeEntity',
            'unread_count': 'int',
            'last_unread_notification_date': 'datetime'
        }

        self.attribute_map = {
            'entity': 'entity',
            'unread_count': 'unreadCount',
            'last_unread_notification_date': 'lastUnreadNotificationDate'
        }

        self._entity = None
        self._unread_count = None
        self._last_unread_notification_date = None

    @property
    def entity(self) -> 'ChatBadgeTopicBadgeEntity':
        """
        Gets the entity of this ChatBadgeTopicChatBadge.


        :return: The entity of this ChatBadgeTopicChatBadge.
        :rtype: ChatBadgeTopicBadgeEntity
        """
        return self._entity

    @entity.setter
    def entity(self, entity: 'ChatBadgeTopicBadgeEntity') -> None:
        """
        Sets the entity of this ChatBadgeTopicChatBadge.


        :param entity: The entity of this ChatBadgeTopicChatBadge.
        :type: ChatBadgeTopicBadgeEntity
        """
        

        self._entity = entity

    @property
    def unread_count(self) -> int:
        """
        Gets the unread_count of this ChatBadgeTopicChatBadge.


        :return: The unread_count of this ChatBadgeTopicChatBadge.
        :rtype: int
        """
        return self._unread_count

    @unread_count.setter
    def unread_count(self, unread_count: int) -> None:
        """
        Sets the unread_count of this ChatBadgeTopicChatBadge.


        :param unread_count: The unread_count of this ChatBadgeTopicChatBadge.
        :type: int
        """
        

        self._unread_count = unread_count

    @property
    def last_unread_notification_date(self) -> datetime:
        """
        Gets the last_unread_notification_date of this ChatBadgeTopicChatBadge.


        :return: The last_unread_notification_date of this ChatBadgeTopicChatBadge.
        :rtype: datetime
        """
        return self._last_unread_notification_date

    @last_unread_notification_date.setter
    def last_unread_notification_date(self, last_unread_notification_date: datetime) -> None:
        """
        Sets the last_unread_notification_date of this ChatBadgeTopicChatBadge.


        :param last_unread_notification_date: The last_unread_notification_date of this ChatBadgeTopicChatBadge.
        :type: datetime
        """
        

        self._last_unread_notification_date = last_unread_notification_date

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

