# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import WfmScheduleReference

class AvailableTime(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AvailableTime - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'date_start': 'datetime',
            'length_in_minutes': 'int',
            'is_paid': 'bool',
            'activity_category': 'str',
            'wfm_schedule': 'WfmScheduleReference'
        }

        self.attribute_map = {
            'date_start': 'dateStart',
            'length_in_minutes': 'lengthInMinutes',
            'is_paid': 'isPaid',
            'activity_category': 'activityCategory',
            'wfm_schedule': 'wfmSchedule'
        }

        self._date_start = None
        self._length_in_minutes = None
        self._is_paid = None
        self._activity_category = None
        self._wfm_schedule = None

    @property
    def date_start(self) -> datetime:
        """
        Gets the date_start of this AvailableTime.
        Start of the availability period. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_start of this AvailableTime.
        :rtype: datetime
        """
        return self._date_start

    @date_start.setter
    def date_start(self, date_start: datetime) -> None:
        """
        Sets the date_start of this AvailableTime.
        Start of the availability period. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_start: The date_start of this AvailableTime.
        :type: datetime
        """
        

        self._date_start = date_start

    @property
    def length_in_minutes(self) -> int:
        """
        Gets the length_in_minutes of this AvailableTime.
        Length of availability period in minutes

        :return: The length_in_minutes of this AvailableTime.
        :rtype: int
        """
        return self._length_in_minutes

    @length_in_minutes.setter
    def length_in_minutes(self, length_in_minutes: int) -> None:
        """
        Sets the length_in_minutes of this AvailableTime.
        Length of availability period in minutes

        :param length_in_minutes: The length_in_minutes of this AvailableTime.
        :type: int
        """
        

        self._length_in_minutes = length_in_minutes

    @property
    def is_paid(self) -> bool:
        """
        Gets the is_paid of this AvailableTime.
        Indicates if this availability period is paid in Workforce Management schedule

        :return: The is_paid of this AvailableTime.
        :rtype: bool
        """
        return self._is_paid

    @is_paid.setter
    def is_paid(self, is_paid: bool) -> None:
        """
        Sets the is_paid of this AvailableTime.
        Indicates if this availability period is paid in Workforce Management schedule

        :param is_paid: The is_paid of this AvailableTime.
        :type: bool
        """
        

        self._is_paid = is_paid

    @property
    def activity_category(self) -> str:
        """
        Gets the activity_category of this AvailableTime.
        Workforce Management activity category for this availability period

        :return: The activity_category of this AvailableTime.
        :rtype: str
        """
        return self._activity_category

    @activity_category.setter
    def activity_category(self, activity_category: str) -> None:
        """
        Sets the activity_category of this AvailableTime.
        Workforce Management activity category for this availability period

        :param activity_category: The activity_category of this AvailableTime.
        :type: str
        """
        allowed_values = ["OnQueueWork", "Break", "Meal", "Meeting", "OffQueueWork", "TimeOff", "Training", "Unavailable"]
        if activity_category.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for activity_category -> " + activity_category)
            self._activity_category = "outdated_sdk_version"
        else:
            self._activity_category = activity_category

    @property
    def wfm_schedule(self) -> 'WfmScheduleReference':
        """
        Gets the wfm_schedule of this AvailableTime.
        Workforce Management schedule information associated with the available time

        :return: The wfm_schedule of this AvailableTime.
        :rtype: WfmScheduleReference
        """
        return self._wfm_schedule

    @wfm_schedule.setter
    def wfm_schedule(self, wfm_schedule: 'WfmScheduleReference') -> None:
        """
        Sets the wfm_schedule of this AvailableTime.
        Workforce Management schedule information associated with the available time

        :param wfm_schedule: The wfm_schedule of this AvailableTime.
        :type: WfmScheduleReference
        """
        

        self._wfm_schedule = wfm_schedule

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

